#define DISK_IMG_WIDTH 16
#define DISK_IMG_HEIGHT 16

unsigned short int disk_img[] = {
0x3357, 0x3357, 0x3357, 0x3357, 0x3357, 0x3357, 0x3357, 0x3357, 0x3357, 0x3b77, 0x3b77, 
0x3b77, 0x3b57, 0x3b97, 0x3356, 0x0000, 0x3357, 0xd71e, 0xd71e, 0xffdf, 0xf7df, 0xf7df, 
0xf7bf, 0xef9f, 0xef9f, 0xf7df, 0xf7df, 0xef9f, 0xdf5f, 0xbe9d, 0x5c59, 0x3356, 0x3357, 
0xd6fe, 0x855d, 0xf7df, 0xf7df, 0x6479, 0xef9f, 0xef9f, 0xf7bf, 0xffdf, 0xf7bf, 0xe77f, 
0xdf3f, 0xbe9d, 0xbe9d, 0x3b97, 0x3357, 0xd6fe, 0x7d5d, 0xf7bf, 0xf7bf, 0x6479, 0xef9f, 
0xefbf, 0xf7df, 0xf7df, 0xef9f, 0xdf5f, 0xdf3e, 0x7d1c, 0xc6bd, 0x3356, 0x3357, 0xcefe, 
0x7d5c, 0xef9f, 0xef9f, 0x6479, 0xef9f, 0xf7df, 0xffdf, 0xefbf, 0xdf5f, 0xdf3e, 0xdf3e, 
0x7d1c, 0xae1c, 0x3356, 0x3357, 0xcefe, 0x7d3c, 0xe77f, 0xe77f, 0xe77f, 0xefbf, 0xf7df, 
0xf7bf, 0xe77f, 0xdf3e, 0xdf3e, 0xdf3e, 0x751b, 0xa5fc, 0x3336, 0x3357, 0xc6de, 0x7d3c, 
0x6479, 0x6479, 0x6479, 0x6c99, 0x6c99, 0x6c99, 0x6479, 0x6479, 0x6479, 0x6479, 0x74fb, 
0x9ddc, 0x3336, 0x3357, 0xc6de, 0x7d3c, 0x7d1c, 0x7d3c, 0x7d3c, 0x7d1c, 0x7d1c, 0x7d1c, 
0x751b, 0x74fb, 0x74fb, 0x74fb, 0x74fb, 0x9dbb, 0x3336, 0x3357, 0xc6be, 0x7d1c, 0x7d1c, 
0x7d1c, 0x7d1c, 0x7d3c, 0x7d1c, 0x7d1c, 0x751b, 0x74fb, 0x74fb, 0x74db, 0x74db, 0x959b, 
0x3335, 0x3357, 0xbe9e, 0x7d1c, 0x7d1c, 0x7d1c, 0x7d1c, 0x7d1c, 0x7d1c, 0x74fb, 0x74fb, 
0x74fb, 0x74db, 0x74db, 0x74da, 0x8d5a, 0x3315, 0x3357, 0xbe9d, 0x7d1c, 0xffdf, 0xffdf, 
0xffdf, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 0x6cba, 0x8d3a, 0x3315, 
0x3b57, 0xbe7d, 0x7d1c, 0xf7df, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 
0x8e0c, 0xf7df, 0x6c99, 0x8519, 0x3315, 0x3b77, 0xb67d, 0x7d1c, 0xf7df, 0xc6f7, 0xc6f7, 
0xc6f7, 0xc6f7, 0xc6f7, 0xc6f7, 0xc6f7, 0xc6f7, 0xf7df, 0x6c99, 0x84f9, 0x3315, 0x3357, 
0xb65d, 0x7d1c, 0xf7df, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 0x8e0c, 
0xf7df, 0x6479, 0x7cd9, 0x3314, 0x3357, 0xae3d, 0xae3d, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 
0xffdf, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 0xffdf, 0x7cd9, 0x7cd8, 0x3314, 0x3357, 0x3357, 
0x3357, 0x3356, 0x3356, 0x3336, 0x3336, 0x3336, 0x3335, 0x3315, 0x3315, 0x3315, 0x3315, 
0x3314, 0x3314, 0x3315};

void Draw16x16Image(unsigned short *Screen, int x, int y, unsigned short *Img) {

	Screen = &Screen[(320 * y) + x];	

	asm volatile (
		"	mov	r0, #16			\n"
		"1:					\n"
	#define FN()  \
			"	ldr	r1, [%[image]], #4	\n"\
			"	str	r1, [%[screen]], #4 	\n"

		FN()
		FN()
		FN()
		FN()
		FN()
		FN()
		FN()
		FN()

		// Loop	
		"	add	%[screen], %[screen], #(640 - (16 * 2))	\n" 
		"	subs 	r0, r0, #1	\n"
		"	bne	1b"
		// output
		: 	// none	
		// input
		: [screen] "r" (Screen),
		  [image] "r" (Img)
		// clobbered
		: "r0", "r1", "cc" // r8 & flags 				
		);
#undef FN

}

void Draw16x16Square(unsigned short *Screen, int x, int y, unsigned char r, unsigned char g, unsigned char b) {

	Screen = &Screen[(320 * y) + x];	
	int color = (((((unsigned int )r) * 0x1f) >> 8) << 11) | 
		    (((((unsigned int )g) * 0x3f) >> 8) << 5) | 
		     ((((unsigned int )b) * 0x1f) >> 8);
	color = color | (color << 16);

	asm volatile (
		"	mov	r0, #16			\n"
		"1:					\n"
	#define FN()  \
			"	str	%[color], [%[screen]], #4 	\n"

		FN()
		FN()
		FN()
		FN()
		FN()
		FN()
		FN()
		FN()

		// Loop	
		"	add	%[screen], %[screen], #(640 - (16 * 2))	\n" 
		"	subs 	r0, r0, #1	\n"
		"	bne	1b"
		// output
		: 	// none	
		// input
		: [screen] "r" (Screen),
		  [color] "r" (color)
		// clobbered
		: "r0", "cc" // r8 & flags 				
		);
#undef FN

}
