/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.ITypeBinding;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingDirect
extends MappingBase {
    private final DirectObject m_mappingImpl;
    private final BoundClass m_boundClass;
    private final boolean m_isAbstract;
    private boolean m_isGenerated;

    public MappingDirect(IContainer contain, String type, String tname, DirectObject dir, boolean abs) throws JiBXException {
        super(contain, type, tname, dir);
        this.m_mappingImpl = dir;
        this.m_boundClass = BoundClass.getInstance(type, null);
        this.m_isAbstract = abs;
    }

    @Override
    public BoundClass getBoundClass() {
        return this.m_boundClass;
    }

    @Override
    public String getBoundType() {
        return this.m_mappingImpl.getTargetClass().getName();
    }

    @Override
    public String getReferenceType() {
        return this.getBoundType();
    }

    @Override
    public IComponent getImplComponent() {
        return this.m_component;
    }

    @Override
    public ClassFile getMarshaller() throws JiBXException {
        return this.m_mappingImpl.getMarshaller();
    }

    @Override
    public ClassFile getUnmarshaller() throws JiBXException {
        return this.m_mappingImpl.getUnmarshaller();
    }

    @Override
    public NameDefinition getName() {
        return this.m_mappingImpl.getWrapperName();
    }

    @Override
    public void addNamespace(NamespaceDefinition ns) {
        throw new IllegalStateException("Internal error: no namespace definition possible");
    }

    @Override
    public boolean isAbstract() {
        return this.m_isAbstract;
    }

    @Override
    public boolean isBase() {
        return false;
    }

    @Override
    public void addExtension(MappingDefinition mdef) {
        throw new IllegalStateException("Internal error: no extension possible");
    }

    @Override
    public IComponent buildRef(IContainer parent, IContextObj objc, String type, PropertyDefinition prop) throws JiBXException {
        return new DirectProperty(prop, this.m_mappingImpl);
    }

    @Override
    public ArrayList getNamespaces() {
        return null;
    }

    @Override
    public void generateCode(boolean force) throws JiBXException {
        if (!this.m_isGenerated) {
            if (this.m_boundClass.isLimitedDirectAccess()) {
                this.addIMarshallableMethod();
                this.addIUnmarshallableMethod();
            }
            this.m_isGenerated = true;
        }
    }

    @Override
    public NameDefinition getWrapperName() {
        return null;
    }

    @Override
    public void setLinkages() throws JiBXException {
        this.m_mappingImpl.setLinkages();
    }

    @Override
    public ITypeBinding getBinding() {
        return null;
    }

    @Override
    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.println("mapping direct " + this.m_mappingImpl.getTargetClass().getName());
    }
}

