/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.rat.api.Document;
import org.apache.rat.config.exclusion.ExclusionUtils;
import org.apache.rat.document.DocumentName;
import org.apache.rat.document.DocumentNameMatcher;

public class FileDocument
extends Document {
    private final File file;

    public FileDocument(DocumentName basedir, File file, DocumentNameMatcher nameMatcher) {
        super(new DocumentName(file, basedir), nameMatcher);
        this.file = file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public SortedSet<Document> listChildren() {
        if (this.isDirectory()) {
            TreeSet<Document> result = new TreeSet<Document>();
            File[] lst = this.file.listFiles(ExclusionUtils.asFileFilter(this.name, this.nameMatcher));
            if (lst != null && lst.length > 0) {
                Arrays.stream(lst).map(f -> new FileDocument(this.name, (File)f, this.nameMatcher)).forEach(result::add);
            }
            return result;
        }
        return Collections.emptySortedSet();
    }

    @Override
    public InputStream inputStream() throws IOException {
        return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
    }
}

