/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.DoublesUnionBuilder;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesUnionBuilderTest {
    @Test
    public void checkBuilds() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        WritableMemory dstMem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        qs1.putMemory(dstMem);
        WritableMemory srcMem = dstMem;
        DoublesUnionBuilder bldr = new DoublesUnionBuilder();
        bldr.setMaxK(128);
        DoublesUnion union = bldr.build();
        union = DoublesUnion.heapify((Memory)srcMem);
        UpdateDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((int)qs1.getCurrentCompactSerializedSizeBytes(), (int)qs2.getCurrentCompactSerializedSizeBytes());
        union = DoublesUnion.heapify((DoublesSketch)qs2);
        UpdateDoublesSketch qs3 = union.getResult();
        Assert.assertEquals((int)qs2.getCurrentCompactSerializedSizeBytes(), (int)qs3.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((qs2 == qs3 ? 1 : 0) != 0);
    }

    @Test
    public void checkDeprecated1() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        WritableMemory dstMem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        qs1.putMemory(dstMem);
        WritableMemory srcMem = dstMem;
        DoublesUnionBuilder bldr = new DoublesUnionBuilder();
        bldr.setMaxK(128);
        DoublesUnion union = bldr.build();
        union = DoublesUnion.heapify((Memory)srcMem);
        UpdateDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((int)qs1.getCurrentCompactSerializedSizeBytes(), (int)qs2.getCurrentCompactSerializedSizeBytes());
        Assert.assertEquals((int)qs1.getCurrentUpdatableSerializedSizeBytes(), (int)qs2.getCurrentUpdatableSerializedSizeBytes());
        union = DoublesUnion.heapify((DoublesSketch)qs2);
        UpdateDoublesSketch qs3 = union.getResult();
        Assert.assertEquals((int)qs2.getCurrentCompactSerializedSizeBytes(), (int)qs3.getCurrentCompactSerializedSizeBytes());
        Assert.assertEquals((int)qs2.getCurrentUpdatableSerializedSizeBytes(), (int)qs3.getCurrentUpdatableSerializedSizeBytes());
        Assert.assertFalse((qs2 == qs3 ? 1 : 0) != 0);
    }

    @Test
    public void printlnTest() {
        DoublesUnionBuilderTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

