package org.apache.torque.avalon;
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.avalon.framework.component.ComponentException;
import org.apache.fulcrum.testcontainer.BaseUnitTest;
import org.apache.torque.BaseDatabaseTestCase;
import org.apache.torque.TorqueException;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.test.peer.AuthorPeer;

/**
 * Testing of the correct MapBuilder handling of the Torque Avalon Component
 *
 * @author <a href="mailto:tv@apache.org">Thomas Vandahl</a>
 * @version $Id: AvalonMapBuildersTest.java 1402307 2012-10-25 19:57:24Z tfischer $
 */
public class AvalonMapBuildersTest extends BaseUnitTest
{
    private Torque torque = null;
    private org.apache.torque.TorqueInstance instance = null;

    /**
     * Constructor for test.
     *
     * @param testName name of the test being executed
     */
    public AvalonMapBuildersTest(String name)
    {
        super( name );

        // trigger static constructor before Torque initialization
        AuthorPeer.getAuthorPeerImpl();

        // store old instance for comparison
        instance = org.apache.torque.Torque.getInstance();
    }

    public void setUp() throws Exception
    {
        super.setUp();
        if (!org.apache.torque.Torque.isInit())
        {
            org.apache.torque.Torque.init(System.getProperty(
                    BaseDatabaseTestCase.CONFIG_FILE_SYSTEM_PROPERTY));
        }
        setConfigurationFileName("src/test/resources/TestComponentConfig.xml");
        setRoleFileName("src/test/resources/TestRoleConfig.xml");
        try
        {
            torque = (Torque) this.resolve(Torque.ROLE);
        }
        catch (ComponentException e)
        {
            e.printStackTrace();
            fail(e.getMessage());
        }
    }

    /**
     * Verifies that the MapBuilder is available in the DatabaseMap.
     */
    public void testMapBuilder()
    {
        DatabaseMap dbMap = null;

        try
        {
            dbMap = torque.getDatabaseMap(AuthorPeer.DATABASE_NAME);
        }
        catch (TorqueException e)
        {
            fail(e.getMessage());
        }

        assertTrue("Table author should be in the DatabaseMap",
                dbMap.containsTable(AuthorPeer.TABLE_NAME));
        assertFalse("Torque instances should be different", torque == instance);
    }
}
