/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.template;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponse;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyResponseImpl;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.ldap.client.template.PasswordPolicyOperation;
import org.apache.directory.ldap.client.template.PasswordPolicyResponder;
import org.apache.directory.ldap.client.template.PasswordWarning;
import org.apache.directory.ldap.client.template.PasswordWarningImpl;
import org.apache.directory.ldap.client.template.exception.PasswordException;

public abstract class AbstractPasswordPolicyResponder
implements PasswordPolicyResponder {
    private final PasswordPolicyResponse passwordPolicyResponseControl = new PasswordPolicyResponseImpl();

    protected AbstractPasswordPolicyResponder(LdapApiService ldapApiService) {
    }

    protected PasswordException exception(LdapException e) {
        return new PasswordException().setLdapException(e);
    }

    protected PasswordException fail(ResultResponse resultResponse, PasswordPolicyResponse passwordPolicyResponse, ResultCodeEnum resultCode) {
        String diagnosticMessage = "";
        if (resultResponse != null && resultResponse.getLdapResult() != null) {
            diagnosticMessage = resultResponse.getLdapResult().getDiagnosticMessage();
        }
        PasswordException exception = new PasswordException(diagnosticMessage);
        exception.setResultCode(resultCode);
        if (passwordPolicyResponse != null && passwordPolicyResponse.getPasswordPolicyError() != null) {
            exception.setPasswordPolicyError(passwordPolicyResponse.getPasswordPolicyError());
        }
        return exception;
    }

    private PasswordPolicyResponse getPasswordPolicy(Response response) {
        Control control = (Control)response.getControls().get(this.passwordPolicyResponseControl.getOid());
        return control == null ? null : (PasswordPolicyResponse)control;
    }

    @Override
    public final PasswordWarning process(PasswordPolicyOperation operation) throws PasswordException {
        try {
            ResultResponse response = operation.process();
            PasswordPolicyResponse passwordPolicyResponse = this.getPasswordPolicy((Response)response);
            ResultCodeEnum resultCode = response.getLdapResult().getResultCode();
            if (resultCode == ResultCodeEnum.SUCCESS) {
                return this.success(passwordPolicyResponse);
            }
            throw this.fail(response, passwordPolicyResponse, resultCode);
        }
        catch (LdapException e) {
            throw new PasswordException().setLdapException(e);
        }
    }

    protected PasswordWarning success(PasswordPolicyResponse passwordPolicyResponse) {
        return passwordPolicyResponse == null ? null : PasswordWarningImpl.newWarning(passwordPolicyResponse);
    }
}

