/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import javax.servlet.Servlet;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.AbstractMapping;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpService;

public final class ServletMapping
extends AbstractMapping {
    private final Servlet servlet;
    private final String alias;

    public ServletMapping(Bundle bundle, Servlet servlet, String alias) {
        super(bundle);
        this.servlet = servlet;
        this.alias = alias;
    }

    public void register(HttpService httpService) {
        if (!this.isRegistered() && this.getContext() != null) {
            try {
                httpService.registerServlet(this.alias, this.servlet, this.getInitParams(), this.getContext());
                this.setRegistered(true);
            }
            catch (Exception e) {
                SystemLogger.warning("Failed to register servlet for " + this.alias, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(HttpService httpService) {
        if (this.isRegistered()) {
            try {
                httpService.unregister(this.alias);
            }
            catch (Exception e) {
                SystemLogger.debug("Failed to unregister servlet for " + this.alias, e);
            }
            finally {
                this.setRegistered(false);
            }
        }
    }

    String getAlias() {
        return this.alias;
    }

    Servlet getServlet() {
        return this.servlet;
    }
}

