/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.service.ServletContextImpl;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public final class ServletContextManager {
    private final Bundle bundle;
    private final ServletContext context;
    private final Map<HttpContext, ExtServletContext> contextMap;
    private final boolean sharedAttributes;
    private final PerContextHandlerRegistry handlerRegistry;

    public ServletContextManager(Bundle bundle, ServletContext context, boolean sharedAttributes, PerContextHandlerRegistry registry) {
        this.bundle = bundle;
        this.context = context;
        this.contextMap = new WeakHashMap<HttpContext, ExtServletContext>();
        this.sharedAttributes = sharedAttributes;
        this.handlerRegistry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtServletContext getServletContext(HttpContext httpContext) {
        ExtServletContext context;
        Map<HttpContext, ExtServletContext> map = this.contextMap;
        synchronized (map) {
            context = this.contextMap.get(httpContext);
            if (context == null) {
                context = this.addServletContext(httpContext);
            }
        }
        return context;
    }

    private ExtServletContext addServletContext(HttpContext httpContext) {
        ServletContextImpl context = new ServletContextImpl(this.bundle, this.context, httpContext, this.sharedAttributes, this.handlerRegistry);
        this.contextMap.put(httpContext, context);
        return context;
    }
}

