/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.List;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.dependency.impl.ServiceReferenceManager;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.apache.felix.ipojo.handlers.dependency.DependencyDescription;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.ServiceReference;

public class DependencyHandlerDescription
extends HandlerDescription {
    private DependencyDescription[] m_dependencies = new DependencyDescription[0];

    public DependencyHandlerDescription(DependencyHandler handler, Dependency[] deps) {
        super(handler);
        this.m_dependencies = new DependencyDescription[deps.length];
        for (int i = 0; i < this.m_dependencies.length; ++i) {
            this.m_dependencies[i] = new DependencyDescription(deps[i]);
        }
    }

    public DependencyDescription[] getDependencies() {
        return this.m_dependencies;
    }

    public Element getHandlerInfo() {
        Element deps = super.getHandlerInfo();
        for (DependencyDescription dependency : this.m_dependencies) {
            ServiceReference ref2;
            ServiceReferenceManager serviceReferenceManager;
            Element use;
            String state = "resolved";
            if (dependency.getState() == 0) {
                state = "unresolved";
            }
            if (dependency.getState() == -1) {
                state = "broken";
            }
            Element dep = new Element("Requires", "");
            dep.addAttribute(new Attribute("Specification", dependency.getInterface()));
            dep.addAttribute(new Attribute("Id", dependency.getId()));
            if (dependency.getFilter() != null) {
                dep.addAttribute(new Attribute("Filter", dependency.getFilter()));
            }
            if (dependency.isOptional()) {
                dep.addAttribute(new Attribute("Optional", "true"));
                if (dependency.supportsNullable()) {
                    dep.addAttribute(new Attribute("Nullable", "true"));
                }
                if (dependency.getDefaultImplementation() != null) {
                    dep.addAttribute(new Attribute("Default-Implementation", dependency.getDefaultImplementation()));
                }
            } else {
                dep.addAttribute(new Attribute("Optional", "false"));
            }
            if (dependency.isMultiple()) {
                dep.addAttribute(new Attribute("Aggregate", "true"));
            } else {
                dep.addAttribute(new Attribute("Aggregate", "false"));
            }
            if (dependency.isProxy()) {
                dep.addAttribute(new Attribute("Proxy", "true"));
            } else {
                dep.addAttribute(new Attribute("Proxy", "false"));
            }
            String policy = "dynamic";
            if (dependency.getPolicy() == 1) {
                policy = "static";
            } else if (dependency.getPolicy() == 2) {
                policy = "dynamic-priority";
            }
            dep.addAttribute(new Attribute("Binding-Policy", policy));
            if (dependency.getComparator() != null) {
                dep.addAttribute(new Attribute("Comparator", dependency.getComparator()));
            }
            dep.addAttribute(new Attribute("State", state));
            List<ServiceReference> set = dependency.getUsedServices();
            if (set != null) {
                for (ServiceReference serviceReference : set) {
                    use = new Element("Uses", "");
                    this.computeServiceReferenceDescription(serviceReference, use);
                    dep.addElement(use);
                }
            }
            if ((set = dependency.getServiceReferences()) != null) {
                for (ServiceReference serviceReference : set) {
                    use = new Element("Selected", "");
                    this.computeServiceReferenceDescription(serviceReference, use);
                    dep.addElement(use);
                }
            }
            if ((serviceReferenceManager = dependency.getDependency().getServiceReferenceManager()) == null) {
                deps.addElement(dep);
                continue;
            }
            set = serviceReferenceManager.getMatchingServices();
            if (set != null) {
                for (ServiceReference ref2 : set) {
                    Element use2 = new Element("Matches", "");
                    this.computeServiceReferenceDescription(ref2, use2);
                    dep.addElement(use2);
                }
            }
            List<ServiceReference> list = serviceReferenceManager.getTrackingInterceptorReferences();
            for (ServiceReference ref3 : list) {
                Element itcp = new Element("ServiceTrackingInterceptor", "");
                this.computeInterceptorDescription(ref3, itcp);
                dep.addElement(itcp);
            }
            ref2 = serviceReferenceManager.getRankingInterceptorReference();
            if (ref2 != null) {
                Element itcp = new Element("ServiceRankingInterceptor", "");
                this.computeInterceptorDescription(ref2, itcp);
                dep.addElement(itcp);
            }
            List<ServiceReference> list2 = serviceReferenceManager.getBindingInterceptorReferences();
            for (ServiceReference rf : list2) {
                Element itcp = new Element("ServiceBindingInterceptor", "");
                this.computeInterceptorDescription(rf, itcp);
                dep.addElement(itcp);
            }
            deps.addElement(dep);
        }
        return deps;
    }

    private void computeServiceReferenceDescription(ServiceReference ref, Element use) {
        use.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
        String instance = (String)ref.getProperty("instance.name");
        if (instance != null) {
            use.addAttribute(new Attribute("instance.name", instance));
        }
    }

    private void computeInterceptorDescription(ServiceReference ref, Element itcp) {
        itcp.addAttribute(new Attribute("service.id", ref.getProperty("service.id").toString()));
        itcp.addAttribute(new Attribute("bundle.id", Long.toString(ref.getBundle().getBundleId())));
        String instance = (String)ref.getProperty("instance.name");
        if (instance != null) {
            itcp.addAttribute(new Attribute("instance.name", instance));
        }
        itcp.addAttribute(new Attribute("target", ref.getProperty("target").toString()));
    }
}

