/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.util.Comparator;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.ServiceReferenceRankingComparator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class DependencyMetadataHelper {
    public static Comparator getComparator(Element dep, BundleContext context) throws ConfigurationException {
        Comparator<ServiceReference> cmp = null;
        String comp = dep.getAttribute("comparator");
        if (comp != null) {
            if (comp.equalsIgnoreCase("osgi")) {
                cmp = new ServiceReferenceRankingComparator();
            } else {
                try {
                    Class cla = context.getBundle().loadClass(comp);
                    cmp = (Comparator)cla.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Cannot load a customized comparator", e);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationException("Cannot create a customized comparator", e);
                }
                catch (InstantiationException e) {
                    throw new ConfigurationException("Cannot create a customized comparator", e);
                }
            }
        }
        return cmp;
    }

    public static Class loadSpecification(String specification, BundleContext context) throws ConfigurationException {
        Class spec;
        try {
            spec = context.getBundle().loadClass(specification);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("A required specification cannot be loaded : " + specification, e);
        }
        return spec;
    }

    public static int getPolicy(Element dep) throws ConfigurationException {
        String policy = dep.getAttribute("policy");
        if (policy == null || policy.equalsIgnoreCase("dynamic")) {
            return 0;
        }
        if (policy.equalsIgnoreCase("dynamic-priority")) {
            return 2;
        }
        if (policy.equalsIgnoreCase("static")) {
            return 1;
        }
        throw new ConfigurationException("Binding policy unknown : " + policy);
    }
}

