/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.CircularDependencyException;
import aQute.bnd.build.Container;
import aQute.bnd.build.ProjectBuilder;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.build.ProjectTester;
import aQute.bnd.build.ReflectAction;
import aQute.bnd.build.ResolverMode;
import aQute.bnd.build.ScriptAction;
import aQute.bnd.build.Workspace;
import aQute.bnd.help.Syntax;
import aQute.bnd.maven.support.Pom;
import aQute.bnd.maven.support.ProjectPom;
import aQute.bnd.service.CommandPlugin;
import aQute.bnd.service.DependencyContributor;
import aQute.bnd.service.Deploy;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.Scripter;
import aQute.bnd.service.action.Action;
import aQute.bnd.service.action.NamedAction;
import aQute.lib.io.IO;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.libg.generics.Create;
import aQute.libg.header.OSGiHeader;
import aQute.libg.sed.Sed;
import aQute.libg.version.Version;
import aQute.libg.version.VersionRange;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project
extends Processor {
    static final String DEFAULT_ACTIONS = "build; label='Build', test; label='Test', run; label='Run', clean; label='Clean', release; label='Release', refreshAll; label=Refresh, deploy;label=Deploy";
    public static final String BNDFILE = "bnd.bnd";
    public static final String BNDCNF = "cnf";
    final Workspace workspace;
    boolean preparedPaths;
    final Collection<Project> dependson = new LinkedHashSet<Project>();
    final Collection<Container> buildpath = new LinkedHashSet<Container>();
    final Collection<Container> testpath = new LinkedHashSet<Container>();
    final Collection<Container> runpath = new LinkedHashSet<Container>();
    final Collection<Container> runbundles = new LinkedHashSet<Container>();
    File runstorage;
    final Collection<File> sourcepath = new LinkedHashSet<File>();
    final Collection<File> allsourcepath = new LinkedHashSet<File>();
    final Collection<Container> bootclasspath = new LinkedHashSet<Container>();
    final Lock lock = new ReentrantLock(true);
    volatile String lockingReason;
    volatile Thread lockingThread;
    File output;
    File target;
    boolean inPrepare;
    int revision;
    File[] files;
    private long buildtime;
    static List<Project> trail = new ArrayList<Project>();
    boolean delayRunDependencies = false;

    public Project(Workspace workspace, File projectDir, File buildFile) throws Exception {
        super(workspace);
        this.workspace = workspace;
        this.setFileMustExist(false);
        this.setProperties(buildFile);
        assert (workspace != null);
        this.readBuildProperties();
    }

    public Project(Workspace workspace, File buildDir) throws Exception {
        this(workspace, buildDir, new File(buildDir, BNDFILE));
    }

    private void readBuildProperties() throws Exception {
        try {
            File f = this.getFile("build.properties");
            if (f.isFile()) {
                Properties p = this.loadProperties(f);
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    String newkey = key = (String)e.nextElement();
                    if (key.indexOf(36) >= 0) {
                        newkey = this.getReplacer().process(key);
                    }
                    this.setProperty(newkey, p.getProperty(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Project getUnparented(File propertiesFile) throws Exception {
        propertiesFile = propertiesFile.getAbsoluteFile();
        Workspace workspace = new Workspace(propertiesFile.getParentFile());
        Project project = new Project(workspace, propertiesFile.getParentFile());
        project.setProperties(propertiesFile);
        project.setFileMustExist(true);
        return project;
    }

    public synchronized boolean isValid() {
        return this.getBase().isDirectory() && this.getPropertiesFile().isFile();
    }

    public synchronized ProjectBuilder getBuilder(ProjectBuilder parent) throws Exception {
        ProjectBuilder builder = parent == null ? new ProjectBuilder(this) : new ProjectBuilder(parent);
        builder.setBase(this.getBase());
        return builder;
    }

    public synchronized int getChanged() {
        return this.revision;
    }

    public synchronized void setChanged() {
        this.preparedPaths = false;
        this.files = null;
        ++this.revision;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public String toString() {
        return this.getBase().getName();
    }

    public synchronized void prepare() throws Exception {
        block23: {
            if (!this.isValid()) {
                this.warning("Invalid project attempts to prepare: %s", this);
                return;
            }
            if (this.inPrepare) {
                throw new CircularDependencyException(String.valueOf(trail.toString()) + "," + this);
            }
            trail.add(this);
            try {
                if (this.preparedPaths) break block23;
                this.inPrepare = true;
                try {
                    String runStorageStr;
                    File src;
                    this.dependson.clear();
                    this.buildpath.clear();
                    this.sourcepath.clear();
                    this.allsourcepath.clear();
                    this.bootclasspath.clear();
                    this.testpath.clear();
                    this.runpath.clear();
                    this.runbundles.clear();
                    this.setProperty("basedir", this.getBase().getAbsolutePath());
                    if (!this.getPropertiesFile().isFile() && new File(this.getBase(), ".classpath").isFile()) {
                        this.doEclipseClasspath();
                    }
                    if ((src = this.getSrc()).isDirectory()) {
                        this.sourcepath.add(src);
                        this.allsourcepath.add(src);
                    } else {
                        this.sourcepath.add(this.getBase());
                    }
                    this.output = this.getFile(this.getProperty("bin", "bin")).getAbsoluteFile();
                    if (!this.output.exists()) {
                        this.output.mkdirs();
                        this.getWorkspace().changedFile(this.output);
                    }
                    if (!this.output.isDirectory()) {
                        this.error("Can not find output directory: " + this.output, new Object[0]);
                    } else if (!this.buildpath.contains(this.output)) {
                        this.buildpath.add(new Container(this, this.output));
                    }
                    this.target = this.getFile(this.getProperty("target", "generated"));
                    if (!this.target.exists()) {
                        this.target.mkdirs();
                        this.getWorkspace().changedFile(this.target);
                    }
                    this.runstorage = (runStorageStr = this.getProperty("-runstorage")) != null ? this.getFile(runStorageStr) : null;
                    ArrayList<Project> dependencies = new ArrayList<Project>();
                    String dp = this.getProperty("-dependson");
                    Set<String> requiredProjectNames = this.parseHeader(dp).keySet();
                    List<DependencyContributor> dcs = this.getPlugins(DependencyContributor.class);
                    for (DependencyContributor dc : dcs) {
                        dc.addDependencies(this, requiredProjectNames);
                    }
                    for (String p : requiredProjectNames) {
                        Project required = this.getWorkspace().getProject(p);
                        if (required == null) {
                            this.error("No such project " + required + " on " + "-dependson", new Object[0]);
                            continue;
                        }
                        dependencies.add(required);
                    }
                    this.doPath(this.buildpath, dependencies, this.parseBuildpath(), this.bootclasspath);
                    this.doPath(this.testpath, dependencies, this.parseTestpath(), this.bootclasspath);
                    if (!this.delayRunDependencies) {
                        this.doPath(this.runpath, dependencies, this.parseRunpath(), null);
                        this.doPath(this.runbundles, dependencies, this.parseRunbundles(), null);
                    }
                    HashSet<Project> done = new HashSet<Project>();
                    done.add(this);
                    this.allsourcepath.addAll(this.sourcepath);
                    for (Project project : dependencies) {
                        project.traverse(this.dependson, done);
                    }
                    for (Project project : this.dependson) {
                        this.allsourcepath.addAll(project.getSourcePath());
                    }
                    if (this.isOk()) {
                        this.preparedPaths = true;
                    }
                }
                finally {
                    this.inPrepare = false;
                }
            }
            finally {
                trail.remove(this);
            }
        }
    }

    public File getSrc() {
        return new File(this.getBase(), this.getProperty("src", "src"));
    }

    private void traverse(Collection<Project> dependencies, Set<Project> visited) throws Exception {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        for (Project project : this.getDependson()) {
            project.traverse(dependencies, visited);
        }
        dependencies.add(this);
    }

    private void doPath(Collection<Container> resultpath, Collection<Project> projects, Collection<Container> entries, Collection<Container> bootclasspath) {
        for (Container cpe : entries) {
            if (cpe.getError() != null) {
                this.error(cpe.getError(), new Object[0]);
                continue;
            }
            if (cpe.getType() == Container.TYPE.PROJECT) {
                projects.add(cpe.getProject());
            }
            if (bootclasspath != null && cpe.getBundleSymbolicName().startsWith("ee.") || cpe.getAttributes().containsKey("boot")) {
                bootclasspath.add(cpe);
                continue;
            }
            resultpath.add(cpe);
        }
    }

    private List<Container> parseBuildpath() throws Exception {
        List<Container> bundles = this.getBundles(RepositoryPlugin.Strategy.LOWEST, this.getProperty("-buildpath"), "-buildpath");
        this.appendPackages(RepositoryPlugin.Strategy.LOWEST, this.getProperty("-buildpackages"), bundles, ResolverMode.build);
        return bundles;
    }

    private List<Container> parseRunpath() throws Exception {
        return this.getBundles(RepositoryPlugin.Strategy.HIGHEST, this.getProperty("-runpath"), "-runpath");
    }

    private List<Container> parseRunbundles() throws Exception {
        return this.getBundles(RepositoryPlugin.Strategy.HIGHEST, this.getProperty("-runbundles"), "-runbundles");
    }

    private List<Container> parseTestpath() throws Exception {
        return this.getBundles(RepositoryPlugin.Strategy.HIGHEST, this.getProperty("-testpath"), "-testpath");
    }

    /*
     * Unable to fully structure code
     */
    public List<Container> getBundles(RepositoryPlugin.Strategy strategyx, String spec, String source) throws Exception {
        result = new ArrayList<Container>();
        bundles = this.parseHeader(spec);
        try {
            for (Map.Entry<String, Map<String, String>> entry : bundles.entrySet()) {
                block15: {
                    bsn = entry.getKey();
                    attrs = entry.getValue();
                    found = null;
                    if (bsn.equals("pom")) {
                        this.doMavenPom(strategyx, result, attrs.get("scope"));
                        continue;
                    }
                    versionRange = attrs.get("version");
                    if (versionRange != null && (versionRange.equals("latest") || versionRange.equals("snapshot"))) {
                        found = this.getBundle(bsn, versionRange, strategyx, attrs);
                    }
                    if (found != null) break block15;
                    if (versionRange == null || !versionRange.equals("project") && !versionRange.equals("latest")) ** GOTO lbl23
                    project = this.getWorkspace().getProject(bsn);
                    if (project != null && project.exists()) {
                        f = project.getOutput();
                        found = new Container(project, bsn, versionRange, Container.TYPE.PROJECT, f, null, attrs);
                    } else {
                        this.error("Reference to project that does not exist in workspace\n  Project       %s\n  Specification %s", new Object[]{bsn, spec});
                        continue;
lbl23:
                        // 1 sources

                        if (versionRange != null && versionRange.equals("file")) {
                            f = this.getFile(bsn);
                            error = null;
                            if (!f.exists()) {
                                error = "File does not exist: " + f.getAbsolutePath();
                            }
                            found = f.getName().endsWith(".lib") ? new Container(this, bsn, "file", Container.TYPE.LIBRARY, f, error, attrs) : new Container(this, bsn, "file", Container.TYPE.EXTERNAL, f, error, attrs);
                        } else {
                            found = this.getBundle(bsn, versionRange, strategyx, attrs);
                        }
                    }
                }
                if (found != null) {
                    libs = found.getMembers();
                    for (Container cc : libs) {
                        if (result.contains(cc)) {
                            this.warning("Multiple bundles with the same final URL: " + cc, new Object[0]);
                        }
                        result.add(cc);
                    }
                    continue;
                }
                x = new Container(this, bsn, versionRange, Container.TYPE.ERROR, null, String.valueOf(bsn) + ";version=" + versionRange + " not found", attrs);
                result.add(x);
                this.warning("Can not find URL for bsn " + bsn, new Object[0]);
            }
        }
        catch (CircularDependencyException e) {
            message = e.getMessage();
            if (source != null) {
                message = String.format("%s (from property: %s)", new Object[]{message, source});
            }
            this.error("Circular dependency detected from project %s: %s", e, new Object[]{this.getName(), message});
        }
        catch (Exception e) {
            this.error("Unexpected error while trying to get the bundles from " + spec, e, new Object[0]);
            e.printStackTrace();
        }
        return result;
    }

    Collection<Container> getBundles(RepositoryPlugin.Strategy strategy, String spec) throws Exception {
        return this.getBundles(strategy, spec, null);
    }

    public void appendPackages(RepositoryPlugin.Strategy strategyx, String spec, List<Container> resolvedBundles, ResolverMode mode) throws Exception {
        HashMap<File, Container> pkgResolvedBundles = new HashMap<File, Container>();
        LinkedList<Map.Entry<String, Map<String, String>>> queue = new LinkedList<Map.Entry<String, Map<String, String>>>();
        queue.addAll(this.parseHeader(spec).entrySet());
        while (!queue.isEmpty()) {
            Map.Entry entry = (Map.Entry)queue.remove(0);
            String pkgName = (String)entry.getKey();
            Map attrs = (Map)entry.getValue();
            Container found = null;
            String versionRange = (String)attrs.get("version");
            if ("latest".equals(versionRange) || "snapshot".equals(versionRange)) {
                found = this.getPackage(pkgName, versionRange, strategyx, attrs, mode);
            }
            if (found == null) {
                found = this.getPackage(pkgName, versionRange, strategyx, attrs, mode);
            }
            if (found != null) {
                if (resolvedBundles.contains(found)) continue;
                List<Container> libs = found.getMembers();
                for (Container cc : libs) {
                    Container existing = (Container)pkgResolvedBundles.get(cc.file);
                    if (existing != null) {
                        Project.addToPackageList(existing, (String)attrs.get("packages"));
                    } else {
                        Project.addToPackageList(cc, (String)attrs.get("packages"));
                        pkgResolvedBundles.put(cc.file, cc);
                    }
                    String importUses = cc.getAttributes().get("import-uses");
                    if (importUses == null) continue;
                    queue.addAll(0, this.parseHeader(importUses).entrySet());
                }
                continue;
            }
            Container x = new Container(this, "X", versionRange, Container.TYPE.ERROR, null, "package " + pkgName + ";version=" + versionRange + " not found", attrs);
            resolvedBundles.add(x);
            this.warning("Can not find URL for package " + pkgName, new Object[0]);
        }
        for (Container container : pkgResolvedBundles.values()) {
            resolvedBundles.add(container);
        }
    }

    static void mergeNames(String names, Set<String> set) {
        StringTokenizer tokenizer = new StringTokenizer(names, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    static String flatten(Set<String> names) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                builder.append(',');
            }
            builder.append(name);
            first = false;
        }
        return builder.toString();
    }

    static void addToPackageList(Container container, String newPackageNames) {
        HashSet<String> merged = new HashSet<String>();
        String packageListStr = container.attributes.get("packages");
        if (packageListStr != null) {
            Project.mergeNames(packageListStr, merged);
        }
        if (newPackageNames != null) {
            Project.mergeNames(newPackageNames, merged);
        }
        container.putAttribute("packages", Project.flatten(merged));
    }

    public Container getPackage(String packageName, String range, RepositoryPlugin.Strategy strategyx, Map<String, String> attrs, ResolverMode mode) throws Exception {
        if ("snapshot".equals(range)) {
            return new Container(this, "", range, Container.TYPE.ERROR, null, "snapshot not supported for package lookups", null);
        }
        if (attrs == null) {
            attrs = new HashMap<String, String>(2);
        }
        attrs.put("package", packageName);
        attrs.put("mode", mode.name());
        RepositoryPlugin.Strategy useStrategy = this.findStrategy(attrs, strategyx, range);
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        for (RepositoryPlugin plugin : plugins) {
            try {
                File result = plugin.get(null, range, useStrategy, attrs);
                if (result == null) continue;
                if (result.getName().endsWith("lib")) {
                    return new Container(this, result.getName(), range, Container.TYPE.LIBRARY, result, null, attrs);
                }
                return new Container(this, result.getName(), range, Container.TYPE.REPO, result, null, attrs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Container(this, "X", range, Container.TYPE.ERROR, null, "package " + packageName + ";version=" + range + " Not found in " + plugins, null);
    }

    private RepositoryPlugin.Strategy findStrategy(Map<String, String> attrs, RepositoryPlugin.Strategy defaultStrategy, String versionRange) {
        RepositoryPlugin.Strategy useStrategy = defaultStrategy;
        String overrideStrategy = attrs.get("strategy");
        if (overrideStrategy != null) {
            if ("highest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = RepositoryPlugin.Strategy.HIGHEST;
            } else if ("lowest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = RepositoryPlugin.Strategy.LOWEST;
            } else if ("exact".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = RepositoryPlugin.Strategy.EXACT;
            }
        }
        if ("latest".equals(versionRange)) {
            useStrategy = RepositoryPlugin.Strategy.HIGHEST;
        }
        return useStrategy;
    }

    public void doMavenPom(RepositoryPlugin.Strategy strategyx, List<Container> result, String action) throws Exception {
        File pomFile = this.getFile("pom.xml");
        if (!pomFile.isFile()) {
            this.error("Specified to use pom.xml but the project directory does not contain a pom.xml file", new Object[0]);
        } else {
            ProjectPom pom = this.getWorkspace().getMaven().createProjectModel(pomFile);
            if (action == null) {
                action = "compile";
            }
            Pom.Scope act = Pom.Scope.valueOf(action);
            Set<Pom> dependencies = pom.getDependencies(act);
            for (Pom sub : dependencies) {
                File artifact = sub.getArtifact();
                Container container = new Container(artifact);
                result.add(container);
            }
        }
    }

    public Collection<Project> getDependson() throws Exception {
        this.prepare();
        return this.dependson;
    }

    public Collection<Container> getBuildpath() throws Exception {
        this.prepare();
        return this.buildpath;
    }

    public Collection<Container> getTestpath() throws Exception {
        this.prepare();
        return this.testpath;
    }

    private void justInTime(Collection<Container> path, List<Container> entries) {
        if (this.delayRunDependencies && path.isEmpty()) {
            this.doPath(path, this.dependson, entries, null);
        }
    }

    public Collection<Container> getRunpath() throws Exception {
        this.prepare();
        this.justInTime(this.runpath, this.parseRunpath());
        return this.runpath;
    }

    public Collection<Container> getRunbundles() throws Exception {
        this.prepare();
        this.justInTime(this.runbundles, this.parseRunbundles());
        return this.runbundles;
    }

    public File getRunStorage() throws Exception {
        this.prepare();
        return this.runstorage;
    }

    public boolean getRunBuilds() {
        String runBuildsStr = this.getProperty("-runbuilds");
        boolean result = runBuildsStr == null ? !this.getPropertiesFile().getName().toLowerCase().endsWith(".bndrun") : Boolean.parseBoolean(runBuildsStr);
        return result;
    }

    public Collection<File> getSourcePath() throws Exception {
        this.prepare();
        return this.sourcepath;
    }

    public Collection<File> getAllsourcepath() throws Exception {
        this.prepare();
        return this.allsourcepath;
    }

    public Collection<Container> getBootclasspath() throws Exception {
        this.prepare();
        return this.bootclasspath;
    }

    public File getOutput() throws Exception {
        this.prepare();
        return this.output;
    }

    private void doEclipseClasspath() throws Exception {
        EclipseClasspath eclipse = new EclipseClasspath(this, this.getWorkspace().getBase(), this.getBase());
        eclipse.setRecurse(false);
        for (File dependent : eclipse.getDependents()) {
            Project required = this.workspace.getProject(dependent.getName());
            this.dependson.add(required);
        }
        for (File f : eclipse.getClasspath()) {
            this.buildpath.add(new Container(f));
        }
        for (File f : eclipse.getBootclasspath()) {
            this.bootclasspath.add(new Container(f));
        }
        this.sourcepath.addAll(eclipse.getSourcepath());
        this.allsourcepath.addAll(eclipse.getAllSources());
        this.output = eclipse.getOutput();
    }

    public String _p_dependson(String[] args) throws Exception {
        return this.list(args, this.toFiles(this.getDependson()));
    }

    private Collection<?> toFiles(Collection<Project> projects) {
        ArrayList<File> files = new ArrayList<File>();
        for (Project p : projects) {
            files.add(p.getBase());
        }
        return files;
    }

    public String _p_buildpath(String[] args) throws Exception {
        return this.list(args, this.getBuildpath());
    }

    public String _p_testpath(String[] args) throws Exception {
        return this.list(args, this.getRunpath());
    }

    public String _p_sourcepath(String[] args) throws Exception {
        return this.list(args, this.getSourcePath());
    }

    public String _p_allsourcepath(String[] args) throws Exception {
        return this.list(args, this.getAllsourcepath());
    }

    public String _p_bootclasspath(String[] args) throws Exception {
        return this.list(args, this.getBootclasspath());
    }

    public String _p_output(String[] args) throws Exception {
        if (args.length != 1) {
            throw new IllegalArgumentException("${output} should not have arguments");
        }
        return this.getOutput().getAbsolutePath();
    }

    private String list(String[] args, Collection<?> list) {
        if (args.length > 3) {
            throw new IllegalArgumentException("${" + args[0] + "[;<separator>]} can only take a separator as argument, has " + Arrays.toString(args));
        }
        String separator = ",";
        if (args.length == 2) {
            separator = args[1];
        }
        return Project.join(list, separator);
    }

    @Override
    protected Object[] getMacroDomains() {
        return new Object[]{this.workspace};
    }

    public File release(Jar jar) throws Exception {
        String name = this.getProperty("-releaserepo");
        return this.release(name, jar);
    }

    public File release(String name, Jar jar) throws Exception {
        this.trace("release %s", name);
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            try {
                try {
                    File file = rp.put(jar);
                    this.trace("Released %s to file %s in repository %s", jar.getName(), file, rp);
                }
                catch (Exception e) {
                    this.error("Deploying " + jar.getName() + " on " + rp.getName(), e, new Object[0]);
                    jar.close();
                }
            }
            finally {
                jar.close();
            }
        } else if (name == null) {
            this.error("There is no writable repository (no repo name specified)", new Object[0]);
        } else {
            this.error("Cannot find a writeable repository with the name %s from the repositiories %s", name, plugins);
        }
        return null;
    }

    public void release(boolean test) throws Exception {
        String name = this.getProperty("-releaserepo");
        this.release(name, test);
    }

    public void release(String name, boolean test) throws Exception {
        this.trace("release", new Object[0]);
        Object[] jars = this.build(test);
        if (jars == null) {
            this.trace("no jars being build", new Object[0]);
            return;
        }
        this.trace("build ", Arrays.toString(jars));
        Object[] objectArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            Object jar = objectArray[n2];
            Jar j = new Jar((File)jar);
            try {
                this.release(name, j);
            }
            finally {
                j.close();
            }
            ++n2;
        }
    }

    public Container getBundle(String bsn, String range, RepositoryPlugin.Strategy strategy, Map<String, String> attrs) throws Exception {
        if (range == null) {
            range = "0";
        }
        if ("snapshot".equals(range)) {
            return this.getBundleFromProject(bsn, attrs);
        }
        RepositoryPlugin.Strategy useStrategy = strategy;
        if ("latest".equals(range)) {
            Container c = this.getBundleFromProject(bsn, attrs);
            if (c != null) {
                return c;
            }
            useStrategy = RepositoryPlugin.Strategy.HIGHEST;
        }
        useStrategy = this.overrideStrategy(attrs, useStrategy);
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        if (useStrategy == RepositoryPlugin.Strategy.EXACT) {
            for (RepositoryPlugin plugin : plugins) {
                File result = plugin.get(bsn, range, RepositoryPlugin.Strategy.EXACT, attrs);
                if (result == null) continue;
                return this.toContainer(bsn, range, attrs, result);
            }
        } else {
            VersionRange versionRange = "latest".equals(range) ? new VersionRange("0") : new VersionRange(range);
            TreeMap<Version, RepositoryPlugin> versions = new TreeMap<Version, RepositoryPlugin>();
            for (RepositoryPlugin plugin : plugins) {
                try {
                    List<Version> vs = plugin.versions(bsn);
                    if (vs == null) continue;
                    for (Version v : vs) {
                        if (versions.containsKey(v) || !versionRange.includes(v)) continue;
                        versions.put(v, plugin);
                    }
                }
                catch (UnsupportedOperationException ose) {
                    File file;
                    if (versions.isEmpty() || !Verifier.isVersion(range) || (file = plugin.get(bsn, range, useStrategy, attrs)) == null) continue;
                    return this.toContainer(bsn, range, attrs, file);
                }
            }
            if (!versions.isEmpty()) {
                Version provider = null;
                switch (useStrategy) {
                    case HIGHEST: {
                        provider = (Version)versions.lastKey();
                        break;
                    }
                    case LOWEST: {
                        provider = (Version)versions.firstKey();
                    }
                }
                if (provider != null) {
                    String version;
                    RepositoryPlugin repo = (RepositoryPlugin)versions.get(provider);
                    File result = repo.get(bsn, version = provider.toString(), RepositoryPlugin.Strategy.EXACT, attrs);
                    if (result != null) {
                        return this.toContainer(bsn, version, attrs, result);
                    }
                } else {
                    this.error("Unexpected, found versions %s but then not provider for startegy %s?", new Object[]{versions, useStrategy});
                }
            }
        }
        return new Container(this, bsn, range, Container.TYPE.ERROR, null, String.valueOf(bsn) + ";version=" + range + " Not found in " + plugins, null);
    }

    protected RepositoryPlugin.Strategy overrideStrategy(Map<String, String> attrs, RepositoryPlugin.Strategy useStrategy) {
        String overrideStrategy;
        if (attrs != null && (overrideStrategy = attrs.get("strategy")) != null) {
            if ("highest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = RepositoryPlugin.Strategy.HIGHEST;
            } else if ("lowest".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = RepositoryPlugin.Strategy.LOWEST;
            } else if ("exact".equalsIgnoreCase(overrideStrategy)) {
                useStrategy = RepositoryPlugin.Strategy.EXACT;
            }
        }
        return useStrategy;
    }

    protected Container toContainer(String bsn, String range, Map<String, String> attrs, File result) {
        if (result == null) {
            System.out.println("Huh?");
        }
        if (result.getName().endsWith("lib")) {
            return new Container(this, bsn, range, Container.TYPE.LIBRARY, result, null, attrs);
        }
        return new Container(this, bsn, range, Container.TYPE.REPO, result, null, attrs);
    }

    private Container getBundleFromProject(String bsn, Map<String, String> attrs) throws Exception {
        String pname = bsn;
        while (true) {
            Project p;
            if ((p = this.getWorkspace().getProject(pname)) != null && p.isValid()) {
                Container c = p.getDeliverable(bsn, attrs);
                return c;
            }
            int n = pname.lastIndexOf(46);
            if (n <= 0) {
                return null;
            }
            pname = pname.substring(0, n);
        }
    }

    public void deploy(String name, File file) throws Exception {
        List<RepositoryPlugin> plugins = this.getPlugins(RepositoryPlugin.class);
        RepositoryPlugin rp = null;
        for (RepositoryPlugin plugin : plugins) {
            if (!plugin.canWrite()) continue;
            if (name == null) {
                rp = plugin;
                break;
            }
            if (!name.equals(plugin.getName())) continue;
            rp = plugin;
            break;
        }
        if (rp != null) {
            Jar jar = new Jar(file);
            try {
                rp.put(jar);
                return;
            }
            catch (Exception e) {
                this.error("Deploying " + file + " on " + rp.getName(), e, new Object[0]);
            }
            finally {
                jar.close();
            }
            return;
        }
        this.trace("No repo found " + file, new Object[0]);
        throw new IllegalArgumentException("No repository found for " + file);
    }

    public void deploy(File file) throws Exception {
        String name = this.getProperty("-deployrepo");
        this.deploy(name, file);
    }

    public void deploy() throws Exception {
        File[] outputs;
        Map<String, Map<String, String>> deploy = this.parseHeader(this.getProperty("-deploy"));
        if (deploy.isEmpty()) {
            this.warning("Deploying but %s is not set to any repo", "-deploy");
            return;
        }
        File[] fileArray = outputs = this.getBuildFiles();
        int n = outputs.length;
        int n2 = 0;
        while (n2 < n) {
            File output = fileArray[n2];
            Jar jar = new Jar(output);
            try {
                for (Deploy d : this.getPlugins(Deploy.class)) {
                    this.trace("Deploying %s to: %s", jar, d);
                    try {
                        if (!d.deploy(this, jar)) continue;
                        this.trace("deployed %s successfully to %s", output, d);
                    }
                    catch (Exception e) {
                        this.error("Error while deploying %s, %s", this, e);
                        e.printStackTrace();
                    }
                }
            }
            finally {
                jar.close();
            }
            ++n2;
        }
    }

    public String _repo(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("Too few arguments for repo, syntax=: ${repo ';'<bsn> [ ; <version> [; ('HIGHEST'|'LOWEST')]}");
        }
        String bsns = args[1];
        String version = null;
        RepositoryPlugin.Strategy strategy = RepositoryPlugin.Strategy.HIGHEST;
        if (args.length > 2) {
            version = args[2];
            if (args.length == 4) {
                if (args[3].equalsIgnoreCase("HIGHEST")) {
                    strategy = RepositoryPlugin.Strategy.HIGHEST;
                } else if (args[3].equalsIgnoreCase("LOWEST")) {
                    strategy = RepositoryPlugin.Strategy.LOWEST;
                } else if (args[3].equalsIgnoreCase("EXACT")) {
                    strategy = RepositoryPlugin.Strategy.EXACT;
                } else {
                    this.error("${repo;<bsn>;<version>;<'highest'|'lowest'|'exact'>} macro requires a strategy of 'highest' or 'lowest', and is " + args[3], new Object[0]);
                }
            }
        }
        Collection<String> parts = Project.split(bsns);
        ArrayList<String> paths = new ArrayList<String>();
        for (String bsn : parts) {
            Container container = this.getBundle(bsn, version, strategy, null);
            this.add(paths, container);
        }
        return Project.join(paths);
    }

    private void add(List<String> paths, Container container) throws Exception {
        if (container.getType() == Container.TYPE.LIBRARY) {
            List<Container> members = container.getMembers();
            for (Container sub : members) {
                this.add(paths, sub);
            }
        } else if (container.getError() == null) {
            paths.add(container.getFile().getAbsolutePath());
        } else {
            paths.add("<<${repo} = " + container.getBundleSymbolicName() + "-" + container.getVersion() + " : " + container.getError() + ">>");
            if (this.isPedantic()) {
                this.warning("Could not expand repo path request: %s ", container);
            }
        }
    }

    public File getTarget() throws Exception {
        this.prepare();
        return this.target;
    }

    public File[] build(boolean underTest) throws Exception {
        if (this.isNoBundles()) {
            return null;
        }
        if (this.getProperty("-nope") != null) {
            this.warning("Please replace -nope with %s", "-nobundles");
            return null;
        }
        if (this.isStale()) {
            this.trace("Building " + this, new Object[0]);
            this.files = this.buildLocal(underTest);
        }
        return this.files;
    }

    public File[] getFiles() {
        return this.files;
    }

    public boolean isStale() throws Exception {
        if (this.isNoBundles()) {
            return false;
        }
        long buildTime = 0L;
        this.files = this.getBuildFiles(false);
        if (this.files == null) {
            return true;
        }
        File[] fileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.lastModified() < this.lastModified()) {
                return true;
            }
            if (buildTime < f.lastModified()) {
                buildTime = f.lastModified();
            }
            ++n2;
        }
        for (Project dependency : this.getDependson()) {
            File[] deps;
            if (dependency.isStale()) {
                return true;
            }
            if (dependency.isNoBundles()) continue;
            File[] fileArray2 = deps = dependency.getBuildFiles();
            int n3 = deps.length;
            int n4 = 0;
            while (n4 < n3) {
                File f = fileArray2[n4];
                if (f.lastModified() >= buildTime) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    public File[] getBuildFiles() throws Exception {
        return this.getBuildFiles(true);
    }

    public File[] getBuildFiles(boolean buildIfAbsent) throws Exception {
        if (this.files != null) {
            return this.files;
        }
        File f = new File(this.getTarget(), "buildfiles");
        if (f.isFile()) {
            FileReader fin = new FileReader(f);
            BufferedReader rdr = new BufferedReader(fin);
            try {
                List<File> files = this.newList();
                String s = rdr.readLine();
                while (s != null) {
                    File ff = new File(s = s.trim());
                    if (!ff.isFile()) {
                        this.error("buildfile lists file but the file does not exist %s", ff);
                    } else {
                        files.add(ff);
                    }
                    s = rdr.readLine();
                }
                this.files = files.toArray(new File[files.size()]);
                File[] fileArray = this.files;
                return fileArray;
            }
            finally {
                fin.close();
            }
        }
        if (buildIfAbsent) {
            this.files = this.buildLocal(false);
            return this.files;
        }
        this.files = null;
        return null;
    }

    public File[] buildLocal(boolean underTest) throws Exception {
        if (this.isNoBundles()) {
            return null;
        }
        long buildtime = System.currentTimeMillis();
        File bfs = new File(this.getTarget(), "buildfiles");
        bfs.delete();
        this.files = null;
        ProjectBuilder builder = this.getBuilder(null);
        if (underTest) {
            builder.setProperty("-undertest", "true");
        }
        Jar[] jars = builder.builds();
        File[] files = new File[jars.length];
        int i = 0;
        while (i < jars.length) {
            Jar jar = jars[i];
            files[i] = this.saveBuild(jar);
            ++i;
        }
        this.getInfo(builder);
        builder.close();
        if (this.isOk()) {
            this.files = files;
            FileWriter fw = new FileWriter(bfs);
            try {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    fw.append(f.getAbsolutePath());
                    fw.append("\n");
                    ++n2;
                }
            }
            finally {
                fw.close();
            }
            this.getWorkspace().changedFile(bfs);
            this.buildtime = buildtime;
            return files;
        }
        return null;
    }

    public boolean isNoBundles() {
        return this.getProperty("-nobundles") != null;
    }

    public File saveBuild(Jar jar) throws Exception {
        try {
            String bsn = jar.getName();
            File f = this.getOutputFile(bsn);
            String msg = "";
            if (!f.exists() || f.lastModified() < jar.lastModified()) {
                this.reportNewer(f.lastModified(), jar);
                f.delete();
                if (!f.getParentFile().isDirectory()) {
                    f.getParentFile().mkdirs();
                }
                jar.write(f);
                this.getWorkspace().changedFile(f);
            } else {
                msg = "(not modified since " + new Date(f.lastModified()) + ")";
            }
            this.trace(String.valueOf(jar.getName()) + " (" + f.getName() + ") " + jar.getResources().size() + " " + msg, new Object[0]);
            File file = f;
            return file;
        }
        finally {
            jar.close();
        }
    }

    public File getOutputFile(String bsn) throws Exception {
        return new File(this.getTarget(), String.valueOf(bsn) + ".jar");
    }

    private void reportNewer(long lastModified, Jar jar) {
        if (Project.isTrue(this.getProperty("-reportnewer"))) {
            StringBuilder sb = new StringBuilder();
            String del = "Newer than " + new Date(lastModified);
            for (Map.Entry<String, Resource> entry : jar.getResources().entrySet()) {
                if (entry.getValue().lastModified() <= lastModified) continue;
                sb.append(del);
                del = ", \n     ";
                sb.append(entry.getKey());
            }
            if (sb.length() > 0) {
                this.warning(sb.toString(), new Object[0]);
            }
        }
    }

    @Override
    public boolean refresh() {
        boolean changed = false;
        if (this.isCnf()) {
            changed = this.workspace.refresh();
        }
        return super.refresh() || changed;
    }

    public boolean isCnf() {
        return this.getBase().getName().equals(BNDCNF);
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        this.preparedPaths = false;
        this.files = null;
    }

    public String getName() {
        return this.getBase().getName();
    }

    public Map<String, Action> getActions() {
        Map<String, Action> all = Project.newMap();
        Map<String, Action> actions = Project.newMap();
        this.fillActions(all);
        this.getWorkspace().fillActions(all);
        for (Map.Entry<String, Action> action : all.entrySet()) {
            String key = this.getReplacer().process(action.getKey());
            if (key == null || key.trim().length() == 0) continue;
            actions.put(key, action.getValue());
        }
        return actions;
    }

    public void fillActions(Map<String, Action> all) {
        List<NamedAction> plugins = this.getPlugins(NamedAction.class);
        for (NamedAction a : plugins) {
            all.put(a.getName(), a);
        }
        Map<String, Map<String, String>> actions = this.parseHeader(this.getProperty("-actions", DEFAULT_ACTIONS));
        for (Map.Entry<String, Map<String, String>> entry : actions.entrySet()) {
            String key = Processor.removeDuplicateMarker(entry.getKey());
            Action action = entry.getValue().get("script") != null ? new ScriptAction(entry.getValue().get("type"), entry.getValue().get("script")) : new ReflectAction(key);
            String label = entry.getValue().get("label");
            all.put(label.toLowerCase(), action);
        }
    }

    public void release() throws Exception {
        this.release(false);
    }

    public void release(String name) throws Exception {
        this.release(name, false);
    }

    public void clean() throws Exception {
        File target = this.getTarget();
        if (target.isDirectory() && target.getParentFile() != null) {
            IO.delete(target);
            target.mkdirs();
        }
        if (this.getOutput().isDirectory()) {
            IO.delete(this.getOutput());
        }
        this.getOutput().mkdirs();
    }

    public File[] build() throws Exception {
        return this.build(false);
    }

    public void run() throws Exception {
        ProjectLauncher pl = this.getProjectLauncher();
        pl.setTrace(this.isTrace());
        pl.launch();
    }

    public void test() throws Exception {
        this.clear();
        ProjectTester tester = this.getProjectTester();
        tester.setContinuous(Project.isTrue(this.getProperty("-testcontinuous")));
        tester.prepare();
        if (!this.isOk()) {
            return;
        }
        int errors = tester.test();
        if (errors == 0) {
            System.out.println("No Errors");
        } else if (errors > 0) {
            System.out.println(String.valueOf(errors) + " Error(s)");
        } else {
            System.out.println("Error " + errors);
        }
    }

    public Jar getValidJar(File f) throws Exception {
        Jar jar = new Jar(f);
        return this.getValidJar(jar, f.getAbsolutePath());
    }

    public Jar getValidJar(URL url) throws Exception {
        InputStream in = url.openStream();
        try {
            Jar jar = new Jar(url.getFile().replace('/', '.'), in, System.currentTimeMillis());
            Jar jar2 = this.getValidJar(jar, ((Object)url).toString());
            return jar2;
        }
        finally {
            in.close();
        }
    }

    public Jar getValidJar(Jar jar, String id) throws Exception {
        Manifest manifest = jar.getManifest();
        if (manifest == null) {
            this.trace("Wrapping with all defaults", new Object[0]);
            Builder b = new Builder(this);
            b.addClasspath(jar);
            b.setProperty("Bnd-Message", "Wrapped from " + id + "because lacked manifest");
            b.setProperty("Export-Package", "*");
            b.setProperty("Import-Package", "*;resolution:=optional");
            jar = b.build();
        } else if (manifest.getMainAttributes().getValue("Bundle-ManifestVersion") == null) {
            this.trace("Not a release 4 bundle, wrapping with manifest as source", new Object[0]);
            Builder b = new Builder(this);
            b.addClasspath(jar);
            b.setProperty("Private-Package", "*");
            b.mergeManifest(manifest);
            String imprts = manifest.getMainAttributes().getValue("Import-Package");
            imprts = imprts == null ? "" : String.valueOf(imprts) + ",";
            imprts = String.valueOf(imprts) + "*;resolution=optional";
            b.setProperty("Import-Package", imprts);
            b.setProperty("Bnd-Message", "Wrapped from " + id + "because had incomplete manifest");
            jar = b.build();
        }
        return jar;
    }

    public String _project(String[] args) {
        return this.getBase().getAbsolutePath();
    }

    public void bump(String mask) throws IOException {
        Sed sed = new Sed(this.getReplacer(), this.getPropertiesFile());
        sed.replace("(Bundle-Version\\s*(:|=)\\s*)(([0-9]+(\\.[0-9]+(\\.[0-9]+)?)?))", "$1${version;" + mask + ";$3}");
        sed.doIt();
        this.forceRefresh();
    }

    public void bump() throws IOException {
        this.bump(this.getProperty("-bumppolicy", "=+0"));
    }

    public void action(String command) throws Throwable {
        Map<String, Action> actions = this.getActions();
        Action a = actions.get(command);
        if (a == null) {
            a = new ReflectAction(command);
        }
        this.before(this, command);
        try {
            a.execute(this, command);
        }
        catch (Throwable t) {
            this.after(this, command, t);
            throw t;
        }
    }

    void before(Project p, String a) {
        List<CommandPlugin> testPlugins = this.getPlugins(CommandPlugin.class);
        for (CommandPlugin testPlugin : testPlugins) {
            testPlugin.before(this, a);
        }
    }

    void after(Project p, String a, Throwable t) {
        List<CommandPlugin> testPlugins = this.getPlugins(CommandPlugin.class);
        int i = testPlugins.size() - 1;
        while (i >= 0) {
            testPlugins.get(i).after(this, a, t);
            --i;
        }
    }

    public String _findfile(String[] args) {
        File f = this.getFile(args[1]);
        ArrayList<String> files = new ArrayList<String>();
        this.tree(files, f, "", Instruction.getPattern(args[2]));
        return Project.join(files);
    }

    void tree(List<String> list, File current, String path, Instruction instr) {
        String[] subs;
        if (path.length() > 0) {
            path = String.valueOf(path) + "/";
        }
        if ((subs = current.list()) != null) {
            String[] stringArray = subs;
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                String sub = stringArray[n2];
                File f = new File(current, sub);
                if (f.isFile()) {
                    if (instr.matches(sub) && !instr.isNegated()) {
                        list.add(String.valueOf(path) + sub);
                    }
                } else {
                    this.tree(list, f, String.valueOf(path) + sub, instr);
                }
                ++n2;
            }
        }
    }

    public void refreshAll() {
        this.workspace.refresh();
        this.refresh();
    }

    public void script(String type, String script) throws Exception {
        List<Scripter> scripters = this.getPlugins(Scripter.class);
        if (scripters.isEmpty()) {
            this.error("Can not execute script because there are no scripters registered: %s", script);
            return;
        }
        Properties x = this.getProperties();
        scripters.get(0).eval(x, new StringReader(script));
    }

    public String _repos(String[] args) throws Exception {
        List<RepositoryPlugin> repos = this.getPlugins(RepositoryPlugin.class);
        ArrayList<String> names = new ArrayList<String>();
        for (RepositoryPlugin rp : repos) {
            names.add(rp.getName());
        }
        return Project.join(names, ", ");
    }

    public String _help(String[] args) throws Exception {
        if (args.length == 1) {
            return "Specify the option or header you want information for";
        }
        Syntax syntax = Syntax.HELP.get(args[1]);
        if (syntax == null) {
            return "No help for " + args[1];
        }
        String what = null;
        if (args.length > 2) {
            what = args[2];
        }
        if (what == null || what.equals("lead")) {
            return syntax.getLead();
        }
        if (what == null || what.equals("example")) {
            return syntax.getExample();
        }
        if (what == null || what.equals("pattern")) {
            return syntax.getPattern();
        }
        if (what == null || what.equals("values")) {
            return syntax.getValues();
        }
        return "Invalid type specified for help: lead, example, pattern, values";
    }

    public Collection<Container> getDeliverables() throws Exception {
        ArrayList<Container> result = new ArrayList<Container>();
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            Container c = new Container(this, builder.getBsn(), builder.getVersion(), Container.TYPE.PROJECT, this.getOutputFile(builder.getBsn()), null, null);
            result.add(c);
        }
        return result;
    }

    public Builder getSubBuilder(File bndFile) throws Exception {
        bndFile = bndFile.getCanonicalFile();
        File base = this.getBase().getCanonicalFile();
        if (!bndFile.getAbsolutePath().startsWith(base.getAbsolutePath())) {
            return null;
        }
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            File propertiesFile = builder.getPropertiesFile();
            if (propertiesFile == null || !((Object)propertiesFile.getCanonicalFile()).equals(bndFile)) continue;
            return builder;
        }
        return null;
    }

    public Container getDeliverable(String bsn, Map<String, String> attrs) throws Exception {
        Collection<? extends Builder> builders = this.getSubBuilders();
        for (Builder builder : builders) {
            if (!builder.getBsn().equals(bsn)) continue;
            return new Container(this, this.getOutputFile(bsn));
        }
        return null;
    }

    public Collection<? extends Builder> getSubBuilders() throws Exception {
        return this.getBuilder(null).getSubBuilders();
    }

    Collection<File> toFile(Collection<Container> containers) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        for (Container container : containers) {
            container.contributeFiles(files, this);
        }
        return files;
    }

    public Collection<String> getRunVM() {
        Map<String, Map<String, String>> hdr = this.parseHeader(this.getProperty("-runvm"));
        return hdr.keySet();
    }

    public Map<String, String> getRunProperties() {
        return OSGiHeader.parseProperties(this.getProperty("-runproperties"));
    }

    public ProjectLauncher getProjectLauncher() throws Exception {
        return this.getHandler(ProjectLauncher.class, this.getRunpath(), "Launcher-Plugin", "biz.aQute.launcher");
    }

    public ProjectTester getProjectTester() throws Exception {
        return this.getHandler(ProjectTester.class, this.getTestpath(), "Tester-Plugin", "biz.aQute.junit");
    }

    private <T> T getHandler(Class<T> target, Collection<Container> containers, String header, String defaultHandler) throws Exception {
        Class<T> handlerClass = target;
        List<Container> withDefault = Create.list();
        withDefault.addAll(containers);
        withDefault.addAll(this.getBundles(RepositoryPlugin.Strategy.HIGHEST, defaultHandler, null));
        for (Container c : withDefault) {
            Class<?> clz;
            String launcher;
            Manifest manifest = c.getManifest();
            if (manifest == null || (launcher = manifest.getMainAttributes().getValue(header)) == null || (clz = this.getClass(launcher, c.getFile())) == null) continue;
            if (!target.isAssignableFrom(clz)) {
                this.error("Found a %s class in %s but it is not compatible with: %s", clz, c, target);
                continue;
            }
            handlerClass = clz.asSubclass(target);
            Constructor<T> constructor = handlerClass.getConstructor(Project.class);
            return constructor.newInstance(this);
        }
        throw new IllegalArgumentException("Default handler for " + header + " not found in " + defaultHandler);
    }

    public synchronized boolean lock(String reason) throws InterruptedException {
        if (!this.lock.tryLock(5L, TimeUnit.SECONDS)) {
            this.error("Could not acquire lock for %s, was locked by %s for %s", reason, this.lockingThread, this.lockingReason);
            System.out.printf("Could not acquire lock for %s, was locked by %s for %s\n", reason, this.lockingThread, this.lockingReason);
            System.out.flush();
            return false;
        }
        this.lockingReason = reason;
        this.lockingThread = Thread.currentThread();
        return true;
    }

    public void unlock() {
        this.lockingReason = null;
        this.lock.unlock();
    }

    public void setDelayRunDependencies(boolean x) {
        this.delayRunDependencies = x;
    }
}

