/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.felix.webconsole.plugins.ds.internal.ComponentConfigurationPrinter;
import org.apache.felix.webconsole.plugins.ds.internal.InfoProvider;
import org.apache.felix.webconsole.plugins.ds.internal.WebConsolePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.runtime.ServiceComponentRuntime;

public class ServiceRegistrations {
    private final List<ServiceRegistration<?>> registrations = new ArrayList();
    private final List<Closeable> closeables = new ArrayList<Closeable>();

    public ServiceRegistrations(BundleContext bundleContext, ServiceComponentRuntime runtime) {
        WebConsolePlugin plugin = new WebConsolePlugin(bundleContext, runtime);
        this.closeables.add(plugin);
        this.registrations.add(plugin.register(bundleContext));
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String name = "Declarative Services Components";
        ((Dictionary)props).put("felix.inventory.printer.name", "scr");
        ((Dictionary)props).put("felix.inventory.printer.title", "Declarative Services Components");
        ((Dictionary)props).put("felix.inventory.printer.format", new String[]{Format.TEXT.toString(), Format.JSON.toString()});
        this.registrations.add(bundleContext.registerService(InventoryPrinter.class, (Object)new ComponentConfigurationPrinter(runtime, plugin), props));
        this.registrations.add(new InfoProvider(bundleContext.getBundle(), runtime).register(bundleContext));
    }

    public void destroy() {
        for (ServiceRegistration<?> reg : this.registrations) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.registrations.clear();
        for (Closeable c : this.closeables) {
            try {
                c.close();
            }
            catch (Exception exception) {}
        }
        this.closeables.clear();
    }
}

