/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.classic;

import java.io.IOException;
import org.apache.hc.client5.testing.auth.Authenticator;
import org.apache.hc.client5.testing.auth.BasicAuthTokenExtractor;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.io.HttpServerRequestHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;

public class AuthenticatingDecorator
implements HttpServerRequestHandler {
    private final HttpServerRequestHandler requestHandler;
    private final Authenticator authenticator;
    private final BasicAuthTokenExtractor authTokenExtractor;

    public AuthenticatingDecorator(HttpServerRequestHandler requestHandler, Authenticator authenticator) {
        this.requestHandler = (HttpServerRequestHandler)Args.notNull((Object)requestHandler, (String)"Request handler");
        this.authenticator = (Authenticator)Args.notNull((Object)authenticator, (String)"Authenticator");
        this.authTokenExtractor = new BasicAuthTokenExtractor();
    }

    protected void customizeUnauthorizedResponse(ClassicHttpResponse unauthorized) {
    }

    public void handle(ClassicHttpRequest request, HttpServerRequestHandler.ResponseTrigger responseTrigger, HttpContext context) throws HttpException, IOException {
        boolean expectContinue;
        Header h = request.getFirstHeader("Authorization");
        String challengeResponse = h != null ? this.authTokenExtractor.extract(h.getValue()) : null;
        URIAuthority authority = request.getAuthority();
        String requestUri = request.getRequestUri();
        boolean authenticated = this.authenticator.authenticate(authority, requestUri, challengeResponse);
        Header expect = request.getFirstHeader("Expect");
        boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        if (authenticated) {
            if (expectContinue) {
                responseTrigger.sendInformation((ClassicHttpResponse)new BasicClassicHttpResponse(100));
            }
            this.requestHandler.handle(request, responseTrigger, context);
        } else {
            BasicClassicHttpResponse unauthorized = new BasicClassicHttpResponse(401);
            String realm = this.authenticator.getRealm(authority, requestUri);
            unauthorized.addHeader("WWW-Authenticate", (Object)("Basic realm=\"" + realm + "\""));
            this.customizeUnauthorizedResponse((ClassicHttpResponse)unauthorized);
            if (unauthorized.getEntity() == null) {
                unauthorized.setEntity((HttpEntity)new StringEntity("Unauthorized"));
            }
            if (expectContinue || request.getEntity() == null) {
                responseTrigger.submitResponse((ClassicHttpResponse)unauthorized);
                EntityUtils.consume((HttpEntity)request.getEntity());
            } else {
                EntityUtils.consume((HttpEntity)request.getEntity());
                responseTrigger.submitResponse((ClassicHttpResponse)unauthorized);
            }
        }
    }
}

