/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.node.config;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.configuration.NodeConfigShowCall;
import org.apache.ignite3.internal.cli.call.configuration.NodeConfigShowCallInput;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.FormatMixin;
import org.apache.ignite3.internal.cli.commands.node.NodeUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Shows node configuration"})
public class NodeConfigShowReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private NodeUrlMixin nodeUrl;
    @CommandLine.Parameters(arity="0..1", description={"Configuration path selector"})
    private String selector;
    @Inject
    private NodeConfigShowCall call;
    @Inject
    private ConnectToClusterQuestion question;
    @CommandLine.Mixin
    private FormatMixin format;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.nodeUrl.getNodeUrl()).map(this::nodeConfigShowCallInput).then(Flows.fromCall(this.call)).print(this.format.decorator()));
    }

    private NodeConfigShowCallInput nodeConfigShowCallInput(String nodeUrl) {
        return NodeConfigShowCallInput.builder().selector(this.selector).nodeUrl(nodeUrl).build();
    }
}

