/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization;

import java.lang.reflect.Field;
import org.apache.ignite3.internal.network.serialization.BrokenFieldAccessor;
import org.apache.ignite3.internal.network.serialization.Classes;
import org.apache.ignite3.internal.network.serialization.DeclaredType;
import org.apache.ignite3.internal.network.serialization.FieldAccessor;
import org.apache.ignite3.internal.network.serialization.Primitives;

public class FieldDescriptor
implements DeclaredType {
    private final String name;
    private final Class<?> localClass;
    private final int typeDescriptorId;
    private final boolean unshared;
    private final boolean isPrimitive;
    private final boolean isSerializationTypeKnownUpfront;
    private final FieldAccessor accessor;

    public static FieldDescriptor local(Field field, int typeDescriptorId) {
        return new FieldDescriptor(field.getName(), field.getType(), typeDescriptorId, false, field.getType().isPrimitive(), Classes.isSerializationTypeKnownUpfront(field.getType()), FieldAccessor.forField(field));
    }

    public static FieldDescriptor local(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, Class<?> declaringClass) {
        return new FieldDescriptor(fieldName, fieldClazz, typeDescriptorId, unshared, fieldClazz.isPrimitive(), Classes.isSerializationTypeKnownUpfront(fieldClazz), declaringClass);
    }

    public static FieldDescriptor remote(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isSerializationTypeKnownUpfront, Class<?> declaringClass) {
        return new FieldDescriptor(fieldName, fieldClazz, typeDescriptorId, unshared, isPrimitive, isSerializationTypeKnownUpfront, declaringClass);
    }

    public static FieldDescriptor remote(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isSerializationTypeKnownUpfront, String declaringClassName) {
        return new FieldDescriptor(fieldName, fieldClazz, typeDescriptorId, unshared, isPrimitive, isSerializationTypeKnownUpfront, new BrokenFieldAccessor(fieldName, declaringClassName));
    }

    private FieldDescriptor(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isSerializationTypeKnownUpfront, Class<?> declaringClass) {
        this(fieldName, fieldClazz, typeDescriptorId, unshared, isPrimitive, isSerializationTypeKnownUpfront, FieldAccessor.forFieldName(fieldName, declaringClass));
    }

    private FieldDescriptor(String fieldName, Class<?> fieldClazz, int typeDescriptorId, boolean unshared, boolean isPrimitive, boolean isSerializationTypeKnownUpfront, FieldAccessor accessor) {
        this.name = fieldName;
        this.localClass = fieldClazz;
        this.typeDescriptorId = typeDescriptorId;
        this.unshared = unshared;
        this.isPrimitive = isPrimitive;
        this.isSerializationTypeKnownUpfront = isSerializationTypeKnownUpfront;
        this.accessor = accessor;
    }

    public String name() {
        return this.name;
    }

    public Class<?> localClass() {
        return this.localClass;
    }

    public String typeName() {
        return this.localClass.getName();
    }

    @Override
    public int typeDescriptorId() {
        return this.typeDescriptorId;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public int primitiveWidthInBytes() {
        assert (this.isPrimitive());
        return Primitives.widthInBytes(this.localClass);
    }

    @Override
    public boolean isSerializationTypeKnownUpfront() {
        return this.isSerializationTypeKnownUpfront;
    }

    public FieldAccessor accessor() {
        return this.accessor;
    }
}

