/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema.marshaller.reflection;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite3.internal.marshaller.MarshallerWriter;
import org.apache.ignite3.internal.schema.row.RowAssembler;

class RowWriter
implements MarshallerWriter {
    private final RowAssembler rowAssembler;

    RowWriter(RowAssembler rowAssembler) {
        this.rowAssembler = rowAssembler;
    }

    @Override
    public void writeNull() {
        this.rowAssembler.appendNull();
    }

    @Override
    public void writeAbsentValue() {
        this.rowAssembler.appendDefault();
    }

    @Override
    public void writeBoolean(boolean val) {
        this.rowAssembler.appendBoolean(val);
    }

    @Override
    public void writeByte(byte val) {
        this.rowAssembler.appendByte(val);
    }

    @Override
    public void writeShort(short val) {
        this.rowAssembler.appendShort(val);
    }

    @Override
    public void writeInt(int val) {
        this.rowAssembler.appendInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.rowAssembler.appendLong(val);
    }

    @Override
    public void writeFloat(float val) {
        this.rowAssembler.appendFloat(val);
    }

    @Override
    public void writeDouble(double val) {
        this.rowAssembler.appendDouble(val);
    }

    @Override
    public void writeString(String val) {
        this.rowAssembler.appendStringNotNull(val);
    }

    @Override
    public void writeUuid(UUID val) {
        this.rowAssembler.appendUuidNotNull(val);
    }

    @Override
    public void writeBytes(byte[] val) {
        this.rowAssembler.appendBytesNotNull(val);
    }

    @Override
    public void writeBigDecimal(BigDecimal val, int scale) {
        this.rowAssembler.appendDecimalNotNull(val);
    }

    @Override
    public void writeDate(LocalDate val) {
        this.rowAssembler.appendDateNotNull(val);
    }

    @Override
    public void writeTime(LocalTime val) {
        this.rowAssembler.appendTimeNotNull(val);
    }

    @Override
    public void writeTimestamp(Instant val) {
        this.rowAssembler.appendTimestampNotNull(val);
    }

    @Override
    public void writeDateTime(LocalDateTime val) {
        this.rowAssembler.appendDateTimeNotNull(val);
    }
}

