/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridClientConsistentHash<N> {
    private static final int PRIME = 15485857;
    private static final Random RAND = new Random();
    private final Object affSeed;
    private final NavigableMap<Integer, SortedSet<N>> circle = new TreeMap<Integer, SortedSet<N>>();
    private final ReadWriteLock rw = new ReentrantReadWriteLock();
    private Collection<N> nodes = new HashSet<N>();
    private Comparator<N> nodesComp;

    public GridClientConsistentHash() {
        this(null, null);
    }

    public GridClientConsistentHash(Object affSeed) {
        this(null, affSeed);
    }

    public GridClientConsistentHash(Comparator<N> nodesComp, Object affSeed) {
        this.nodesComp = nodesComp;
        this.affSeed = affSeed == null ? new Integer(15485857) : affSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNodes(Collection<N> nodes, int replicas) {
        if (nodes == null || nodes.isEmpty()) {
            return;
        }
        this.rw.writeLock().lock();
        try {
            for (N node : nodes) {
                this.addNode(node, replicas);
            }
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(N node, int replicas) {
        if (node == null) {
            return false;
        }
        long seed = this.affSeed.hashCode() * 31 + GridClientConsistentHash.hash(node);
        this.rw.writeLock().lock();
        try {
            if (!this.nodes.add(node)) {
                boolean bl = false;
                return bl;
            }
            int hash = GridClientConsistentHash.hash(seed);
            SortedSet<Object> set = (TreeSet<N>)this.circle.get(hash);
            if (set == null) {
                set = new TreeSet<N>(this.nodesComp);
                this.circle.put(hash, set);
            }
            set.add(node);
            for (int i = 1; i <= replicas; ++i) {
                hash = GridClientConsistentHash.hash(seed = seed * (long)this.affSeed.hashCode() + (long)i);
                set = (SortedSet)this.circle.get(hash);
                if (set == null) {
                    set = new TreeSet<N>(this.nodesComp);
                    this.circle.put(hash, set);
                }
                set.add(node);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(N node) {
        if (node == null) {
            return false;
        }
        this.rw.writeLock().lock();
        try {
            if (!this.nodes.remove(node)) {
                boolean bl = false;
                return bl;
            }
            Iterator it = this.circle.values().iterator();
            while (it.hasNext()) {
                SortedSet set = (SortedSet)it.next();
                if (!set.remove(node) || !set.isEmpty()) continue;
                it.remove();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    public int count() {
        this.rw.readLock().lock();
        try {
            int n = this.nodes.size();
            return n;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.rw.readLock().lock();
        try {
            int size = 0;
            for (SortedSet set : this.circle.values()) {
                size += set.size();
            }
            int n = size;
            return n;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Set<N> nodes() {
        this.rw.readLock().lock();
        try {
            HashSet<N> hashSet = new HashSet<N>(this.nodes);
            return hashSet;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    public N random() {
        return this.node(RAND.nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N node(Object key) {
        int hash = GridClientConsistentHash.hash(key);
        this.rw.readLock().lock();
        try {
            Map.Entry<Integer, SortedSet<N>> firstEntry = this.circle.firstEntry();
            if (firstEntry == null) {
                N n = null;
                return n;
            }
            Map.Entry<Integer, SortedSet<N>> tailEntry = this.circle.tailMap(hash, true).firstEntry();
            Object e = ((SortedSet)this.circle.get(tailEntry == null ? firstEntry.getKey() : tailEntry.getKey())).first();
            return (N)e;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    public N node(Object key, Collection<N> inc) {
        return this.node(key, inc, null);
    }

    public N node(Object key, final @Nullable Collection<N> inc, final @Nullable Collection<N> exc) {
        if (inc == null && exc == null) {
            return this.node(key);
        }
        return this.node(key, new GridClientPredicate<N>(){

            @Override
            public boolean apply(N n) {
                return !(inc != null && !inc.contains(n) || exc != null && exc.contains(n));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public N node(Object key, GridClientPredicate<N> ... p) {
        if (p == null || p.length == 0) {
            return this.node(key);
        }
        int hash = GridClientConsistentHash.hash(key);
        this.rw.readLock().lock();
        try {
            int size = this.nodes.size();
            if (size == 0) {
                N n = null;
                return n;
            }
            HashSet<Object> failed = null;
            for (SortedSet set : this.circle.tailMap(hash, true).values()) {
                for (Object n : set) {
                    if (failed != null && failed.contains(n)) continue;
                    if (this.apply(p, n)) {
                        Object e = n;
                        return (N)e;
                    }
                    if (failed == null) {
                        failed = new HashSet();
                    }
                    failed.add(n);
                    if (failed.size() != size) continue;
                    N n2 = null;
                    return n2;
                }
            }
            for (SortedSet set : this.circle.headMap(hash, false).values()) {
                for (Object n : set) {
                    if (failed != null && failed.contains(n)) continue;
                    if (this.apply(p, n)) {
                        Object e = n;
                        return (N)e;
                    }
                    if (failed == null) {
                        failed = U.newHashSet(size);
                    }
                    failed.add(n);
                    if (failed.size() != size) continue;
                    N n3 = null;
                    return n3;
                }
            }
            Iterator iterator = null;
            return (N)iterator;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    private boolean apply(GridClientPredicate<N>[] p, N n) {
        if (p != null) {
            for (GridClientPredicate<N> r : p) {
                if (r == null || r.apply(n)) continue;
                return false;
            }
        }
        return true;
    }

    public static int hash(Object o) {
        int h = o == null ? 0 : (o instanceof byte[] ? Arrays.hashCode((byte[])o) : o.hashCode());
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ h >>> 16;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [affSeed=" + this.affSeed + ", circle=" + this.circle + ", nodesComp=" + this.nodesComp + ", nodes=" + this.nodes + "]";
    }
}

