/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.cache.affinity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.affinity.GridAffinityFunctionContextImpl;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.jetbrains.annotations.NotNull;

public class PlatformAffinityUtils {
    public static void writeAffinityFunctionContext(AffinityFunctionContext affCtx, BinaryRawWriterEx writer, PlatformContext ctx) {
        assert (affCtx != null);
        assert (writer != null);
        assert (ctx != null);
        ctx.writeNodes(writer, affCtx.currentTopologySnapshot());
        writer.writeInt(affCtx.backups());
        writer.writeLong(affCtx.currentTopologyVersion().topologyVersion());
        writer.writeInt(affCtx.currentTopologyVersion().minorTopologyVersion());
        ctx.writeEvent(writer, affCtx.discoveryEvent());
        List<List<ClusterNode>> prevAssignment = ((GridAffinityFunctionContextImpl)affCtx).prevAssignment();
        if (prevAssignment == null) {
            writer.writeInt(-1);
        } else {
            writer.writeInt(prevAssignment.size());
            for (List<ClusterNode> part : prevAssignment) {
                ctx.writeNodes(writer, part);
            }
        }
    }

    public static void writePartitionAssignment(Collection<List<ClusterNode>> partitions, BinaryRawWriterEx writer, PlatformContext ctx) {
        assert (partitions != null);
        assert (writer != null);
        writer.writeInt(partitions.size());
        for (List<ClusterNode> part : partitions) {
            ctx.writeNodes(writer, part);
        }
    }

    @NotNull
    public static List<List<ClusterNode>> readPartitionAssignment(BinaryRawReader reader, PlatformContext ctx) {
        assert (reader != null);
        assert (ctx != null);
        int partCnt = reader.readInt();
        ArrayList<List<ClusterNode>> res = new ArrayList<List<ClusterNode>>(partCnt);
        IgniteClusterEx cluster = ctx.kernalContext().grid().cluster();
        for (int i = 0; i < partCnt; ++i) {
            int partSize = reader.readInt();
            ArrayList<ClusterNode> part = new ArrayList<ClusterNode>(partSize);
            for (int j = 0; j < partSize; ++j) {
                part.add(cluster.node(reader.readUuid()));
            }
            res.add(part);
        }
        return res;
    }
}

