/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.BytesUtils;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class DeltaBinaryDecoder
extends Decoder {
    protected long count = 0L;
    protected byte[] deltaBuf;
    protected int readIntTotalCount = 0;
    protected int nextReadIndex = 0;
    protected int packWidth;
    protected int packNum;
    protected int encodingLength;

    public DeltaBinaryDecoder() {
        super(TSEncoding.TS_2DIFF);
    }

    protected abstract void readHeader(ByteBuffer var1) throws IOException;

    protected abstract void allocateDataArray();

    protected abstract void readValue(int var1);

    protected int ceil(int v) {
        return (int)Math.ceil((double)v / 8.0);
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return this.nextReadIndex < this.readIntTotalCount || buffer.remaining() > 0;
    }

    public static class LongDeltaDecoder
    extends DeltaBinaryDecoder {
        private long firstValue;
        private long[] data;
        private long previous;
        private long minDeltaBase;

        protected long readT(ByteBuffer buffer) {
            if (this.nextReadIndex == this.readIntTotalCount) {
                return this.loadIntBatch(buffer);
            }
            return this.data[this.nextReadIndex++];
        }

        protected long loadIntBatch(ByteBuffer buffer) {
            this.packNum = ReadWriteIOUtils.readInt(buffer);
            this.packWidth = ReadWriteIOUtils.readInt(buffer);
            ++this.count;
            this.readHeader(buffer);
            this.encodingLength = this.ceil(this.packNum * this.packWidth);
            this.deltaBuf = new byte[this.encodingLength];
            buffer.get(this.deltaBuf);
            this.allocateDataArray();
            this.previous = this.firstValue;
            this.readIntTotalCount = this.packNum;
            this.nextReadIndex = 0;
            this.readPack();
            return this.firstValue;
        }

        private void readPack() {
            for (int i = 0; i < this.packNum; ++i) {
                this.readValue(i);
                this.previous = this.data[i];
            }
        }

        @Override
        public long readLong(ByteBuffer buffer) {
            return this.readT(buffer);
        }

        @Override
        protected void readHeader(ByteBuffer buffer) {
            this.minDeltaBase = ReadWriteIOUtils.readLong(buffer);
            this.firstValue = ReadWriteIOUtils.readLong(buffer);
        }

        @Override
        protected void allocateDataArray() {
            this.data = new long[this.packNum];
        }

        @Override
        protected void readValue(int i) {
            long v = BytesUtils.bytesToLong(this.deltaBuf, this.packWidth * i, this.packWidth);
            this.data[i] = this.previous + this.minDeltaBase + v;
        }

        @Override
        public void reset() {
        }
    }

    public static class IntDeltaDecoder
    extends DeltaBinaryDecoder {
        private int firstValue;
        private int[] data;
        private int previous;
        private int minDeltaBase;

        protected int readT(ByteBuffer buffer) {
            if (this.nextReadIndex == this.readIntTotalCount) {
                return this.loadIntBatch(buffer);
            }
            return this.data[this.nextReadIndex++];
        }

        @Override
        public int readInt(ByteBuffer buffer) {
            return this.readT(buffer);
        }

        protected int loadIntBatch(ByteBuffer buffer) {
            this.packNum = ReadWriteIOUtils.readInt(buffer);
            this.packWidth = ReadWriteIOUtils.readInt(buffer);
            ++this.count;
            this.readHeader(buffer);
            this.encodingLength = this.ceil(this.packNum * this.packWidth);
            this.deltaBuf = new byte[this.encodingLength];
            buffer.get(this.deltaBuf);
            this.allocateDataArray();
            this.previous = this.firstValue;
            this.readIntTotalCount = this.packNum;
            this.nextReadIndex = 0;
            this.readPack();
            return this.firstValue;
        }

        private void readPack() {
            for (int i = 0; i < this.packNum; ++i) {
                this.readValue(i);
                this.previous = this.data[i];
            }
        }

        @Override
        protected void readHeader(ByteBuffer buffer) {
            this.minDeltaBase = ReadWriteIOUtils.readInt(buffer);
            this.firstValue = ReadWriteIOUtils.readInt(buffer);
        }

        @Override
        protected void allocateDataArray() {
            this.data = new int[this.packNum];
        }

        @Override
        protected void readValue(int i) {
            int v = BytesUtils.bytesToInt(this.deltaBuf, this.packWidth * i, this.packWidth);
            this.data[i] = this.previous + this.minDeltaBase + v;
        }

        @Override
        public void reset() {
        }
    }
}

