/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import java.util.ArrayList;
import java.util.LinkedList;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.Future;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.Promise;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FutureConnection {
    private final CallbackConnection next;
    private LinkedList<Promise<Message>> receiveFutures = new LinkedList();
    private LinkedList<Message> receivedFrames = new LinkedList();
    volatile boolean connected;

    public FutureConnection(CallbackConnection next) {
        this.next = next;
        this.next.listener(new Listener(){

            public void onConnected() {
                FutureConnection.this.connected = true;
            }

            public void onDisconnected() {
                FutureConnection.this.connected = false;
            }

            public void onPublish(UTF8Buffer topic, Buffer payload, Runnable onComplete) {
                FutureConnection.this.getDispatchQueue().assertExecuting();
                FutureConnection.this.deliverMessage(new Message(FutureConnection.this.getDispatchQueue(), topic, payload, onComplete));
            }

            public void onFailure(Throwable value) {
                FutureConnection.this.getDispatchQueue().assertExecuting();
                ArrayList tmp = new ArrayList(FutureConnection.this.receiveFutures);
                FutureConnection.this.receiveFutures.clear();
                for (Promise future : tmp) {
                    future.onFailure(value);
                }
                FutureConnection.this.connected = false;
            }
        });
    }

    void deliverMessage(Message msg) {
        if (this.receiveFutures.isEmpty()) {
            this.receivedFrames.add(msg);
        } else {
            this.receiveFutures.removeFirst().onSuccess(msg);
        }
    }

    void putBackMessage(Message msg) {
        if (this.receiveFutures.isEmpty()) {
            this.receivedFrames.addFirst(msg);
        } else {
            this.receiveFutures.removeFirst().onSuccess(msg);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public DispatchQueue getDispatchQueue() {
        return this.next.getDispatchQueue();
    }

    public Future<Void> connect() {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.connect(future);
            }
        });
        return future;
    }

    public Future<Void> disconnect() {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.disconnect(future);
            }
        });
        return future;
    }

    public Future<Void> kill() {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.kill(future);
            }
        });
        return future;
    }

    public Future<byte[]> subscribe(final Topic[] topics) {
        final Promise<byte[]> future = new Promise<byte[]>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.subscribe(topics, future);
            }
        });
        return future;
    }

    public Future<Void> unsubscribe(String[] topics) {
        UTF8Buffer[] buffers = new UTF8Buffer[topics.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new UTF8Buffer(topics[i]);
        }
        return this.unsubscribe(buffers);
    }

    public Future<Void> unsubscribe(final UTF8Buffer[] topics) {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.unsubscribe(topics, future);
            }
        });
        return future;
    }

    public Future<Void> publish(String topic, byte[] payload, QoS qos, boolean retain) {
        return this.publish(Buffer.utf8((String)topic), new Buffer(payload), qos, retain);
    }

    public Future<Void> publish(final UTF8Buffer topic, final Buffer payload, final QoS qos, final boolean retain) {
        final Promise<Void> future = new Promise<Void>();
        this.next.getDispatchQueue().execute(new Task(){

            public void run() {
                FutureConnection.this.next.publish(topic, payload, qos, retain, (Callback<Void>)future);
            }
        });
        return future;
    }

    public Future<Message> receive() {
        final Promise<Message> future = new Promise<Message>();
        this.getDispatchQueue().execute(new Task(){

            public void run() {
                if (FutureConnection.this.next.failure() != null) {
                    future.onFailure(FutureConnection.this.next.failure());
                } else if (FutureConnection.this.receivedFrames.isEmpty()) {
                    FutureConnection.this.receiveFutures.add(future);
                } else {
                    future.onSuccess(FutureConnection.this.receivedFrames.removeFirst());
                }
            }
        });
        return future;
    }

    public void resume() {
        this.next.resume();
    }

    public void suspend() {
        this.next.suspend();
    }
}

