/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.snapshot;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.NodeSerializeUtils;

public class PullSnapshotTaskDescriptor {
    private PartitionGroup previousHolders;
    private List<Integer> slots;
    private boolean requireReadOnly;

    public PullSnapshotTaskDescriptor() {
    }

    public PullSnapshotTaskDescriptor(PartitionGroup previousOwners, List<Integer> slots, boolean requireReadOnly) {
        this.previousHolders = previousOwners;
        this.slots = slots;
        this.requireReadOnly = requireReadOnly;
    }

    public PartitionGroup getPreviousHolders() {
        return this.previousHolders;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Integer> slots) {
        this.slots = slots;
    }

    boolean isRequireReadOnly() {
        return this.requireReadOnly;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.slots.size());
        for (Integer slot : this.slots) {
            dataOutputStream.writeInt(slot);
        }
        dataOutputStream.writeInt(this.previousHolders.getRaftId());
        dataOutputStream.writeInt(this.previousHolders.size());
        for (Node previousHolder : this.previousHolders) {
            NodeSerializeUtils.serialize(previousHolder, dataOutputStream);
        }
        dataOutputStream.writeBoolean(this.requireReadOnly);
    }

    public void deserialize(DataInputStream dataInputStream) throws IOException {
        int slotSize = dataInputStream.readInt();
        this.slots = new ArrayList<Integer>(slotSize);
        for (int i = 0; i < slotSize; ++i) {
            this.slots.add(dataInputStream.readInt());
        }
        this.previousHolders = new PartitionGroup(dataInputStream.readInt(), new Node[0]);
        int holderSize = dataInputStream.readInt();
        for (int i = 0; i < holderSize; ++i) {
            Node node = new Node();
            NodeSerializeUtils.deserialize(node, dataInputStream);
            this.previousHolders.add(node);
        }
        this.requireReadOnly = dataInputStream.readBoolean();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PullSnapshotTaskDescriptor that = (PullSnapshotTaskDescriptor)o;
        return this.requireReadOnly == that.requireReadOnly && Objects.equals(this.previousHolders, that.previousHolders) && Objects.equals(this.slots, that.slots);
    }

    public String toString() {
        return "PullSnapshotTaskDescriptor{ previousHolders=" + this.previousHolders + ", slots=" + this.slots + ", requireReadOnly=" + this.requireReadOnly + "}";
    }

    public int hashCode() {
        return Objects.hash(this.previousHolders, this.slots, this.requireReadOnly);
    }
}

