/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.core.layer;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.dataset.IUDFInputDataSet;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.UDFRawQueryInputDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.udf.core.layer.SafetyLine;
import org.apache.iotdb.db.query.udf.core.reader.LayerPointReader;
import org.apache.iotdb.db.query.udf.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Binary;

public class RawQueryInputLayer {
    private IUDFInputDataSet queryDataSet;
    private TSDataType[] dataTypes;
    private int timestampIndex;
    private ElasticSerializableRowRecordList rowRecordList;
    private SafetyLine safetyLine;

    public RawQueryInputLayer(long queryId, float memoryBudgetInMB, UDTFPlan queryPlan, List<ManagedSeriesReader> readers) throws QueryProcessException, IOException, InterruptedException {
        this.construct(queryId, memoryBudgetInMB, new UDFRawQueryInputDataSetWithoutValueFilter(queryId, queryPlan, readers));
    }

    public RawQueryInputLayer(long queryId, float memoryBudgetInMB, List<PartialPath> paths, List<TSDataType> dataTypes, TimeGenerator timeGenerator, List<IReaderByTimestamp> readers, List<List<Integer>> readerToIndexList, List<Boolean> cached) throws QueryProcessException {
        this.construct(queryId, memoryBudgetInMB, new RawQueryDataSetWithValueFilter(paths, dataTypes, timeGenerator, readers, readerToIndexList, cached, true));
    }

    public RawQueryInputLayer(long queryId, float memoryBudgetInMB, IUDFInputDataSet queryDataSet) throws QueryProcessException {
        this.construct(queryId, memoryBudgetInMB, queryDataSet);
    }

    private void construct(long queryId, float memoryBudgetInMB, IUDFInputDataSet queryDataSet) throws QueryProcessException {
        this.queryDataSet = queryDataSet;
        this.dataTypes = queryDataSet.getDataTypes().toArray(new TSDataType[0]);
        this.timestampIndex = this.dataTypes.length;
        this.rowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, queryId, memoryBudgetInMB, 1 + this.dataTypes.length / 2);
        this.safetyLine = new SafetyLine();
    }

    public void updateRowRecordListEvictionUpperBound() {
        this.rowRecordList.setEvictionUpperBound(this.safetyLine.getSafetyLine());
    }

    public LayerPointReader constructPointReader(int columnIndex) {
        return new InputLayerPointReader(columnIndex);
    }

    private class InputLayerPointReader
    implements LayerPointReader {
        private final SafetyLine.SafetyPile safetyPile;
        private final int columnIndex;
        private int currentRowIndex;
        private boolean hasCachedRowRecord;
        private Object[] cachedRowRecord;

        InputLayerPointReader(int columnIndex) {
            this.safetyPile = RawQueryInputLayer.this.safetyLine.addSafetyPile();
            this.columnIndex = columnIndex;
            this.currentRowIndex = -1;
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
        }

        @Override
        public boolean isConstantPointReader() {
            return false;
        }

        @Override
        public boolean next() throws IOException, QueryProcessException {
            if (this.hasCachedRowRecord) {
                return true;
            }
            for (int i = this.currentRowIndex + 1; i < RawQueryInputLayer.this.rowRecordList.size(); ++i) {
                Object[] rowRecordCandidate = RawQueryInputLayer.this.rowRecordList.getRowRecord(i);
                if (rowRecordCandidate[this.columnIndex] == null && !RawQueryInputLayer.this.rowRecordList.fieldsHasAnyNull(i)) continue;
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = i;
                break;
            }
            if (!this.hasCachedRowRecord) {
                while (RawQueryInputLayer.this.queryDataSet.hasNextRowInObjects()) {
                    Object[] rowRecordCandidate = RawQueryInputLayer.this.queryDataSet.nextRowInObjects();
                    RawQueryInputLayer.this.rowRecordList.put(rowRecordCandidate);
                    if (rowRecordCandidate[this.columnIndex] == null && !RawQueryInputLayer.this.rowRecordList.fieldsHasAnyNull(RawQueryInputLayer.this.rowRecordList.size() - 1)) continue;
                    this.hasCachedRowRecord = true;
                    this.cachedRowRecord = rowRecordCandidate;
                    this.currentRowIndex = RawQueryInputLayer.this.rowRecordList.size() - 1;
                    break;
                }
            }
            return this.hasCachedRowRecord;
        }

        @Override
        public void readyForNext() {
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
            this.safetyPile.moveForwardTo(this.currentRowIndex + 1);
        }

        @Override
        public TSDataType getDataType() {
            return RawQueryInputLayer.this.dataTypes[this.columnIndex];
        }

        @Override
        public long currentTime() {
            return (Long)this.cachedRowRecord[RawQueryInputLayer.this.timestampIndex];
        }

        @Override
        public int currentInt() {
            return (Integer)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public long currentLong() {
            return (Long)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public float currentFloat() {
            return ((Float)this.cachedRowRecord[this.columnIndex]).floatValue();
        }

        @Override
        public double currentDouble() {
            return (Double)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public boolean currentBoolean() {
            return (Boolean)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public boolean isCurrentNull() {
            return this.cachedRowRecord[this.columnIndex] == null;
        }

        @Override
        public Binary currentBinary() {
            return (Binary)this.cachedRowRecord[this.columnIndex];
        }
    }
}

