/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recover;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.sync.sender.recover.ISyncSenderLogAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSenderLogAnalyzer
implements ISyncSenderLogAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncSenderLogAnalyzer.class);
    private String senderPath;
    private File currentLocalFile;
    private File lastLocalFile;
    private File syncLogFile;

    public SyncSenderLogAnalyzer(String senderPath) {
        this.senderPath = senderPath;
        this.currentLocalFile = new File(senderPath, "current_local_files.txt");
        this.lastLocalFile = new File(senderPath, "last_local_files.txt");
        this.syncLogFile = new File(senderPath, "sync.log");
    }

    @Override
    public void recover() throws IOException {
        if (this.currentLocalFile.exists() && !this.lastLocalFile.exists()) {
            FileUtils.moveFile((File)this.currentLocalFile, (File)this.lastLocalFile);
        } else {
            HashSet<String> lastLocalFiles = new HashSet<String>();
            HashSet<String> deletedFiles = new HashSet<String>();
            HashSet<String> newFiles = new HashSet<String>();
            this.loadLastLocalFiles(lastLocalFiles);
            this.loadLogger(deletedFiles, newFiles);
            lastLocalFiles.removeAll(deletedFiles);
            lastLocalFiles.addAll(newFiles);
            this.updateLastLocalFile(lastLocalFiles);
        }
        FileUtils.deleteDirectory((File)new File(this.senderPath, "snapshot"));
        this.syncLogFile.delete();
    }

    @Override
    public void loadLastLocalFiles(Set<String> lastLocalFiles) {
        if (!this.lastLocalFile.exists()) {
            LOGGER.info("last local file {} doesn't exist.", (Object)this.lastLocalFile.getAbsolutePath());
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.lastLocalFile));){
            String line;
            while ((line = br.readLine()) != null) {
                lastLocalFiles.add(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("Can not load last local file list from file {}", (Object)this.lastLocalFile.getAbsoluteFile(), (Object)e);
        }
    }

    @Override
    public void loadLogger(Set<String> deletedFiles, Set<String> newFiles) {
        if (!this.syncLogFile.exists()) {
            LOGGER.info("log file {} doesn't exist.", (Object)this.syncLogFile.getAbsolutePath());
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(this.syncLogFile));){
            String line;
            int mode = 0;
            while ((line = br.readLine()) != null) {
                if (line.equals("sync deleted file names start")) {
                    mode = -1;
                    continue;
                }
                if (line.equals("sync tsfile start")) {
                    mode = 1;
                    continue;
                }
                if (mode == -1) {
                    deletedFiles.add(line);
                    continue;
                }
                if (mode != 1) continue;
                newFiles.add(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("Can not load last local file list from file {}", (Object)this.lastLocalFile.getAbsoluteFile(), (Object)e);
        }
    }

    @Override
    public void updateLastLocalFile(Set<String> currentLocalFiles) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.currentLocalFile));){
            for (String line : currentLocalFiles) {
                bw.write(line);
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            LOGGER.error("Can not clear sync log {}", (Object)this.syncLogFile.getAbsoluteFile(), (Object)e);
        }
        this.lastLocalFile.delete();
        FileUtils.moveFile((File)this.currentLocalFile, (File)this.lastLocalFile);
    }
}

