/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Offset;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ShowStatement
extends Statement {
    private final String tableName;
    private final Optional<Expression> where;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<Node> limit;

    public ShowStatement(NodeLocation location, String tableName, Optional<Expression> where, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = tableName;
        this.where = where;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<Node> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowStatement(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowStatement that = (ShowStatement)o;
        return Objects.equals(this.tableName, that.tableName) && Objects.equals(this.where, that.where) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.offset, that.offset) && Objects.equals(this.limit, that.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.where, this.orderBy, this.offset, this.limit);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("where", this.where.orElse(null)).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).omitNullValues().toString();
    }
}

