/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.sys;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class FlushStatement
extends Statement
implements IConfigStatement {
    private List<String> databases;
    private Boolean isSeq;
    private boolean onCluster;

    public FlushStatement(StatementType flushType) {
        this.statementType = flushType;
    }

    public List<String> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<String> databases) {
        this.databases = databases;
    }

    public Boolean isSeq() {
        return this.isSeq;
    }

    public void setSeq(Boolean seq) {
        this.isSeq = seq;
    }

    public boolean isOnCluster() {
        return this.onCluster;
    }

    public void setOnCluster(boolean onCluster) {
        this.onCluster = onCluster;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        if (this.databases == null) {
            return Collections.emptyList();
        }
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>(this.databases.size());
        try {
            for (String database : this.databases) {
                paths.add(new PartialPath(database));
            }
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        return paths;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitFlush(this, context);
    }
}

