/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class MinAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MinAccumulator.class);
    private final TSDataType seriesDataType;
    private final TsPrimitiveType minResult;
    private boolean initResult;

    public MinAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.minResult = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new MinAccumulator(this.seriesDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        Preconditions.checkArgument((arguments.length == 1 ? 1 : 0) != 0, (Object)"argument of MIN should be one column");
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], mask);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in MIN Aggregation: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    this.updateIntMinValue(argument.getInt(i));
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    this.updateLongMinValue(argument.getLong(i));
                    continue block8;
                }
                case FLOAT: {
                    this.updateFloatMinValue(argument.getFloat(i));
                    continue block8;
                }
                case DOUBLE: {
                    this.updateDoubleMinValue(argument.getDouble(i));
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    this.updateBinaryMinValue(argument.getBinary(i));
                    continue block8;
                }
                case BOOLEAN: {
                    this.updateBooleanMinValue(argument.getBoolean(i));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in MIN Aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.minResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.minResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.minResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.minResult.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.minResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.minResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MIN Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                columnBuilder.writeInt(this.minResult.getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                columnBuilder.writeLong(this.minResult.getLong());
                break;
            }
            case FLOAT: {
                columnBuilder.writeFloat(this.minResult.getFloat());
                break;
            }
            case DOUBLE: {
                columnBuilder.writeDouble(this.minResult.getDouble());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                columnBuilder.writeBinary(this.minResult.getBinary());
                break;
            }
            case BOOLEAN: {
                columnBuilder.writeBoolean(this.minResult.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MIN Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.updateIntMinValue((Integer)statistics[0].getMinValue());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.updateLongMinValue((Long)statistics[0].getMinValue());
                break;
            }
            case FLOAT: {
                this.updateFloatMinValue(((Float)statistics[0].getMinValue()).floatValue());
                break;
            }
            case DOUBLE: {
                this.updateDoubleMinValue((Double)statistics[0].getMinValue());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.updateBinaryMinValue((Binary)statistics[0].getMinValue());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanMinValue((Boolean)statistics[0].getMinValue());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in MIN Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.minResult.reset();
    }

    private void addIntInput(Column valueColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateIntMinValue(valueColumn.getInt(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateIntMinValue(valueColumn.getInt(position));
            }
        }
    }

    protected void updateIntMinValue(int value) {
        if (!this.initResult || value < this.minResult.getInt()) {
            this.initResult = true;
            this.minResult.setInt(value);
        }
    }

    private void addLongInput(Column valueColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateLongMinValue(valueColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateLongMinValue(valueColumn.getLong(position));
            }
        }
    }

    protected void updateLongMinValue(long value) {
        if (!this.initResult || value < this.minResult.getLong()) {
            this.initResult = true;
            this.minResult.setLong(value);
        }
    }

    private void addFloatInput(Column valueColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateFloatMinValue(valueColumn.getFloat(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateFloatMinValue(valueColumn.getFloat(position));
            }
        }
    }

    protected void updateFloatMinValue(float value) {
        if (!this.initResult || value < this.minResult.getFloat()) {
            this.initResult = true;
            this.minResult.setFloat(value);
        }
    }

    private void addDoubleInput(Column valueColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateDoubleMinValue(valueColumn.getDouble(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateDoubleMinValue(valueColumn.getDouble(position));
            }
        }
    }

    protected void updateDoubleMinValue(double value) {
        if (!this.initResult || value < this.minResult.getDouble()) {
            this.initResult = true;
            this.minResult.setDouble(value);
        }
    }

    private void addBinaryInput(Column valueColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBinaryMinValue(valueColumn.getBinary(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBinaryMinValue(valueColumn.getBinary(position));
            }
        }
    }

    protected void updateBinaryMinValue(Binary value) {
        if (!this.initResult || value.compareTo(this.minResult.getBinary()) < 0) {
            this.initResult = true;
            this.minResult.setBinary(value);
        }
    }

    private void addBooleanInput(Column valueColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < valueColumn.getPositionCount(); ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBooleanMinValue(valueColumn.getBoolean(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBooleanMinValue(valueColumn.getBoolean(position));
            }
        }
    }

    protected void updateBooleanMinValue(boolean value) {
        if (!this.initResult || !value) {
            this.initResult = true;
            this.minResult.setBoolean(value);
        }
    }
}

