/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing.distributed;

import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.ReceiverProvider;
import org.apache.james.eventsourcing.EventSourcingSystem;
import org.apache.james.server.task.json.JsonTaskSerializer;
import org.apache.james.task.SerialTaskManagerWorker;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.eventsourcing.WorkQueueSupplier;
import org.apache.james.task.eventsourcing.WorkerStatusListener;
import org.apache.james.task.eventsourcing.distributed.CancelRequestQueueName;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueue;
import org.apache.james.task.eventsourcing.distributed.RabbitMQWorkQueueConfiguration;
import reactor.rabbitmq.Sender;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\n\u0014\u0001\u0001B\u0001b\u000b\u0001\u0003\u0006\u0004%I\u0001\f\u0005\tk\u0001\u0011\t\u0011)A\u0005[!Aa\u0007\u0001BC\u0002\u0013%q\u0007\u0003\u0005@\u0001\t\u0005\t\u0015!\u00039\u0011!\u0001\u0005A!b\u0001\n\u0013\t\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u00111\u0003!Q1A\u0005\n5C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t'\u0002\u0011)\u0019!C\u0005)\"A\u0001\f\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Z\u0001\t\u0015\r\u0011\"\u0003[\u0011!q\u0006A!A!\u0002\u0013Y\u0006\"B0\u0001\t\u0003\u0001\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007w\u0002\u0001\u000b\u0011B:\t\u000bq\u0004A\u0011I?\t\rq\u0004A\u0011AA\t\u0005e\u0011\u0016M\u00192ji6\u000bvk\u001c:l#V,W/Z*vaBd\u0017.\u001a:\u000b\u0005Q)\u0012a\u00033jgR\u0014\u0018NY;uK\u0012T!AF\f\u0002\u001b\u00154XM\u001c;t_V\u00148-\u001b8h\u0015\tA\u0012$\u0001\u0003uCN\\'B\u0001\u000e\u001c\u0003\u0015Q\u0017-\\3t\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA\u0013&D\u0001\u0016\u0013\tQSCA\tX_J\\\u0017+^3vKN+\b\u000f\u001d7jKJ\faa]3oI\u0016\u0014X#A\u0017\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001\u0003:bE\nLG/\\9\u000b\u0003I\nqA]3bGR|'/\u0003\u00025_\t11+\u001a8eKJ\fqa]3oI\u0016\u0014\b%\u0001\tsK\u000e,\u0017N^3s!J|g/\u001b3feV\t\u0001\b\u0005\u0002:{5\t!H\u0003\u00021w)\u0011A(G\u0001\tE\u0006\u001c7.\u001a8eg&\u0011aH\u000f\u0002\u0011%\u0016\u001cW-\u001b<feB\u0013xN^5eKJ\f\u0011C]3dK&4XM\u001d)s_ZLG-\u001a:!\u0003IQ7o\u001c8UCN\\7+\u001a:jC2L'0\u001a:\u0016\u0003\t\u0003\"aQ%\u000e\u0003\u0011S!!\u0012$\u0002\t)\u001cxN\u001c\u0006\u00031\u001dS!\u0001S\r\u0002\rM,'O^3s\u0013\tQEI\u0001\nKg>tG+Y:l'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018a\u00056t_:$\u0016m]6TKJL\u0017\r\\5{KJ\u0004\u0013!E2b]\u000e,GNU3rk\u0016\u001cHOT1nKV\ta\n\u0005\u0002P!6\t1#\u0003\u0002R'\t12)\u00198dK2\u0014V-];fgR\fV/Z;f\u001d\u0006lW-\u0001\ndC:\u001cW\r\u001c*fcV,7\u000f\u001e(b[\u0016\u0004\u0013!D2p]\u001aLw-\u001e:bi&|g.F\u0001V!\tye+\u0003\u0002X'\tq\"+\u00192cSRl\u0015kV8sWF+X-^3D_:4\u0017nZ;sCRLwN\\\u0001\u000fG>tg-[4ve\u0006$\u0018n\u001c8!\u0003U\u0011\u0018M\u00192ji6\u000b6i\u001c8gS\u001e,(/\u0019;j_:,\u0012a\u0017\t\u0003sqK!!\u0018\u001e\u0003+I\u000b'MY5u\u001bF\u001buN\u001c4jOV\u0014\u0018\r^5p]\u00061\"/\u00192cSRl\u0015kQ8oM&<WO]1uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\bC\n\u001cG-\u001a4h!\ty\u0005\u0001C\u0003,\u001b\u0001\u0007Q\u0006C\u00037\u001b\u0001\u0007\u0001\bC\u0003A\u001b\u0001\u0007!\tC\u0003M\u001b\u0001\u0007a\nC\u0003T\u001b\u0001\u0007Q\u000bC\u0003Z\u001b\u0001\u00071\f\u000b\u0002\u000eSB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0007S:TWm\u0019;\u000b\u00039\fQA[1wCbL!\u0001]6\u0003\r%s'.Z2u\u0003=\"UIR!V\u0019R{\u0016\t\u0012#J)&{e*\u0011'`\u0013:3uJU'B)&{ej\u0018)P\u00192KejR0J\u001dR+%KV!M+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011!\u0018.\\3\u000b\u0003a\fAA[1wC&\u0011!0\u001e\u0002\t\tV\u0014\u0018\r^5p]\u0006\u0001D)\u0012$B+2#v,\u0011#E\u0013RKuJT!M?&sei\u0014*N\u0003RKuJT0Q\u001f2c\u0015JT$`\u0013:#VI\u0015,B\u0019\u0002\nQ!\u00199qYf$2A`A\u0002!\tyu0C\u0002\u0002\u0002M\u0011\u0011CU1cE&$X*U,pe.\fV/Z;f\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000f\t1#\u001a<f]R\u001cv.\u001e:dS:<7+_:uK6\u0004B!!\u0003\u0002\u000e5\u0011\u00111\u0002\u0006\u0003-eIA!a\u0004\u0002\f\t\u0019RI^3oiN{WO]2j]\u001e\u001c\u0016p\u001d;f[R)a0a\u0005\u0002\u0016!9\u0011QA\tA\u0002\u0005\u001d\u0001BBA\f#\u0001\u00071/\u0001\u0013bI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8Q_2d\u0017N\\4J]R,'O^1mQ\r\t\u00121\u0004\t\u0005\u0003;\ty#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005\u0015\u0012qE\u0001\u0007G>lWn\u001c8\u000b\t\u0005%\u00121F\u0001\u0007O>|w\r\\3\u000b\u0005\u00055\u0012aA2p[&!\u0011\u0011GA\u0010\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a")
public class RabbitMQWorkQueueSupplier
implements WorkQueueSupplier {
    private final Sender sender;
    private final ReceiverProvider receiverProvider;
    private final JsonTaskSerializer jsonTaskSerializer;
    private final CancelRequestQueueName cancelRequestName;
    private final RabbitMQWorkQueueConfiguration configuration;
    private final RabbitMQConfiguration rabbitMQConfiguration;
    private final Duration DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL;

    private Sender sender() {
        return this.sender;
    }

    private ReceiverProvider receiverProvider() {
        return this.receiverProvider;
    }

    private JsonTaskSerializer jsonTaskSerializer() {
        return this.jsonTaskSerializer;
    }

    private CancelRequestQueueName cancelRequestName() {
        return this.cancelRequestName;
    }

    private RabbitMQWorkQueueConfiguration configuration() {
        return this.configuration;
    }

    private RabbitMQConfiguration rabbitMQConfiguration() {
        return this.rabbitMQConfiguration;
    }

    public Duration DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL() {
        return this.DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL;
    }

    public RabbitMQWorkQueue apply(EventSourcingSystem eventSourcingSystem) {
        return this.apply(eventSourcingSystem, this.DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL());
    }

    @VisibleForTesting
    public RabbitMQWorkQueue apply(EventSourcingSystem eventSourcingSystem, Duration additionalInformationPollingInterval) {
        WorkerStatusListener listener = new WorkerStatusListener(eventSourcingSystem);
        SerialTaskManagerWorker worker = new SerialTaskManagerWorker((TaskManagerWorker.Listener)listener, additionalInformationPollingInterval);
        RabbitMQWorkQueue rabbitMQWorkQueue = new RabbitMQWorkQueue((TaskManagerWorker)worker, this.sender(), this.receiverProvider(), this.jsonTaskSerializer(), this.configuration(), this.cancelRequestName(), this.rabbitMQConfiguration());
        return rabbitMQWorkQueue;
    }

    @Inject
    public RabbitMQWorkQueueSupplier(Sender sender, ReceiverProvider receiverProvider, JsonTaskSerializer jsonTaskSerializer, CancelRequestQueueName cancelRequestName, RabbitMQWorkQueueConfiguration configuration, RabbitMQConfiguration rabbitMQConfiguration) {
        this.sender = sender;
        this.receiverProvider = receiverProvider;
        this.jsonTaskSerializer = jsonTaskSerializer;
        this.cancelRequestName = cancelRequestName;
        this.configuration = configuration;
        this.rabbitMQConfiguration = rabbitMQConfiguration;
        this.DEFAULT_ADDITIONAL_INFORMATION_POLLING_INTERVAL = Duration.ofSeconds(30L);
    }
}

