/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class ReadOnlyLDAPGroupRestriction {
    private String memberAttribute;
    private final List<String> groupDNs = new ArrayList<String>();

    public ReadOnlyLDAPGroupRestriction(HierarchicalConfiguration<ImmutableNode> configuration) {
        if (configuration != null) {
            this.memberAttribute = configuration.getString("[@memberAttribute]");
            if (configuration.getKeys("group").hasNext()) {
                Collections.addAll(this.groupDNs, configuration.getStringArray("group"));
            }
        }
    }

    protected boolean isActivated() {
        return !this.groupDNs.isEmpty();
    }

    public String toString() {
        return "Activated=" + this.isActivated() + "; Groups=" + this.groupDNs;
    }

    protected Map<String, Collection<DN>> getGroupMembershipLists(LDAPConnectionPool connection) throws LDAPException {
        HashMap<String, Collection<DN>> result = new HashMap<String, Collection<DN>>();
        for (String groupDN : this.groupDNs) {
            result.put(groupDN, this.extractMembers(connection.getEntry(groupDN)));
        }
        return result;
    }

    private Collection<DN> extractMembers(SearchResultEntry entry) {
        Attribute members = entry.getAttribute(this.memberAttribute);
        return (Collection)Arrays.stream(members.getValues()).map(Throwing.function(DN::new)).collect(ImmutableList.toImmutableList());
    }
}

