/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.backup.zip;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.Flags;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.james.mailbox.backup.zip.StringExtraField;
import org.apache.james.mailbox.backup.zip.WithZipHeader;
import org.apache.james.util.StreamUtils;

public class FlagsExtraField
extends StringExtraField
implements WithZipHeader {
    public static final ZipShort ID_AP = new ZipShort(WithZipHeader.toLittleEndian('a', 'p'));

    private static String serializeFlags(Flags flags) {
        return Stream.concat(StreamUtils.ofNullable((Object[])flags.getSystemFlags()).map(FlagsExtraField::systemFlagToString), StreamUtils.ofNullable((Object[])flags.getUserFlags())).collect(Collectors.joining("%"));
    }

    public FlagsExtraField() {
    }

    public FlagsExtraField(Flags flags) {
        super(Optional.of(FlagsExtraField.serializeFlags(flags)));
    }

    public ZipShort getHeaderId() {
        return ID_AP;
    }

    private static String systemFlagToString(Flags.Flag flag) throws RuntimeException {
        if (flag == Flags.Flag.ANSWERED) {
            return "\\ANSWERED";
        }
        if (flag == Flags.Flag.DELETED) {
            return "\\DELETED";
        }
        if (flag == Flags.Flag.DRAFT) {
            return "\\DRAFT";
        }
        if (flag == Flags.Flag.FLAGGED) {
            return "\\FLAGGED";
        }
        if (flag == Flags.Flag.RECENT) {
            return "\\RECENT";
        }
        if (flag == Flags.Flag.SEEN) {
            return "\\SEEN";
        }
        throw new RuntimeException("Unknown system flag");
    }
}

