/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scala.publisher;

import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.ReactiveSFlux;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.VersionedSFluxCompanion;
import reactor.core.scala.publisher.package$;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.Queues;
import reactor.util.context.Context;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SFlux$
implements VersionedSFluxCompanion {
    public static final SFlux$ MODULE$ = new SFlux$();

    static {
        VersionedSFluxCompanion.$init$(MODULE$);
    }

    @Override
    public <T> SFlux<T> fromStream(Function0<Stream<T>> streamSupplier) {
        return VersionedSFluxCompanion.fromStream$(this, streamSupplier);
    }

    @Override
    public <T> SFlux<T> fromLazyList(Function0<LazyList<T>> lazyListSupplier) {
        return VersionedSFluxCompanion.fromLazyList$(this, lazyListSupplier);
    }

    public <T> SFlux<T> apply(Publisher<? extends T> source) {
        return this.fromPublisher(source);
    }

    public <T> SFlux<T> apply(Seq<T> elements) {
        return this.fromIterable((Iterable<T>)elements);
    }

    public <T1, T2> SFlux<Tuple2<T1, T2>> combineLatest(Publisher<T1> p1, Publisher<T2> p2) {
        return new ReactiveSFlux<Tuple2<T1, T2>>(Flux.combineLatest(p1, p2, (t1, t2) -> new Tuple2(t1, t2)));
    }

    public <T> SFlux<Seq<T>> combineLatest(Seq<Publisher<T>> sources) {
        return new ReactiveSFlux<Seq<T>>(Flux.combineLatest(package$.MODULE$.scalaIterable2JavaIterable(sources), arr -> (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(arr)).map((Function1 & Serializable)x$8 -> x$8)));
    }

    public <T1, T2, V> SFlux<V> combineLatestMap(Publisher<T1> p1, Publisher<T2> p2, Function2<T1, T2, V> mapper) {
        return new ReactiveSFlux(Flux.combineLatest(p1, p2, package$.MODULE$.scalaBiFunction2JavaBiFunction(mapper)));
    }

    public <T, V> SFlux<V> combineLatestMap(Function1<Object, V> mapper, Seq<Publisher<T>> sources, ClassTag<T> evidence$1) {
        Function1 & Serializable f = (Function1 & Serializable)arr -> {
            Seq x = (Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps(arr)).map((Function1 & Serializable)x$9 -> x$9);
            return mapper.apply(x.toArray(evidence$1));
        };
        return new ReactiveSFlux(Flux.combineLatest(package$.MODULE$.scalaIterable2JavaIterable(sources), package$.MODULE$.scalaFunction2JavaFunction(f)));
    }

    public <T> SFlux<T> concat(Seq<Publisher<T>> sources) {
        return new ReactiveSFlux(Flux.concat(package$.MODULE$.scalaIterable2JavaIterable(sources)));
    }

    public <T> SFlux<T> concatDelayError(Seq<Publisher<T>> sources) {
        return new ReactiveSFlux(Flux.concatDelayError((Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))));
    }

    public <T> SFlux<T> create(Function1<FluxSink<T>, BoxedUnit> emitter, FluxSink.OverflowStrategy backPressure) {
        return new ReactiveSFlux(Flux.create(package$.MODULE$.scalaConsumer2JConsumer(emitter), (FluxSink.OverflowStrategy)backPressure));
    }

    public <T> FluxSink.OverflowStrategy create$default$2() {
        return FluxSink.OverflowStrategy.BUFFER;
    }

    public <T> SFlux<T> defer(Function0<Publisher<T>> f) {
        return new ReactiveSFlux(Flux.defer(() -> (Publisher)f.apply()));
    }

    public <T> ReactiveSFlux<T> deferWithContext(Function1<Context, Publisher<T>> supplier) {
        return new ReactiveSFlux(Flux.deferWithContext(package$.MODULE$.scalaFunction2JavaFunction(supplier)));
    }

    public <T> SFlux<T> empty() {
        return new ReactiveSFlux(Flux.empty());
    }

    public <I> SFlux<I> firstEmitter(Seq<Publisher<? extends I>> sources) {
        return new ReactiveSFlux(Flux.first((Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))));
    }

    public <T> SFlux<T> fromArray(T[] array) {
        return new ReactiveSFlux(Flux.fromArray((Object[])array));
    }

    public <T> SFlux<T> fromIterable(Iterable<T> iterable) {
        return new ReactiveSFlux(Flux.fromIterable((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(iterable).asJava())));
    }

    public <T> SFlux<T> fromPublisher(Publisher<? extends T> source) {
        return new ReactiveSFlux(Flux.from(source));
    }

    public <T, S> SFlux<T> generate(Function2<S, SynchronousSink<T>, S> generator, Option<Callable<S>> stateSupplier, Option<Function1<S, BoxedUnit>> stateConsumer) {
        return new ReactiveSFlux(Flux.generate((Callable)((Callable)stateSupplier.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), package$.MODULE$.scalaBiFunction2JavaBiFunction(generator), package$.MODULE$.scalaConsumer2JConsumer((Function1)stateConsumer.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    public <T, S> None$ generate$default$2() {
        return None$.MODULE$;
    }

    public <T, S> None$ generate$default$3() {
        return None$.MODULE$;
    }

    public SFlux<Object> interval(Duration period, Scheduler scheduler, Duration delay) {
        return new ReactiveSFlux<Object>((Publisher<Object>)Flux.interval((java.time.Duration)package$.MODULE$.scalaDuration2JavaDuration(delay), (java.time.Duration)package$.MODULE$.scalaDuration2JavaDuration(period), (Scheduler)scheduler).map(l -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(l))));
    }

    public Scheduler interval$default$2() {
        return Schedulers.parallel();
    }

    public Duration interval$default$3(Duration period, Scheduler scheduler) {
        return period;
    }

    public <T> SFlux<T> just(Seq<T> data) {
        return this.apply(data);
    }

    public <I> ReactiveSFlux<I> merge(Seq<Publisher<? extends I>> sources, int prefetch, boolean delayError) {
        return delayError ? new ReactiveSFlux(Flux.mergeDelayError((int)prefetch, (Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class))))) : new ReactiveSFlux(Flux.merge((int)prefetch, (Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))));
    }

    public <I> int merge$default$2() {
        return Queues.XS_BUFFER_SIZE;
    }

    public <I> boolean merge$default$3() {
        return false;
    }

    public <I extends Comparable<I>> ReactiveSFlux<I> mergeOrdered(Seq<Publisher<? extends I>> sources, int prefetch, Comparator<I> comparator) {
        return new ReactiveSFlux(Flux.mergeOrdered((int)prefetch, comparator, (Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))));
    }

    public <I extends Comparable<I>> int mergeOrdered$default$2() {
        return Queues.SMALL_BUFFER_SIZE;
    }

    public <I extends Comparable<I>> Comparator<I> mergeOrdered$default$3() {
        return Comparator.naturalOrder();
    }

    public <T> SFlux<T> mergeSequentialPublisher(Publisher<? extends Publisher<T>> sources, boolean delayError, int maxConcurrency, int prefetch) {
        return new ReactiveSFlux(delayError ? Flux.mergeSequentialDelayError(sources, (int)maxConcurrency, (int)prefetch) : Flux.mergeSequential(sources, (int)maxConcurrency, (int)prefetch));
    }

    public <I> SFlux<I> mergeSequential(Seq<Publisher<? extends I>> sources, boolean delayError, int prefetch) {
        return new ReactiveSFlux(delayError ? Flux.mergeSequentialDelayError((int)prefetch, (Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))) : Flux.mergeSequential((int)prefetch, (Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))));
    }

    public <T> boolean mergeSequentialPublisher$default$2() {
        return false;
    }

    public <T> int mergeSequentialPublisher$default$3() {
        return Queues.SMALL_BUFFER_SIZE;
    }

    public <T> int mergeSequentialPublisher$default$4() {
        return Queues.XS_BUFFER_SIZE;
    }

    public <I> boolean mergeSequential$default$2() {
        return false;
    }

    public <I> int mergeSequential$default$3() {
        return Queues.XS_BUFFER_SIZE;
    }

    public <I> ReactiveSFlux<I> mergeSequentialIterable(Iterable<Publisher<? extends I>> sources, boolean delayError, int maxConcurrency, int prefetch) {
        return new ReactiveSFlux(delayError ? Flux.mergeSequentialDelayError(package$.MODULE$.scalaIterable2JavaIterable(sources), (int)maxConcurrency, (int)prefetch) : Flux.mergeSequential(package$.MODULE$.scalaIterable2JavaIterable(sources), (int)maxConcurrency, (int)prefetch));
    }

    public <I> boolean mergeSequentialIterable$default$2() {
        return false;
    }

    public <I> int mergeSequentialIterable$default$3() {
        return Queues.SMALL_BUFFER_SIZE;
    }

    public <I> int mergeSequentialIterable$default$4() {
        return Queues.XS_BUFFER_SIZE;
    }

    public <T> SFlux<T> never() {
        return new ReactiveSFlux(Flux.never());
    }

    public <T> SFlux<T> push(Function1<FluxSink<T>, BoxedUnit> emitter, FluxSink.OverflowStrategy backPressure) {
        return new ReactiveSFlux(Flux.push(package$.MODULE$.scalaConsumer2JConsumer(emitter), (FluxSink.OverflowStrategy)backPressure));
    }

    public <T> FluxSink.OverflowStrategy push$default$2() {
        return FluxSink.OverflowStrategy.BUFFER;
    }

    public <T> SFlux<T> raiseError(Throwable exception, boolean whenRequested) {
        return this.error(exception, whenRequested);
    }

    public <T> boolean raiseError$default$2() {
        return false;
    }

    public <T> SFlux<T> error(Throwable exception, boolean whenRequested) {
        return new ReactiveSFlux(Flux.error((Throwable)exception, (boolean)whenRequested));
    }

    public <T> boolean error$default$2() {
        return false;
    }

    public SFlux<Object> range(int start, int count) {
        return new ReactiveSFlux<Object>((Publisher<Object>)Flux.range((int)start, (int)count).map(i -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(i))));
    }

    public <T> SFlux<T> switchOnNext(Publisher<? extends Publisher<? extends T>> mergedPublishers) {
        return this.fromPublisher((Publisher<? extends T>)Flux.switchOnNext(mergedPublishers));
    }

    public <T, D> SFlux<T> using(Function0<D> resourceSupplier, Function1<D, Publisher<? extends T>> sourceSupplier, Function1<D, BoxedUnit> resourceCleanup, boolean eager) {
        return new ReactiveSFlux(Flux.using(package$.MODULE$.scalaFunction2JavaCallable(resourceSupplier), package$.MODULE$.scalaFunction2JavaFunction(sourceSupplier), package$.MODULE$.scalaConsumer2JConsumer(resourceCleanup), (boolean)eager));
    }

    public <T, D> boolean using$default$4() {
        return false;
    }

    public <T1, T2> SFlux<Tuple2<T1, T2>> zip(Publisher<? extends T1> source1, Publisher<? extends T2> source2) {
        return new ReactiveSFlux<Tuple2<T1, T2>>(Flux.zip(source1, source2, (t1, t2) -> new Tuple2(t1, t2)));
    }

    public <T1, T2, T3> SFlux<Tuple3<T1, T2, T3>> zip3(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3) {
        return new ReactiveSFlux<Tuple3<T1, T2, T3>>(Flux.zip(source1, source2, source3).map(t -> package$.MODULE$.tupleThree2ScalaTuple3(t)));
    }

    public <T1, T2, T3, T4> SFlux<Tuple4<T1, T2, T3, T4>> zip4(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4) {
        return new ReactiveSFlux<Tuple4<T1, T2, T3, T4>>(Flux.zip(source1, source2, source3, source4).map(t -> package$.MODULE$.tupleFour2ScalaTuple4(t)));
    }

    public <T1, T2, T3, T4, T5> SFlux<Tuple5<T1, T2, T3, T4, T5>> zip5(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5) {
        return new ReactiveSFlux<Tuple5<T1, T2, T3, T4, T5>>(Flux.zip(source1, source2, source3, source4, source5).map(t -> package$.MODULE$.tupleFive2ScalaTuple5(t)));
    }

    public <T1, T2, T3, T4, T5, T6> SFlux<Tuple6<T1, T2, T3, T4, T5, T6>> zip6(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Publisher<? extends T3> source3, Publisher<? extends T4> source4, Publisher<? extends T5> source5, Publisher<? extends T6> source6) {
        return new ReactiveSFlux<Tuple6<T1, T2, T3, T4, T5, T6>>(Flux.zip(source1, source2, source3, source4, source5, source6).map(t -> package$.MODULE$.tupleSix2ScalaTuple6(t)));
    }

    public <T1, T2, O> SFlux<O> zipMap(Publisher<? extends T1> source1, Publisher<? extends T2> source2, Function2<T1, T2, O> combinator) {
        return new ReactiveSFlux(Flux.zip(source1, source2, package$.MODULE$.scalaBiFunction2JavaBiFunction(combinator)));
    }

    public <O> SFlux<O> zipMapIterable(Iterable<? extends Publisher<?>> sources, Function1<Object, O> combinator, int prefetch) {
        return new ReactiveSFlux(Flux.zip(package$.MODULE$.scalaIterable2JavaIterable(sources), (int)prefetch, package$.MODULE$.scalaFunction2JavaFunction(combinator)));
    }

    public <I, O> SFlux<O> zipMap(Function1<Object[], O> combinator, Seq<Publisher<? extends I>> sources, int prefetch) {
        return new ReactiveSFlux(Flux.zip(package$.MODULE$.scalaFunction2JavaFunction(combinator), (int)prefetch, (Publisher[])((Publisher[])sources.toArray(ClassTag$.MODULE$.apply(Publisher.class)))));
    }

    public <O> int zipMapIterable$default$3() {
        return Queues.SMALL_BUFFER_SIZE;
    }

    public <I, O> int zipMap$default$3() {
        return Queues.XS_BUFFER_SIZE;
    }

    private SFlux$() {
    }
}

