/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.james.jmap.http.AuthenticationChallenge;

public class AuthenticateHeader {
    public static final String HEADER_NAME = "WWW-Authenticate";
    private final ImmutableList<AuthenticationChallenge> challenges;

    public static AuthenticateHeader of(Collection<AuthenticationChallenge> challenges) {
        return new AuthenticateHeader((ImmutableList<AuthenticationChallenge>)ImmutableList.copyOf(challenges));
    }

    private AuthenticateHeader(ImmutableList<AuthenticationChallenge> challenges) {
        this.challenges = challenges;
    }

    public String asHeaderValue() {
        return this.challenges.stream().map(AuthenticationChallenge::asString).collect(Collectors.joining(", "));
    }
}

