/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.james.jmap.http.AuthenticationScheme;

public class AuthenticationChallenge {
    private final AuthenticationScheme scheme;
    private final ImmutableMap<String, String> parameters;

    public static AuthenticationChallenge of(AuthenticationScheme scheme, Map<String, String> parameters) {
        Preconditions.checkNotNull((Object)scheme);
        Preconditions.checkNotNull(parameters);
        return new AuthenticationChallenge(scheme, (ImmutableMap<String, String>)ImmutableMap.copyOf(parameters));
    }

    public AuthenticationChallenge(AuthenticationScheme scheme, ImmutableMap<String, String> parameters) {
        this.scheme = scheme;
        this.parameters = parameters;
    }

    public String asString() {
        return String.format("%s %s", this.scheme.asString(), this.parameters.entrySet().stream().map(entry -> String.format("%s=\"%s\"", entry.getKey(), entry.getValue())).collect(Collectors.joining(", ")));
    }

    public final boolean equals(Object o) {
        if (o instanceof AuthenticationChallenge) {
            AuthenticationChallenge that = (AuthenticationChallenge)o;
            return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.scheme, this.parameters);
    }
}

