/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Resolver;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public abstract class AbstractExpressionBuilder {
    protected static final int EX_USER = 0;
    protected static final int EX_FATAL = 1;
    protected static final int EX_UNSUPPORTED = 2;
    public static final Class<Object> TYPE_OBJECT = Object.class;
    public static final Class<String> TYPE_STRING = String.class;
    public static final Class<Character> TYPE_CHAR_OBJ = Character.class;
    public static final Class<Number> TYPE_NUMBER = Number.class;
    public static final Class<Collection> TYPE_COLLECTION = Collection.class;
    public static final Class<Map> TYPE_MAP = Map.class;
    public static final int CONTAINS_TYPE_ELEMENT = 1;
    public static final int CONTAINS_TYPE_KEY = 2;
    public static final int CONTAINS_TYPE_VALUE = 3;
    private static final Localizer _loc = Localizer.forPackage(AbstractExpressionBuilder.class);
    protected final Resolver resolver;
    protected ExpressionFactory factory;
    private final Set<ClassMetaData> _accessPath = new HashSet<ClassMetaData>();
    private Map<String, Value> _seenVars = null;
    private Set<Value> _boundVars = null;

    public AbstractExpressionBuilder(ExpressionFactory factory, Resolver resolver) {
        this.factory = factory;
        this.resolver = resolver;
    }

    protected abstract ClassLoader getClassLoader();

    protected OpenJPAException parseException(int e, String token, Object[] args, Exception nest) {
        String argStr = args == null ? this.getLocalizer().get(token).getMessage() : this.getLocalizer().get(token, args).getMessage();
        Localizer.Message msg = _loc.get("parse-error", argStr, this.currentQuery());
        switch (e) {
            case 1: {
                throw new InternalException(msg, (Throwable)nest);
            }
            case 2: {
                throw new UnsupportedException(msg, (Throwable)nest);
            }
        }
        throw new UserException(msg, (Throwable)nest);
    }

    protected ClassMetaData addAccessPath(ClassMetaData meta) {
        this._accessPath.add(meta);
        return meta;
    }

    protected ClassMetaData[] getAccessPath() {
        return this._accessPath.toArray(new ClassMetaData[this._accessPath.size()]);
    }

    protected boolean isBound(Value var) {
        return this._boundVars != null && this._boundVars.contains(var);
    }

    protected void bind(Value var) {
        if (this._boundVars == null) {
            this._boundVars = new HashSet<Value>();
        }
        this._boundVars.add(var);
    }

    protected Value getVariable(String id, boolean bind) {
        if (this.isSeenVariable(id)) {
            return this.getVariable(id);
        }
        return this.createVariable(id, bind);
    }

    protected Value createVariable(String id, boolean bind) {
        Class<Object> type = this.getDeclaredVariableType(id);
        ClassMetaData meta = null;
        if (type == null) {
            type = TYPE_OBJECT;
        } else {
            meta = this.getMetaData(type, false);
        }
        if (meta != null) {
            this.addAccessPath(meta);
            this.addSchemaToContext(id, meta);
        }
        Value var = null;
        var = bind ? this.factory.newBoundVariable(id, type) : this.factory.newUnboundVariable(id, type);
        var.setMetaData(meta);
        if (this._seenVars == null) {
            this._seenVars = new HashMap<String, Value>();
        }
        this._seenVars.put(id, var);
        this.addVariableToContext(id, var);
        return var;
    }

    protected void assertUnboundVariablesValid() {
        if (this._seenVars == null) {
            return;
        }
        for (Map.Entry<String, Value> entry : this._seenVars.entrySet()) {
            Value var = entry.getValue();
            if (var.getMetaData() != null || this.isBound(var) || this.isDeclaredVariable(entry.getKey())) continue;
            throw this.parseException(0, "not-unbound-var", new Object[]{entry.getKey()}, null);
        }
    }

    protected abstract boolean isDeclaredVariable(String var1);

    protected boolean isSeenVariable(String id) {
        return this._seenVars != null && this._seenVars.containsKey(id);
    }

    protected ClassMetaData getMetaData(Class<?> c, boolean required) {
        return this.getMetaData(c, required, this.getClassLoader());
    }

    protected ClassMetaData getMetaData(Class<?> c, boolean required, ClassLoader loader) {
        return this.resolver.getConfiguration().getMetaDataRepositoryInstance().getMetaData(c, loader, required);
    }

    protected Value traversePath(Path path, String field) {
        return this.traversePath(path, field, false, false);
    }

    protected Value traverseXPath(Path path, String field) {
        XMLMetaData meta = path.getXmlMapping();
        if (meta.getFieldMapping(field) == null) {
            throw this.parseException(0, "no-field", new Object[]{meta.getType(), field}, null);
        }
        int type = meta.getFieldMapping(field).getTypeCode();
        switch (type) {
            case 11: 
            case 12: 
            case 13: {
                throw new UserException(_loc.get("collection-valued-path", field));
            }
        }
        path.get(meta, field);
        return path;
    }

    protected Value traversePath(Path path, String field, boolean pcOnly, boolean allowNull) {
        ClassMetaData meta = path.getMetaData();
        if (meta == null) {
            throw this.parseException(0, "path-no-meta", new Object[]{field, path.getType()}, null);
        }
        FieldMetaData fmd = meta.getField(field);
        if (fmd == null) {
            Object val = this.traverseStaticField(meta.getDescribedType(), field);
            if (val == null) {
                if (this.isMultiValuedTraversalAttempt(path, field)) {
                    throw this.parseException(0, "multi-valued-travesal", new Object[]{field, path.last()}, null);
                }
                Object[] all = meta.getFieldNames();
                Class<?> cls = meta.getDescribedType();
                throw this.parseException(0, "no-field", new Object[]{field, cls.getSimpleName(), StringDistance.getClosestLevenshteinDistance(field, (String[])all), cls.getName(), Arrays.toString(all)}, null);
            }
            return this.factory.newLiteral(val, 0);
        }
        meta = fmd.isEmbedded() ? fmd.getEmbeddedMetaData() : fmd.getDeclaredTypeMetaData();
        if (meta != null) {
            this.addAccessPath(meta);
            path.setMetaData(meta);
        } else {
            XMLMetaData xmlmeta = fmd.getRepository().getXMLMetaData(fmd.getDeclaredType());
            if (xmlmeta != null) {
                path.get(fmd, xmlmeta);
                return path;
            }
        }
        if (meta != null || !pcOnly) {
            path.get(fmd, allowNull);
        }
        return path;
    }

    protected Object traverseStaticField(Class<?> cls, String field) {
        try {
            return cls.getField(field).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isMultiValuedTraversalAttempt(Path path, String field) {
        if (path == null) {
            return false;
        }
        if (path.last() == null) {
            return false;
        }
        if (path.last().getElement() == null) {
            return false;
        }
        if (path.last().getElement().getDeclaredTypeMetaData() == null) {
            return false;
        }
        return path.last().getElement().getDeclaredTypeMetaData().getField(field) != null;
    }

    protected abstract Class<?> getDeclaredVariableType(String var1);

    protected void setImplicitTypes(Value val1, Value val2, Class<?> expected) {
        AbstractExpressionBuilder.setImplicitTypes(val1, val2, expected, this.resolver);
    }

    protected static void setImplicitTypes(Value val1, Value val2, Class<?> expected, Resolver resolver) {
        boolean o2;
        Class c1 = val1.getType();
        Class c2 = val2.getType();
        boolean o1 = c1 == TYPE_OBJECT;
        boolean bl = o2 = c2 == TYPE_OBJECT;
        if (o1 && !o2) {
            val1.setImplicitType(c2);
            if (val1.getMetaData() == null && !val1.isXPath()) {
                val1.setMetaData(val2.getMetaData());
            }
        } else if (!o1 && o2) {
            val2.setImplicitType(c1);
            if (val2.getMetaData() == null && !val1.isXPath()) {
                val2.setMetaData(val1.getMetaData());
            }
        } else if (o1 && o2 && expected != null) {
            val1.setImplicitType(expected);
            val2.setImplicitType(expected);
        } else if (AbstractExpressionBuilder.isNumeric(val1.getType()) != AbstractExpressionBuilder.isNumeric(val2.getType())) {
            if (resolver.getConfiguration().getCompatibilityInstance().getQuotedNumbersInQueries()) {
                AbstractExpressionBuilder.convertTypesQuotedNumbers(val1, val2);
            } else {
                AbstractExpressionBuilder.convertTypes(val1, val2);
            }
        }
    }

    public static void convertTypes(Value val1, Value val2) {
        Class t1 = val1.getType();
        Class t2 = val2.getType();
        if (t1 == TYPE_STRING && Filters.wrap(t2) == TYPE_CHAR_OBJ && !(val2 instanceof Path)) {
            val2.setImplicitType(String.class);
            return;
        }
        if (t2 == TYPE_STRING && Filters.wrap(t1) == TYPE_CHAR_OBJ && !(val1 instanceof Path)) {
            val1.setImplicitType(String.class);
            return;
        }
        if (t1 == TYPE_STRING && val1 instanceof Literal && ((String)((Literal)val1).getValue()).length() == 1) {
            val1.setImplicitType(Character.class);
            return;
        }
        if (t2 == TYPE_STRING && val2 instanceof Literal && ((String)((Literal)val2).getValue()).length() == 1) {
            val2.setImplicitType(Character.class);
            return;
        }
        String left = val1 instanceof Path && ((Path)val1).last() != null ? _loc.get("non-numeric-path", ((Path)val1).last().getName(), t1.getName()).getMessage() : _loc.get("non-numeric-value", t1.getName()).getMessage();
        String right = val2 instanceof Path && ((Path)val2).last() != null ? _loc.get("non-numeric-path", ((Path)val2).last().getName(), t2.getName()).getMessage() : _loc.get("non-numeric-value", t2.getName()).getMessage();
        throw new UserException(_loc.get("non-numeric-comparison", left, right));
    }

    public static void convertTypesQuotedNumbers(Value val1, Value val2) {
        String s;
        Class t1 = val1.getType();
        Class t2 = val2.getType();
        if (t1 == TYPE_STRING && val1 instanceof Literal && ((Literal)val1).getParseType() == 4 && (s = (String)((Literal)val1).getValue()).length() > 1) {
            ((Literal)val1).setValue(s.substring(0, 1));
            val1.setImplicitType(Character.TYPE);
        }
        if (t2 == TYPE_STRING && val2 instanceof Literal && ((Literal)val2).getParseType() == 4 && (s = (String)((Literal)val2).getValue()).length() > 1) {
            ((Literal)val2).setValue(s.substring(0, 1));
            val2.setImplicitType(Character.TYPE);
        }
        if (t1 == TYPE_STRING && val1 instanceof Literal && ((Literal)val1).getParseType() == 3) {
            s = (String)((Literal)val1).getValue();
            ((Literal)val1).setValue(Strings.parse(s, Filters.wrap(t2)));
            val1.setImplicitType(t2);
        }
        if (t2 == TYPE_STRING && val2 instanceof Literal && ((Literal)val2).getParseType() == 3) {
            s = (String)((Literal)val2).getValue();
            ((Literal)val2).setValue(Strings.parse(s, Filters.wrap(t1)));
            val2.setImplicitType(t1);
        }
    }

    public static boolean isNumeric(Class<?> type) {
        return Number.class.isAssignableFrom(type = Filters.wrap(type)) || type == Character.TYPE || type == TYPE_CHAR_OBJ;
    }

    protected void setImplicitContainsTypes(Value val1, Value val2, int op) {
        FieldMetaData fmd;
        if (val1.getType() == TYPE_OBJECT) {
            if (op == 1) {
                val1.setImplicitType(Collection.class);
            } else {
                val1.setImplicitType(Map.class);
            }
        }
        if (val2.getType() == TYPE_OBJECT && val1 instanceof Path && (fmd = ((Path)val1).last()) != null) {
            if (op == 1 || op == 3) {
                val2.setImplicitType(fmd.getElement().getDeclaredType());
                ClassMetaData meta = fmd.getElement().getDeclaredTypeMetaData();
                if (meta != null) {
                    val2.setMetaData(meta);
                    this.addAccessPath(meta);
                }
            } else {
                val2.setImplicitType(fmd.getKey().getDeclaredType());
                ClassMetaData meta = fmd.getKey().getDeclaredTypeMetaData();
                if (meta != null) {
                    val2.setMetaData(meta);
                    this.addAccessPath(meta);
                }
            }
        }
    }

    protected static void setImplicitType(Value val, Class<?> expected) {
        if (val.getType() == TYPE_OBJECT) {
            val.setImplicitType(expected);
        }
    }

    protected abstract Localizer getLocalizer();

    protected abstract String currentQuery();

    protected abstract void addSchemaToContext(String var1, ClassMetaData var2);

    protected abstract void addVariableToContext(String var1, Value var2);

    protected abstract Value getVariable(String var1);
}

