/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotatedCallable;
import org.apache.webbeans.util.GenericsUtil;

public class AnnotatedConstructorImpl<X>
extends AbstractAnnotatedCallable<X>
implements AnnotatedConstructor<X> {
    public AnnotatedConstructorImpl(WebBeansContext webBeansContext, Constructor<X> javaMember, AnnotatedType<X> declaringType) {
        super(webBeansContext, javaMember.getDeclaringClass(), javaMember, declaringType);
        this.setAnnotations(AnnotatedConstructorImpl.findAnnotations(javaMember));
        this.setAnnotatedParameters(GenericsUtil.resolveParameterTypes(declaringType.getJavaClass(), javaMember), javaMember.getParameterAnnotations());
    }

    private static Annotation[] findAnnotations(Constructor<?> javaMember) {
        if (javaMember.getParameterTypes().length == 0) {
            Class<?> clazz = javaMember.getDeclaringClass();
            HashMap<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation a : javaMember.getDeclaredAnnotations()) {
                annotations.put(a.annotationType(), a);
            }
            for (Class<?> current = clazz.getSuperclass(); current != null && current != Object.class; current = current.getSuperclass()) {
                Constructor<?> parentCons;
                try {
                    parentCons = current.getConstructor(new Class[0]);
                }
                catch (Throwable e) {
                    break;
                }
                for (Annotation a : parentCons.getAnnotations()) {
                    Class<? extends Annotation> annotationType = a.annotationType();
                    if (annotations.containsKey(annotationType) || annotationType.getAnnotation(Inherited.class) == null) continue;
                    annotations.put(annotationType, a);
                }
            }
            return annotations.values().toArray(new Annotation[annotations.size()]);
        }
        return javaMember.getDeclaredAnnotations();
    }

    @Override
    public Constructor<X> getJavaMember() {
        return (Constructor)Constructor.class.cast(this.javaMember);
    }

    @Override
    public String toString() {
        return "Annotated Constructor," + super.toString();
    }
}

