/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import apache.rocketmq.v2.Digest;
import apache.rocketmq.v2.DigestType;
import apache.rocketmq.v2.Encoding;
import apache.rocketmq.v2.Message;
import apache.rocketmq.v2.SystemProperties;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.rocketmq.client.apis.message.MessageId;
import org.apache.rocketmq.client.apis.message.MessageView;
import org.apache.rocketmq.client.java.message.MessageCommon;
import org.apache.rocketmq.client.java.message.MessageIdCodec;
import org.apache.rocketmq.client.java.misc.LinkedElement;
import org.apache.rocketmq.client.java.misc.LinkedIterator;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageViewImpl
implements LinkedElement<MessageViewImpl>,
MessageView {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageViewImpl.class);
    private final MessageId messageId;
    private final String topic;
    private final byte[] body;
    private final String tag;
    private final String messageGroup;
    private final Long deliveryTimestamp;
    private final Collection<String> keys;
    private final Map<String, String> properties;
    private final String bornHost;
    private final long bornTimestamp;
    private int deliveryAttempt;
    private final MessageQueueImpl messageQueue;
    private final Endpoints endpoints;
    private volatile String receiptHandle;
    private final String traceContext;
    private final long offset;
    private final boolean corrupted;
    private final Stopwatch decodeStopwatch;
    private final Timestamp deliveryTimestampFromRemote;
    private MessageViewImpl next;

    public MessageViewImpl(MessageId messageId, String topic, byte[] body, String tag, String messageGroup, Long deliveryTimestamp, Collection<String> keys, Map<String, String> properties, String bornHost, long bornTimestamp, int deliveryAttempt, MessageQueueImpl messageQueue, String receiptHandle, String traceContext, long offset, boolean corrupted, Timestamp deliveryTimestampFromRemote) {
        this.messageId = (MessageId)Preconditions.checkNotNull((Object)messageId, (Object)"messageId should not be null");
        this.topic = (String)Preconditions.checkNotNull((Object)topic, (Object)"topic should not be null");
        this.body = (byte[])Preconditions.checkNotNull((Object)body, (Object)"body should not be null");
        this.tag = tag;
        this.messageGroup = messageGroup;
        this.deliveryTimestamp = deliveryTimestamp;
        this.keys = (Collection)Preconditions.checkNotNull(keys, (Object)"keys should not be null");
        this.properties = (Map)Preconditions.checkNotNull(properties, (Object)"properties should not be null");
        this.bornHost = (String)Preconditions.checkNotNull((Object)bornHost, (Object)"bornHost should not be null");
        this.bornTimestamp = bornTimestamp;
        this.deliveryAttempt = deliveryAttempt;
        this.messageQueue = messageQueue;
        this.endpoints = null == messageQueue ? null : messageQueue.getBroker().getEndpoints();
        this.receiptHandle = (String)Preconditions.checkNotNull((Object)receiptHandle, (Object)"receiptHandle should not be null");
        this.traceContext = traceContext;
        this.offset = offset;
        this.corrupted = corrupted;
        this.decodeStopwatch = Stopwatch.createStarted();
        this.deliveryTimestampFromRemote = deliveryTimestampFromRemote;
        this.next = null;
    }

    public MessageCommon getMessageCommon() {
        return new MessageCommon(this.messageId, this.topic, this.body, this.tag, this.messageGroup, this.deliveryTimestamp, this.keys, this.properties, this.bornHost, this.traceContext, this.bornTimestamp, this.deliveryAttempt, this.decodeStopwatch, this.deliveryTimestampFromRemote);
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public String getTopic() {
        return this.topic;
    }

    public ByteBuffer getBody() {
        return ByteBuffer.wrap(this.body).asReadOnlyBuffer();
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.properties);
    }

    public Optional<String> getTag() {
        return null == this.tag ? Optional.empty() : Optional.of(this.tag);
    }

    public Collection<String> getKeys() {
        return this.keys;
    }

    public Optional<String> getMessageGroup() {
        return null == this.messageGroup ? Optional.empty() : Optional.of(this.messageGroup);
    }

    public Optional<Long> getDeliveryTimestamp() {
        return null == this.deliveryTimestamp ? Optional.empty() : Optional.of(this.deliveryTimestamp);
    }

    public String getBornHost() {
        return this.bornHost;
    }

    public long getBornTimestamp() {
        return this.bornTimestamp;
    }

    public int getDeliveryAttempt() {
        return this.deliveryAttempt;
    }

    public Optional<String> getTraceContext() {
        return null == this.traceContext ? Optional.empty() : Optional.of(this.traceContext);
    }

    public int incrementAndGetDeliveryAttempt() {
        return ++this.deliveryAttempt;
    }

    public MessageQueueImpl getMessageQueue() {
        return this.messageQueue;
    }

    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    public String getReceiptHandle() {
        return this.receiptHandle;
    }

    public void setReceiptHandle(String receiptHandle) {
        this.receiptHandle = receiptHandle;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public void setNext(MessageViewImpl messageView) {
        this.next = messageView;
    }

    @Override
    public MessageViewImpl getNext() {
        return this.next;
    }

    @Override
    public Iterator<MessageViewImpl> iterator() {
        return new LinkedIterator<MessageViewImpl>(this);
    }

    public static MessageViewImpl fromProtobuf(Message message) {
        return MessageViewImpl.fromProtobuf(message, null);
    }

    public static MessageViewImpl fromProtobuf(Message message, MessageQueueImpl mq) {
        return MessageViewImpl.fromProtobuf(message, mq, null);
    }

    public static MessageViewImpl fromProtobuf(Message message, MessageQueueImpl mq, Timestamp deliveryTimestampFromRemote) {
        SystemProperties systemProperties = message.getSystemProperties();
        String topic = message.getTopic().getName();
        MessageId messageId = MessageIdCodec.getInstance().decode(systemProperties.getMessageId());
        Digest bodyDigest = systemProperties.getBodyDigest();
        byte[] body = message.getBody().toByteArray();
        boolean corrupted = false;
        String checksum = bodyDigest.getChecksum();
        DigestType digestType = bodyDigest.getType();
        switch (digestType) {
            case CRC32: {
                String expectedChecksum = Utilities.crc32CheckSum(body);
                if (expectedChecksum.equals(checksum)) break;
                corrupted = true;
                break;
            }
            case MD5: {
                try {
                    String expectedChecksum = Utilities.md5CheckSum(body);
                    if (expectedChecksum.equals(checksum)) break;
                    corrupted = true;
                }
                catch (NoSuchAlgorithmException e) {
                    corrupted = true;
                    LOGGER.error("MD5 is not supported unexpectedly, skip it, topic={}, messageId={}", (Object)topic, (Object)messageId);
                }
                break;
            }
            case SHA1: {
                try {
                    String expectedChecksum = Utilities.sha1CheckSum(body);
                    if (expectedChecksum.equals(checksum)) break;
                    corrupted = true;
                }
                catch (NoSuchAlgorithmException e) {
                    corrupted = true;
                    LOGGER.error("SHA-1 is not supported unexpectedly, skip it, topic={}, messageId={}", (Object)topic, (Object)messageId);
                }
                break;
            }
            default: {
                LOGGER.error("Unsupported message body digest algorithm, digestType={}, topic={}, messageId={}", new Object[]{digestType, topic, messageId});
            }
        }
        Encoding bodyEncoding = systemProperties.getBodyEncoding();
        switch (bodyEncoding) {
            case GZIP: {
                try {
                    body = Utilities.uncompressBytesGzip(body);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to uncompress message body, topic={}, messageId={}", (Object)topic, (Object)messageId);
                    corrupted = true;
                }
                break;
            }
            case IDENTITY: {
                break;
            }
            default: {
                LOGGER.error("Unsupported message encoding algorithm, topic={}, messageId={}, bodyEncoding={}", new Object[]{topic, messageId, bodyEncoding});
            }
        }
        String tag = systemProperties.hasTag() ? systemProperties.getTag() : null;
        String messageGroup = systemProperties.hasMessageGroup() ? systemProperties.getMessageGroup() : null;
        Long deliveryTimestamp = systemProperties.hasDeliveryTimestamp() ? Long.valueOf(Timestamps.toMillis((Timestamp)systemProperties.getDeliveryTimestamp())) : null;
        ProtocolStringList keys = systemProperties.getKeysList();
        String bornHost = systemProperties.getBornHost();
        long bornTimestamp = Timestamps.toMillis((Timestamp)systemProperties.getBornTimestamp());
        int deliveryAttempt = systemProperties.getDeliveryAttempt();
        long offset = systemProperties.getQueueOffset();
        Map properties = message.getUserPropertiesMap();
        String receiptHandle = systemProperties.getReceiptHandle();
        String traceContext = systemProperties.hasTraceContext() ? systemProperties.getTraceContext() : null;
        return new MessageViewImpl(messageId, topic, body, tag, messageGroup, deliveryTimestamp, (Collection<String>)keys, properties, bornHost, bornTimestamp, deliveryAttempt, mq, receiptHandle, traceContext, offset, corrupted, deliveryTimestampFromRemote);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageId", (Object)this.messageId).add("topic", (Object)this.topic).add("bornHost", (Object)this.bornHost).add("bornTimestamp", this.bornTimestamp).add("endpoints", (Object)this.endpoints).add("deliveryAttempt", this.deliveryAttempt).add("tag", (Object)this.tag).add("keys", this.keys).add("messageGroup", (Object)this.messageGroup).add("deliveryTimestamp", (Object)this.deliveryTimestamp).add("properties", this.properties).toString();
    }
}

