/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.impl;

import apache.rocketmq.v2.Code;
import apache.rocketmq.v2.HeartbeatRequest;
import apache.rocketmq.v2.HeartbeatResponse;
import apache.rocketmq.v2.MessageQueue;
import apache.rocketmq.v2.NotifyClientTerminationRequest;
import apache.rocketmq.v2.PrintThreadStackTraceCommand;
import apache.rocketmq.v2.QueryRouteRequest;
import apache.rocketmq.v2.QueryRouteResponse;
import apache.rocketmq.v2.RecoverOrphanedTransactionCommand;
import apache.rocketmq.v2.Resource;
import apache.rocketmq.v2.Status;
import apache.rocketmq.v2.TelemetryCommand;
import apache.rocketmq.v2.ThreadStackTrace;
import apache.rocketmq.v2.VerifyMessageCommand;
import apache.rocketmq.v2.VerifyMessageResult;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.ClientConfiguration;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.java.exception.InternalErrorException;
import org.apache.rocketmq.client.java.exception.StatusChecker;
import org.apache.rocketmq.client.java.hook.CompositedMessageInterceptor;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContext;
import org.apache.rocketmq.client.java.impl.Client;
import org.apache.rocketmq.client.java.impl.ClientManager;
import org.apache.rocketmq.client.java.impl.ClientManagerImpl;
import org.apache.rocketmq.client.java.impl.ClientSessionImpl;
import org.apache.rocketmq.client.java.impl.Settings;
import org.apache.rocketmq.client.java.impl.producer.ClientSessionHandler;
import org.apache.rocketmq.client.java.message.GeneralMessage;
import org.apache.rocketmq.client.java.metrics.ClientMeterManager;
import org.apache.rocketmq.client.java.metrics.MessageMeterInterceptor;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.misc.ExecutorServices;
import org.apache.rocketmq.client.java.misc.ThreadFactoryImpl;
import org.apache.rocketmq.client.java.misc.Utilities;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.TopicRouteData;
import org.apache.rocketmq.client.java.rpc.RpcFuture;
import org.apache.rocketmq.client.java.rpc.Signature;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.com.google.common.collect.Sets;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.AbstractIdleService;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.rocketmq.shaded.com.google.errorprone.annotations.concurrent.GuardedBy;
import org.apache.rocketmq.shaded.io.grpc.Metadata;
import org.apache.rocketmq.shaded.io.grpc.stub.StreamObserver;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public abstract class ClientImpl
extends AbstractIdleService
implements Client,
ClientSessionHandler,
MessageInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClientImpl.class);
    private static final Duration TELEMETRY_TIMEOUT = Duration.ofDays(21900L);
    protected final ClientConfiguration clientConfiguration;
    protected final Endpoints endpoints;
    protected final Set<String> topics;
    protected final Set<Endpoints> isolated;
    protected final ExecutorService clientCallbackExecutor;
    protected final ClientMeterManager clientMeterManager;
    protected final ThreadPoolExecutor telemetryCommandExecutor;
    protected final ClientId clientId;
    private final ClientManager clientManager;
    private volatile ScheduledFuture<?> updateRouteCacheFuture;
    private final ConcurrentMap<String, TopicRouteData> topicRouteCache;
    @GuardedBy(value="inflightRouteFutureLock")
    private final Map<String, Set<SettableFuture<TopicRouteData>>> inflightRouteFutureTable;
    private final Lock inflightRouteFutureLock;
    @GuardedBy(value="sessionsLock")
    private final Map<Endpoints, ClientSessionImpl> sessionsTable;
    private final ReadWriteLock sessionsLock;
    private final CompositedMessageInterceptor compositedMessageInterceptor;

    public ClientImpl(ClientConfiguration clientConfiguration, Set<String> topics) {
        this.clientConfiguration = Preconditions.checkNotNull(clientConfiguration, "clientConfiguration should not be null");
        this.endpoints = new Endpoints(clientConfiguration.getEndpoints());
        this.topics = topics;
        this.clientId = new ClientId();
        this.topicRouteCache = new ConcurrentHashMap<String, TopicRouteData>();
        this.inflightRouteFutureTable = new ConcurrentHashMap<String, Set<SettableFuture<TopicRouteData>>>();
        this.inflightRouteFutureLock = new ReentrantLock();
        this.sessionsTable = new HashMap<Endpoints, ClientSessionImpl>();
        this.sessionsLock = new ReentrantReadWriteLock();
        this.isolated = Collections.newSetFromMap(new ConcurrentHashMap());
        this.clientManager = new ClientManagerImpl(this);
        long clientIdIndex = this.clientId.getIndex();
        this.clientCallbackExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("ClientCallbackWorker", clientIdIndex));
        this.clientMeterManager = new ClientMeterManager(this.clientId, clientConfiguration);
        this.compositedMessageInterceptor = new CompositedMessageInterceptor(Collections.singletonList(new MessageMeterInterceptor(this, this.clientMeterManager)));
        this.telemetryCommandExecutor = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryImpl("CommandExecutor", clientIdIndex));
    }

    @Override
    protected void startUp() throws Exception {
        log.info("Begin to start the rocketmq client, clientId={}", (Object)this.clientId);
        this.clientManager.startAsync().awaitRunning();
        log.info("Begin to fetch topic(s) route data from remote during client startup, clientId={}, topics={}", (Object)this.clientId, (Object)this.topics);
        for (String topic : this.topics) {
            ListenableFuture<TopicRouteData> future = this.fetchTopicRoute(topic);
            future.get();
        }
        log.info("Fetch topic route data from remote successfully during startup, clientId={}, topics={}", (Object)this.clientId, (Object)this.topics);
        ScheduledExecutorService scheduler = this.clientManager.getScheduler();
        this.updateRouteCacheFuture = scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.updateRouteCache();
            }
            catch (Throwable t) {
                log.error("Exception raised while updating topic route cache, clientId={}", (Object)this.clientId, (Object)t);
            }
        }, 10L, 30L, TimeUnit.SECONDS);
        log.info("The rocketmq client starts successfully, clientId={}", (Object)this.clientId);
    }

    @Override
    protected void shutDown() throws InterruptedException {
        log.info("Begin to shutdown the rocketmq client, clientId={}", (Object)this.clientId);
        this.notifyClientTermination();
        if (null != this.updateRouteCacheFuture) {
            this.updateRouteCacheFuture.cancel(false);
        }
        this.telemetryCommandExecutor.shutdown();
        if (!ExecutorServices.awaitTerminated(this.telemetryCommandExecutor)) {
            log.error("[Bug] Timeout to shutdown the telemetry command executor, clientId={}", (Object)this.clientId);
        } else {
            log.info("Shutdown the telemetry command executor successfully, clientId={}", (Object)this.clientId);
        }
        log.info("Begin to release all telemetry sessions, clientId={}", (Object)this.clientId);
        this.releaseClientSessions();
        log.info("Release all telemetry sessions successfully, clientId={}", (Object)this.clientId);
        this.clientManager.stopAsync().awaitTerminated();
        this.clientCallbackExecutor.shutdown();
        if (!ExecutorServices.awaitTerminated(this.clientCallbackExecutor)) {
            log.error("[Bug] Timeout to shutdown the client callback executor, clientId={}", (Object)this.clientId);
        }
        this.clientMeterManager.shutdown();
        log.info("Shutdown the rocketmq client successfully, clientId={}", (Object)this.clientId);
    }

    @Override
    public void doBefore(MessageInterceptorContext context, List<GeneralMessage> generalMessages) {
        try {
            this.compositedMessageInterceptor.doBefore(context, generalMessages);
        }
        catch (Throwable t) {
            log.error("[Bug] Exception raised while handling messages, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    @Override
    public void doAfter(MessageInterceptorContext context, List<GeneralMessage> generalMessages) {
        try {
            this.compositedMessageInterceptor.doAfter(context, generalMessages);
        }
        catch (Throwable t) {
            log.error("[Bug] Exception raised while handling messages, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    @Override
    public TelemetryCommand settingsCommand() {
        apache.rocketmq.v2.Settings settings = this.getSettings().toProtobuf();
        return TelemetryCommand.newBuilder().setSettings(settings).build();
    }

    @Override
    public StreamObserver<TelemetryCommand> telemetry(Endpoints endpoints, StreamObserver<TelemetryCommand> observer) throws ClientException {
        try {
            return this.clientManager.telemetry(endpoints, TELEMETRY_TIMEOUT, observer);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InternalErrorException(t);
        }
    }

    @Override
    public boolean isEndpointsDeprecated(Endpoints endpoints) {
        Set<Endpoints> totalRouteEndpoints = this.getTotalRouteEndpoints();
        return !totalRouteEndpoints.contains(endpoints);
    }

    @Override
    public void onPrintThreadStackTraceCommand(Endpoints endpoints, PrintThreadStackTraceCommand command) {
        String nonce = command.getNonce();
        Runnable task = () -> {
            try {
                String stackTrace = Utilities.stackTrace();
                Status status = Status.newBuilder().setCode(Code.OK).build();
                ThreadStackTrace threadStackTrace = ThreadStackTrace.newBuilder().setThreadStackTrace(stackTrace).setNonce(command.getNonce()).build();
                TelemetryCommand telemetryCommand = TelemetryCommand.newBuilder().setThreadStackTrace(threadStackTrace).setStatus(status).build();
                this.telemetry(endpoints, telemetryCommand);
            }
            catch (Throwable t) {
                log.error("Failed to send thread stack trace to remote, endpoints={}, nonce={}, clientId={}", endpoints, nonce, this.clientId, t);
            }
        };
        try {
            this.telemetryCommandExecutor.submit(task);
        }
        catch (Throwable t) {
            log.error("[Bug] Exception raised while submitting task to print thread stack trace, endpoints={}, nonce={}, clientId={}", endpoints, nonce, this.clientId, t);
        }
    }

    public abstract Settings getSettings();

    @Override
    public final void onSettingsCommand(Endpoints endpoints, apache.rocketmq.v2.Settings settings) {
        Metric metric = new Metric(settings.getMetric());
        this.clientMeterManager.reset(metric);
        this.getSettings().sync(settings);
    }

    @Override
    public void syncSettings() {
        apache.rocketmq.v2.Settings settings = this.getSettings().toProtobuf();
        TelemetryCommand command = TelemetryCommand.newBuilder().setSettings(settings).build();
        Set<Endpoints> totalRouteEndpoints = this.getTotalRouteEndpoints();
        for (Endpoints endpoints : totalRouteEndpoints) {
            try {
                this.telemetry(endpoints, command);
            }
            catch (Throwable t) {
                log.error("Failed to telemeter settings, clientId={}, endpoints={}", this.clientId, endpoints, t);
            }
        }
    }

    public void telemetry(Endpoints endpoints, TelemetryCommand command) {
        try {
            ClientSessionImpl clientSession = this.getClientSession(endpoints);
            clientSession.write(command);
        }
        catch (Throwable t) {
            log.error("Failed to fire write telemetry command, clientId={}, endpoints={}", this.clientId, endpoints, t);
        }
    }

    private void releaseClientSessions() {
        this.sessionsLock.readLock().lock();
        try {
            this.sessionsTable.values().forEach(ClientSessionImpl::release);
        }
        finally {
            this.sessionsLock.readLock().unlock();
        }
    }

    @Override
    public void removeClientSession(Endpoints endpoints, ClientSessionImpl clientSession) {
        this.sessionsLock.writeLock().lock();
        try {
            log.info("Remove client session, clientId={}, endpoints={}", (Object)this.clientId, (Object)endpoints);
            this.sessionsTable.remove(endpoints, clientSession);
        }
        finally {
            this.sessionsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSessionImpl getClientSession(Endpoints endpoints) throws ClientException {
        ClientSessionImpl session;
        this.sessionsLock.readLock().lock();
        try {
            session = this.sessionsTable.get(endpoints);
            if (null != session) {
                ClientSessionImpl clientSessionImpl = session;
                return clientSessionImpl;
            }
        }
        finally {
            this.sessionsLock.readLock().unlock();
        }
        this.sessionsLock.writeLock().lock();
        try {
            session = this.sessionsTable.get(endpoints);
            if (null != session) {
                ClientSessionImpl clientSessionImpl = session;
                return clientSessionImpl;
            }
            session = new ClientSessionImpl(this, this.clientConfiguration.getRequestTimeout(), endpoints);
            this.sessionsTable.put(endpoints, session);
            ClientSessionImpl clientSessionImpl = session;
            return clientSessionImpl;
        }
        finally {
            this.sessionsLock.writeLock().unlock();
        }
    }

    public ListenableFuture<TopicRouteData> onTopicRouteDataFetched(String topic, TopicRouteData topicRouteData) throws ClientException {
        Set routeEndpoints = topicRouteData.getMessageQueues().stream().map(mq -> mq.getBroker().getEndpoints()).collect(Collectors.toSet());
        Set<Endpoints> existRouteEndpoints = this.getTotalRouteEndpoints();
        HashSet newEndpoints = new HashSet(Sets.difference(routeEndpoints, existRouteEndpoints));
        ArrayList<ListenableFuture<apache.rocketmq.v2.Settings>> futures = new ArrayList<ListenableFuture<apache.rocketmq.v2.Settings>>();
        for (Endpoints endpoints : newEndpoints) {
            ClientSessionImpl clientSession = this.getClientSession(endpoints);
            futures.add(clientSession.syncSettings());
        }
        ListenableFuture future = Futures.allAsList(futures);
        return Futures.transform(future, input -> {
            this.topicRouteCache.put(topic, topicRouteData);
            this.onTopicRouteDataUpdate0(topic, topicRouteData);
            return topicRouteData;
        }, MoreExecutors.directExecutor());
    }

    public void onTopicRouteDataUpdate0(String topic, TopicRouteData topicRouteData) {
    }

    @Override
    public void onVerifyMessageCommand(Endpoints endpoints, VerifyMessageCommand command) {
        log.warn("Ignore verify message command from remote, which is not expected, clientId={}, command={}", (Object)this.clientId, (Object)command);
        String nonce = command.getNonce();
        Status status = Status.newBuilder().setCode(Code.NOT_IMPLEMENTED).build();
        VerifyMessageResult verifyMessageResult = VerifyMessageResult.newBuilder().setNonce(nonce).build();
        TelemetryCommand telemetryCommand = TelemetryCommand.newBuilder().setVerifyMessageResult(verifyMessageResult).setStatus(status).build();
        try {
            this.telemetry(endpoints, telemetryCommand);
        }
        catch (Throwable t) {
            log.warn("Failed to send message verification result, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    @Override
    public void onRecoverOrphanedTransactionCommand(Endpoints endpoints, RecoverOrphanedTransactionCommand command) {
        log.warn("Ignore orphaned transaction recovery command from remote, which is not expected, clientId={}, command={}", (Object)this.clientId, (Object)command);
    }

    private void updateRouteCache() {
        log.info("Start to update route cache for a new round, clientId={}", (Object)this.clientId);
        this.topicRouteCache.keySet().forEach(topic -> {
            ListenableFuture<TopicRouteData> future = this.fetchTopicRoute((String)topic);
            Futures.addCallback(future, new FutureCallback<TopicRouteData>(){

                @Override
                public void onSuccess(TopicRouteData topicRouteData) {
                }

                @Override
                public void onFailure(Throwable t) {
                    log.error("Failed to fetch topic route for update cache, topic={}, clientId={}", topic, ClientImpl.this.clientId, t);
                }
            }, MoreExecutors.directExecutor());
        });
    }

    public abstract NotifyClientTerminationRequest wrapNotifyClientTerminationRequest();

    private void notifyClientTermination() {
        log.info("Notify remote that client is terminated, clientId={}", (Object)this.clientId);
        Set<Endpoints> routeEndpointsSet = this.getTotalRouteEndpoints();
        NotifyClientTerminationRequest notifyClientTerminationRequest = this.wrapNotifyClientTerminationRequest();
        try {
            for (Endpoints endpoints : routeEndpointsSet) {
                this.clientManager.notifyClientTermination(endpoints, notifyClientTerminationRequest, this.clientConfiguration.getRequestTimeout());
            }
        }
        catch (Throwable t) {
            log.error("[Bug] Exception raised while notifying client's termination, clientId={}", (Object)this.clientId, (Object)t);
        }
    }

    public ClientManager getClientManager() {
        return this.clientManager;
    }

    @Override
    public Endpoints getEndpoints() {
        return this.endpoints;
    }

    @Override
    public ClientId getClientId() {
        return this.clientId;
    }

    @Override
    public void doHeartbeat() {
        Set<Endpoints> totalEndpoints = this.getTotalRouteEndpoints();
        HeartbeatRequest request = this.wrapHeartbeatRequest();
        for (Endpoints endpoints : totalEndpoints) {
            this.doHeartbeat(request, endpoints);
        }
    }

    @Override
    public Metadata sign() throws NoSuchAlgorithmException, InvalidKeyException {
        return Signature.sign(this.clientConfiguration, this.clientId);
    }

    @Override
    public boolean isSslEnabled() {
        return this.clientConfiguration.isSslEnabled();
    }

    private void doHeartbeat(HeartbeatRequest request, final Endpoints endpoints) {
        try {
            RpcFuture<HeartbeatRequest, HeartbeatResponse> future = this.clientManager.heartbeat(endpoints, request, this.clientConfiguration.getRequestTimeout());
            Futures.addCallback(future, new FutureCallback<HeartbeatResponse>(){

                @Override
                public void onSuccess(HeartbeatResponse response) {
                    Status status = response.getStatus();
                    Code code = status.getCode();
                    if (Code.OK != code) {
                        log.warn("Failed to send heartbeat, code={}, status message=[{}], endpoints={}, clientId={}", code, status.getMessage(), endpoints, ClientImpl.this.clientId);
                        return;
                    }
                    log.info("Send heartbeat successfully, endpoints={}, clientId={}", (Object)endpoints, (Object)ClientImpl.this.clientId);
                    boolean removed = ClientImpl.this.isolated.remove(endpoints);
                    if (removed) {
                        log.info("Rejoin endpoints which is isolated before, clientId={}, endpoints={}", (Object)ClientImpl.this.clientId, (Object)endpoints);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    log.warn("Failed to send heartbeat, endpoints={}, clientId={}", endpoints, ClientImpl.this.clientId, t);
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Throwable t) {
            log.error("[Bug] Exception raised while preparing heartbeat, endpoints={}, clientId={}", endpoints, this.clientId, t);
        }
    }

    public abstract HeartbeatRequest wrapHeartbeatRequest();

    @Override
    public void doStats() {
    }

    private ListenableFuture<TopicRouteData> fetchTopicRoute(final String topic) {
        ListenableFuture<TopicRouteData> future0 = this.fetchTopicRoute0(topic);
        ListenableFuture<TopicRouteData> future = Futures.transformAsync(future0, topicRouteData -> this.onTopicRouteDataFetched(topic, (TopicRouteData)topicRouteData), MoreExecutors.directExecutor());
        Futures.addCallback(future, new FutureCallback<TopicRouteData>(){

            @Override
            public void onSuccess(TopicRouteData topicRouteData) {
                log.info("Fetch topic route successfully, clientId={}, topic={}, topicRouteData={}", ClientImpl.this.clientId, topic, topicRouteData);
            }

            @Override
            public void onFailure(Throwable t) {
                log.error("Failed to fetch topic route, clientId={}, topic={}", ClientImpl.this.clientId, topic, t);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    protected ListenableFuture<TopicRouteData> fetchTopicRoute0(String topic) {
        Resource topicResource = Resource.newBuilder().setName(topic).build();
        QueryRouteRequest request = QueryRouteRequest.newBuilder().setTopic(topicResource).setEndpoints(this.endpoints.toProtobuf()).build();
        RpcFuture<QueryRouteRequest, QueryRouteResponse> future = this.clientManager.queryRoute(this.endpoints, request, this.clientConfiguration.getRequestTimeout());
        return Futures.transformAsync(future, response -> {
            Status status = response.getStatus();
            StatusChecker.check(status, future);
            List<MessageQueue> messageQueuesList = response.getMessageQueuesList();
            TopicRouteData topicRouteData = new TopicRouteData(messageQueuesList);
            return Futures.immediateFuture(topicRouteData);
        }, MoreExecutors.directExecutor());
    }

    protected Set<Endpoints> getTotalRouteEndpoints() {
        HashSet<Endpoints> totalRouteEndpoints = new HashSet<Endpoints>();
        for (TopicRouteData topicRouteData : this.topicRouteCache.values()) {
            totalRouteEndpoints.addAll(topicRouteData.getTotalEndpoints());
        }
        return totalRouteEndpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenableFuture<TopicRouteData> getRouteData(final String topic) {
        SettableFuture<TopicRouteData> future0 = SettableFuture.create();
        TopicRouteData topicRouteData = (TopicRouteData)this.topicRouteCache.get(topic);
        if (null != topicRouteData) {
            future0.set(topicRouteData);
            return future0;
        }
        this.inflightRouteFutureLock.lock();
        try {
            topicRouteData = (TopicRouteData)this.topicRouteCache.get(topic);
            if (null != topicRouteData) {
                future0.set(topicRouteData);
                SettableFuture<TopicRouteData> settableFuture = future0;
                return settableFuture;
            }
            Set<SettableFuture<TopicRouteData>> inflightFutures = this.inflightRouteFutureTable.get(topic);
            if (null != inflightFutures) {
                inflightFutures.add(future0);
                SettableFuture<TopicRouteData> settableFuture = future0;
                return settableFuture;
            }
            inflightFutures = new HashSet<SettableFuture<TopicRouteData>>();
            inflightFutures.add(future0);
            this.inflightRouteFutureTable.put(topic, inflightFutures);
        }
        finally {
            this.inflightRouteFutureLock.unlock();
        }
        ListenableFuture<TopicRouteData> future = this.fetchTopicRoute(topic);
        Futures.addCallback(future, new FutureCallback<TopicRouteData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(TopicRouteData topicRouteData) {
                ClientImpl.this.inflightRouteFutureLock.lock();
                try {
                    Set newFutureSet = (Set)ClientImpl.this.inflightRouteFutureTable.remove(topic);
                    if (null == newFutureSet) {
                        log.error("[Bug] in-flight route futures was empty, topic={}, clientId={}", (Object)topic, (Object)ClientImpl.this.clientId);
                        return;
                    }
                    log.debug("Fetch topic route successfully, topic={}, in-flight route future size={}, clientId={}", topic, newFutureSet.size(), ClientImpl.this.clientId);
                    for (SettableFuture newFuture : newFutureSet) {
                        newFuture.set(topicRouteData);
                    }
                }
                catch (Throwable t) {
                    log.error("[Bug] Exception raised while update route data, topic={}, clientId={}", topic, ClientImpl.this.clientId, t);
                }
                finally {
                    ClientImpl.this.inflightRouteFutureLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable t) {
                ClientImpl.this.inflightRouteFutureLock.lock();
                try {
                    Set newFutureSet = (Set)ClientImpl.this.inflightRouteFutureTable.remove(topic);
                    if (null == newFutureSet) {
                        log.error("[Bug] in-flight route futures was empty, topic={}, clientId={}", (Object)topic, (Object)ClientImpl.this.clientId);
                        return;
                    }
                    log.debug("Failed to fetch topic route, topic={}, in-flight route future size={}, clientId={}", topic, newFutureSet.size(), ClientImpl.this.clientId, t);
                    for (SettableFuture future : newFutureSet) {
                        future.setException(t);
                    }
                }
                finally {
                    ClientImpl.this.inflightRouteFutureLock.unlock();
                }
            }
        }, MoreExecutors.directExecutor());
        return future0;
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.clientManager.getScheduler();
    }

    protected <T> T handleClientFuture(ListenableFuture<T> future) throws ClientException {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClientException) {
                throw (ClientException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new ClientException(null == cause ? e : cause);
        }
    }

    public ClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Override
    protected String serviceName() {
        return super.serviceName() + "-" + this.clientId.getIndex();
    }
}

