/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.Futures;
import org.apache.rocketmq.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.apache.rocketmq.shaded.io.grpc.ManagedChannel;
import org.apache.rocketmq.shaded.io.grpc.Status;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.ExporterMetrics;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporter;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.ManagedChannelUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc.MarshalerServiceStub;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DefaultGrpcExporter<T extends Marshaler>
implements GrpcExporter<T> {
    private static final Logger internalLogger = Logger.getLogger(DefaultGrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final String type;
    private final ExporterMetrics exporterMetrics;
    private final ManagedChannel managedChannel;
    private final MarshalerServiceStub<T, ?, ?> stub;
    private final long timeoutNanos;

    DefaultGrpcExporter(String type, ManagedChannel channel, MarshalerServiceStub<T, ?, ?> stub, MeterProvider meterProvider, long timeoutNanos) {
        this.type = type;
        this.exporterMetrics = ExporterMetrics.createGrpc(type, meterProvider);
        this.managedChannel = channel;
        this.timeoutNanos = timeoutNanos;
        this.stub = stub;
    }

    @Override
    public CompletableResultCode export(T exportRequest, final int numItems) {
        this.exporterMetrics.addSeen(numItems);
        final CompletableResultCode result = new CompletableResultCode();
        MarshalerServiceStub stub = this.stub;
        if (this.timeoutNanos > 0L) {
            stub = (MarshalerServiceStub)stub.withDeadlineAfter(this.timeoutNanos, TimeUnit.NANOSECONDS);
        }
        Futures.addCallback(stub.export(exportRequest), new FutureCallback<Object>(){

            @Override
            public void onSuccess(@Nullable Object unused) {
                DefaultGrpcExporter.this.exporterMetrics.addSuccess(numItems);
                result.succeed();
            }

            @Override
            public void onFailure(Throwable t) {
                DefaultGrpcExporter.this.exporterMetrics.addFailed(numItems);
                Status status = Status.fromThrowable(t);
                switch (status.getCode()) {
                    case UNIMPLEMENTED: {
                        if (!DefaultGrpcExporter.this.loggedUnimplemented.compareAndSet(false, true)) break;
                        GrpcExporterUtil.logUnimplemented(internalLogger, DefaultGrpcExporter.this.type, status.getDescription());
                        break;
                    }
                    case UNAVAILABLE: {
                        DefaultGrpcExporter.this.logger.log(Level.SEVERE, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + status.getDescription());
                        break;
                    }
                    default: {
                        DefaultGrpcExporter.this.logger.log(Level.WARNING, "Failed to export " + DefaultGrpcExporter.this.type + "s. Server responded with gRPC status code " + status.getCode().value() + ". Error message: " + status.getDescription());
                    }
                }
                if (DefaultGrpcExporter.this.logger.isLoggable(Level.FINEST)) {
                    DefaultGrpcExporter.this.logger.log(Level.FINEST, "Failed to export " + DefaultGrpcExporter.this.type + "s. Details follow: " + t);
                }
                result.fail();
            }
        }, MoreExecutors.directExecutor());
        return result;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.managedChannel.isTerminated()) {
            return CompletableResultCode.ofSuccess();
        }
        return ManagedChannelUtil.shutdownChannel(this.managedChannel);
    }
}

