/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view;

import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                return new LongLastValueAggregator(ExemplarReservoir::longNoSamples);
            }
            case DOUBLE: {
                return new DoubleLastValueAggregator(ExemplarReservoir::doubleNoSamples);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return instrumentDescriptor.getType() == InstrumentType.OBSERVABLE_GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

