/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.datasource.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.datasource.internal.DataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.datasource.JNDIDataSourceFactory", label="Apache Sling JNDI DataSource", description="Registers a DataSource instance with OSGi ServiceRegistry which is looked up from the JNDI", metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
public class JNDIDataSourceFactory {
    public static final String NAME = "org.apache.sling.datasource.JNDIDataSourceFactory";
    @Property
    static final String PROP_DATASOURCE_NAME = "datasource.name";
    @Property(value={"datasource.name"})
    static final String PROP_DS_SVC_PROP_NAME = "datasource.svc.prop.name";
    @Property(label="JNDI Name (*)", description="JNDI location name used to perform DataSource instance lookup")
    static final String PROP_DS_JNDI_NAME = "datasource.jndi.name";
    @Property(label="JNDI Properties", description="Set the environment for the JNDI InitialContext i.e. properties passed on to InitialContext for performing the JNDI instance lookup. Each row form a map entry where each row format be propertyName=property e.g. java.naming.factory.initial=exampleFactory", value={}, cardinality=1024)
    static final String PROP_JNDI_PROPS = "jndi.properties";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration dsRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, ?> config) throws Exception {
        String name = DataSourceFactory.getDataSourceName(config);
        String jndiName = PropertiesUtil.toString(config.get(PROP_DS_JNDI_NAME), null);
        DataSourceFactory.checkArgument(name != null, "DataSource name must be specified via [%s] property", PROP_DATASOURCE_NAME);
        DataSourceFactory.checkArgument(jndiName != null, "DataSource JNDI name must be specified via [%s] property", PROP_DS_JNDI_NAME);
        DataSource dataSource = this.lookupDataSource(jndiName, config);
        String svcPropName = DataSourceFactory.getSvcPropName(config);
        Hashtable<String, String> svcProps = new Hashtable<String, String>();
        ((Dictionary)svcProps).put(svcPropName, name);
        ((Dictionary)svcProps).put("service.vendor", "Apache Software Foundation");
        ((Dictionary)svcProps).put("service.description", "DataSource service looked up from " + jndiName);
        this.dsRegistration = bundleContext.registerService(DataSource.class, (Object)dataSource, svcProps);
        this.log.info("Registered DataSource [{}] looked up from JNDI at [{}]", (Object)name, (Object)jndiName);
    }

    @Deactivate
    protected void deactivate() {
        if (this.dsRegistration != null) {
            this.dsRegistration.unregister();
            this.dsRegistration = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource lookupDataSource(String jndiName, Map<String, ?> config) throws NamingException {
        Properties jndiProps = this.createJndiEnv(config);
        Context context = null;
        try {
            this.log.debug("Looking up DataSource [{}] with InitialContext env [{}]", (Object)jndiName, (Object)jndiProps);
            context = new InitialContext(jndiProps);
            Object lookup = context.lookup(jndiName);
            if (lookup == null) {
                throw new NameNotFoundException("JNDI object with [" + jndiName + "] not found");
            }
            if (!DataSource.class.isInstance(lookup)) {
                throw new IllegalStateException("JNDI object of type " + lookup.getClass() + "is not an instance of javax.sql.DataSource");
            }
            DataSource dataSource = (DataSource)lookup;
            return dataSource;
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    private Properties createJndiEnv(Map<String, ?> config) {
        Properties props = new Properties();
        Map<String, String> otherProps = PropertiesUtil.toMap(config.get(PROP_JNDI_PROPS), new String[0]);
        for (Map.Entry<String, String> e : otherProps.entrySet()) {
            JNDIDataSourceFactory.set(e.getKey(), e.getValue(), props);
        }
        return props;
    }

    private static void set(String name, String value, Properties props) {
        if (value != null) {
            value = value.trim();
        }
        if (value != null && !value.isEmpty()) {
            props.setProperty(name, value);
        }
    }
}

