/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.FilterChain;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ErrorHandler;
import org.apache.sling.api.servlets.JakartaErrorHandler;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletResponseWrapper;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.engine.impl.Config;
import org.apache.sling.engine.impl.ContentTypeHeaderState;
import org.apache.sling.engine.impl.DefaultErrorHandler;
import org.apache.sling.engine.impl.RequestProcessorMBeanImpl;
import org.apache.sling.engine.impl.SlingJakartaHttpServletResponseImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.debug.RequestInfoProviderImpl;
import org.apache.sling.engine.impl.filter.ErrorFilterChain;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.RequestSlingFilterChain;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.filter.SlingComponentFilterChain;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.DispatchingInfo;
import org.apache.sling.engine.impl.request.RequestData;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SlingRequestProcessor.class, SlingRequestProcessorImpl.class}, configurationPid={"org.apache.sling.engine.impl.SlingMainServlet"})
public class SlingRequestProcessorImpl
implements SlingRequestProcessor {
    private final Logger log = LoggerFactory.getLogger(SlingRequestProcessorImpl.class);
    @Reference
    private volatile ServletResolver servletResolver;
    @Reference
    private volatile ServletFilterManager filterManager;
    @Reference
    private volatile RequestProcessorMBeanImpl mbean;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile AdapterManager adapterManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile MimeTypeService mimeTypeService;
    private final DefaultErrorHandler errorHandler = new DefaultErrorHandler();
    private volatile int maxCallCounter = 1000;
    private volatile int maxInclusionCounter = 50;
    private volatile List<StaticResponseHeader> additionalResponseHeaders = Collections.emptyList();
    private volatile boolean protectHeadersOnInclude;
    private volatile boolean checkContentTypeOnInclude;
    private volatile boolean disableCheckCompliantGetUserPrincipal;
    private static final ThreadLocal<ContentTypeHeaderState> contentTypeHeaderState = ThreadLocal.withInitial(() -> ContentTypeHeaderState.UNSET);

    @Activate
    public void activate(Config config) {
        this.modified(config);
    }

    @Modified
    public void modified(Config config) {
        ArrayList<StaticResponseHeader> mappings = new ArrayList<StaticResponseHeader>();
        String[] props = config.sling_additional_response_headers();
        if (props != null) {
            for (String prop : props) {
                if (prop == null || prop.trim().length() <= 0) continue;
                try {
                    StaticResponseHeader mapping = new StaticResponseHeader(prop.trim());
                    mappings.add(mapping);
                }
                catch (IllegalArgumentException iae) {
                    this.log.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
                }
            }
        }
        this.additionalResponseHeaders = mappings;
        this.maxInclusionCounter = config.sling_max_inclusions();
        this.maxCallCounter = config.sling_max_calls();
        this.protectHeadersOnInclude = config.sling_includes_protectheaders();
        this.checkContentTypeOnInclude = config.sling_includes_checkcontenttype();
        this.disableCheckCompliantGetUserPrincipal = config.disable_spec_compliant_getuserprincipal();
    }

    @Reference(target="(name=org.apache.sling)", policy=ReferencePolicy.DYNAMIC, updated="bindServletContext")
    void bindServletContext(ServletContext servletContext) {
        this.errorHandler.setServerInfo(servletContext.getServerInfo());
    }

    void unbindServletContext(ServletContext servletContext) {
    }

    @Reference(name="JakartaErrorHandler", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void setJakartaErrorHandler(JakartaErrorHandler handler, ServiceReference<?> ref) {
        this.errorHandler.setDelegate(ref, handler);
    }

    void unsetJakartaErrorHandler(JakartaErrorHandler handler, ServiceReference<?> ref) {
        this.errorHandler.setDelegate(ref, (JakartaErrorHandler)null);
    }

    @Reference(name="ErrorHandler", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    void setErrorHandler(ErrorHandler handler, ServiceReference<?> ref) {
        this.errorHandler.setDelegate(ref, handler);
    }

    void unsetErrorHandler(ErrorHandler handler, ServiceReference<?> ref) {
        this.errorHandler.setDelegate(ref, (ErrorHandler)null);
    }

    public int getMaxCallCounter() {
        return this.maxCallCounter;
    }

    public int getMaxIncludeCounter() {
        return this.maxInclusionCounter;
    }

    public List<StaticResponseHeader> getAdditionalResponseHeaders() {
        return this.additionalResponseHeaders;
    }

    public <Type> Type adaptTo(Object object, Class<Type> type) {
        AdapterManager adapterManager = this.adapterManager;
        if (adapterManager != null) {
            return (Type)adapterManager.getAdapter(object, type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessRequest(jakarta.servlet.http.HttpServletRequest servletRequest, HttpServletResponse servletResponse, ResourceResolver resourceResolver) throws IOException {
        ServletResolver sr = this.servletResolver;
        if (resourceResolver == null || sr == null) {
            int status = 503;
            String errorMessage = "Required service missing (";
            if (resourceResolver == null) {
                errorMessage = errorMessage.concat("ResourceResolver");
                if (sr == null) {
                    errorMessage = errorMessage.concat(", ");
                }
            }
            if (sr == null) {
                errorMessage = errorMessage.concat("ServletResolver");
            }
            this.log.debug("{}, cannot service requests, sending status {}", (Object)errorMessage, (Object)503);
            servletResponse.sendError(503, errorMessage);
            return;
        }
        RequestData requestData = new RequestData(this, servletRequest, servletResponse, this.protectHeadersOnInclude, this.checkContentTypeOnInclude, this.disableCheckCompliantGetUserPrincipal);
        SlingJakartaHttpServletRequest request = requestData.getSlingRequest();
        SlingJakartaHttpServletResponse response = requestData.getSlingResponse();
        try {
            if (this.getContentTypeHeaderState() != ContentTypeHeaderState.UNSET) {
                this.log.error("Content Type Header state has not been cleared properly, is set to {}", (Object)this.getContentTypeHeaderState());
            }
            this.setContentTypeHeaderState(ContentTypeHeaderState.NOT_VIOLATED);
            Resource resource = requestData.initResource(resourceResolver);
            requestData.initServlet(resource, sr);
            FilterHandle[] filters = this.filterManager.getFilters(ServletFilterManager.FilterChainType.REQUEST);
            RequestSlingFilterChain processor = new RequestSlingFilterChain(this, filters);
            request.getRequestProgressTracker().log("Applying ".concat(ServletFilterManager.FilterChainType.REQUEST.name()).concat("filters"));
            processor.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (SlingJakartaHttpServletResponseImpl.WriterAlreadyClosedException wace) {
            this.log.error("Writer has already been closed.", (Throwable)wace);
        }
        catch (ResourceNotFoundException rnfe) {
            this.log.debug("service: Resource {} not found", (Object)rnfe.getResource());
            this.handleError(404, rnfe.getMessage(), request, response);
        }
        catch (SlingException se) {
            Throwable t = se;
            while (t instanceof SlingException && t.getCause() != null) {
                t = t.getCause();
            }
            this.handleError(requestData, "SlingException", t, request, response);
        }
        catch (AccessControlException ace) {
            this.log.debug("service: Authenticated user {} does not have enough rights to executed requested action", (Object)request.getRemoteUser());
            this.handleError(403, null, request, response);
        }
        catch (FileNotFoundException fnfe) {
            this.log.debug("service: File not found: {}", (Object)fnfe.getMessage());
            this.handleError(404, fnfe.getMessage(), request, response);
        }
        catch (IOException ioe) {
            this.handleError(requestData, "IOException", ioe, request, response);
        }
        catch (Throwable t) {
            this.handleError(requestData, "Throwable", t, request, response);
        }
        finally {
            RequestInfoProviderImpl.recordRequest(request);
            RequestProcessorMBeanImpl localBean = this.mbean;
            if (localBean != null) {
                localBean.addRequestData(requestData);
            }
            this.setContentTypeHeaderState(ContentTypeHeaderState.UNSET);
        }
    }

    private void handleError(RequestData requestData, String identifier, Throwable throwable, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        if (requestData.getActiveServletName() != null) {
            request.setAttribute("jakarta.servlet.error.servlet_name", (Object)requestData.getActiveServletName());
        }
        this.log.error("service: Uncaught {}", (Object)identifier, (Object)throwable);
        this.handleError(throwable, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(jakarta.servlet.http.HttpServletRequest servletRequest, HttpServletResponse servletResponse, ResourceResolver resourceResolver) throws IOException {
        Object oldValue = servletRequest.getAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING);
        servletRequest.setAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING, (Object)Boolean.TRUE);
        try {
            this.doProcessRequest(servletRequest, servletResponse, resourceResolver);
        }
        finally {
            if (oldValue != null) {
                servletRequest.setAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING, oldValue);
            } else {
                servletRequest.removeAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING);
            }
        }
    }

    @Override
    public void processRequest(HttpServletRequest servletRequest, javax.servlet.http.HttpServletResponse servletResponse, ResourceResolver resourceResolver) throws IOException {
        this.processRequest(JavaxToJakartaRequestWrapper.toJakartaRequest((HttpServletRequest)servletRequest), JavaxToJakartaResponseWrapper.toJakartaResponse((javax.servlet.http.HttpServletResponse)servletResponse), resourceResolver);
    }

    public void processComponent(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response, ServletFilterManager.FilterChainType filterChainType) throws IOException, ServletException {
        FilterHandle[] filters = this.filterManager.getFilters(filterChainType);
        SlingComponentFilterChain processor = new SlingComponentFilterChain(filters);
        request.getRequestProgressTracker().log("Applying " + String.valueOf((Object)filterChainType) + "filters");
        processor.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchRequest(ServletRequest request, ServletResponse response, Resource resource, RequestPathInfo resolvedURL, DispatchingInfo dispatchingInfo) throws IOException, ServletException {
        SlingJakartaHttpServletRequest cRequest = RequestData.toSlingHttpServletRequest(request);
        SlingJakartaHttpServletResponse cResponse = RequestData.toSlingHttpServletResponse(response);
        ServletResolver sr = this.servletResolver;
        if (sr == null) {
            int status = 503;
            String errorMessage = "Required service missing (ServletResolver)";
            this.log.debug("{}, cannot dispatch requests, sending status {}", (Object)errorMessage, (Object)503);
            cResponse.sendError(503, errorMessage);
            return;
        }
        RequestData requestData = RequestData.getRequestData(cRequest);
        ContentData oldContentData = requestData.getContentData();
        ContentData contentData = requestData.setContent(resource, resolvedURL);
        DispatchingInfo oldDispatchingInfo = requestData.getDispatchingInfo();
        requestData.setDispatchingInfo(dispatchingInfo);
        try {
            Servlet servlet = sr.resolve(cRequest);
            contentData.setServlet(servlet);
            ServletFilterManager.FilterChainType type = dispatchingInfo.getType() == DispatcherType.INCLUDE ? ServletFilterManager.FilterChainType.INCLUDE : ServletFilterManager.FilterChainType.FORWARD;
            this.processComponent(cRequest, cResponse, type);
        }
        finally {
            requestData.resetContent(oldContentData);
            requestData.setDispatchingInfo(oldDispatchingInfo);
        }
    }

    private void handleError(FilterChain errorFilterChain, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        request.getRequestProgressTracker().log("Applying " + String.valueOf((Object)ServletFilterManager.FilterChainType.ERROR) + " filters");
        try {
            errorFilterChain.doFilter((ServletRequest)request, (ServletResponse)new ErrorResponseWrapper(response));
        }
        catch (ServletException se) {
            throw new SlingServletException(se);
        }
    }

    void handleError(int status, String message, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        FilterHandle[] filters = this.filterManager.getFilters(ServletFilterManager.FilterChainType.ERROR);
        ErrorFilterChain processor = new ErrorFilterChain(filters, this.errorHandler, status, message);
        this.handleError(processor, request, response);
    }

    private void handleError(Throwable throwable, SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException {
        FilterHandle[] filters = this.filterManager.getFilters(ServletFilterManager.FilterChainType.ERROR);
        ErrorFilterChain processor = new ErrorFilterChain(filters, this.errorHandler, throwable);
        this.handleError(processor, request, response);
    }

    public String getMimeType(String name) {
        MimeTypeService mtservice = this.mimeTypeService;
        if (mtservice != null) {
            return mtservice.getMimeType(name);
        }
        this.log.debug("getMimeType: MimeTypeService not available, cannot resolve mime type for {}", (Object)name);
        return null;
    }

    public ContentTypeHeaderState getContentTypeHeaderState() {
        return contentTypeHeaderState.get();
    }

    public void setContentTypeHeaderState(ContentTypeHeaderState newState) {
        contentTypeHeaderState.set(newState);
    }

    private static class ErrorResponseWrapper
    extends SlingJakartaHttpServletResponseWrapper {
        private PrintWriter writer;

        public ErrorResponseWrapper(SlingJakartaHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                try {
                    this.writer = super.getWriter();
                }
                catch (IllegalStateException ise) {
                    ServletOutputStream out = this.getOutputStream();
                    String encoding = this.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                        this.setCharacterEncoding(encoding);
                    }
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, encoding);
                    this.writer = new PrintWriter(w);
                }
            }
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            super.flushBuffer();
        }
    }
}

