/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.Logger;
import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngException;
import com.googlecode.pngtastic.core.PngImageType;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PngImage {
    private final Logger log;
    public static final long SIGNATURE = -8552249625308161526L;
    private String fileName;
    private List<PngChunk> chunks = new ArrayList<PngChunk>();
    private long width;
    private long height;
    private short bitDepth;
    private short colorType;
    private short interlace;
    private PngChunk palette;
    private PngImageType imageType;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<PngChunk> getChunks() {
        return this.chunks;
    }

    public long getWidth() {
        return this.width;
    }

    public long getHeight() {
        return this.height;
    }

    public short getBitDepth() {
        return this.bitDepth;
    }

    public short getColorType() {
        return this.colorType;
    }

    public short getInterlace() {
        return this.interlace;
    }

    public void setInterlace(short interlace) {
        this.interlace = interlace;
    }

    public PngChunk getPalette() {
        return this.palette;
    }

    public PngImage() {
        this.log = new Logger("NONE");
    }

    public PngImage(Logger log) {
        this.log = log;
    }

    public PngImage(String fileName, String logLevel) throws FileNotFoundException {
        this(new BufferedInputStream(new FileInputStream(fileName)), logLevel);
        this.fileName = fileName;
    }

    public PngImage(InputStream ins) {
        this(ins, null);
    }

    public PngImage(InputStream ins, String logLevel) {
        this(new Logger(logLevel));
        try {
            PngChunk chunk;
            int length;
            DataInputStream dis = new DataInputStream(ins);
            PngImage.readSignature(dis);
            do {
                long crc;
                byte[] data;
                length = this.getChunkLength(dis);
                byte[] type = this.getChunkType(dis);
                chunk = new PngChunk(type, data = this.getChunkData(dis, length));
                if (!chunk.verifyCRC(crc = this.getChunkCrc(dis))) {
                    throw new PngException("Corrupted file, crc check failed");
                }
                this.addChunk(chunk);
            } while (length > 0 && !"IEND".equals(chunk.getTypeString()));
        }
        catch (IOException e) {
            throw new PngException("Error: " + e.getMessage(), e);
        }
    }

    public File export(String fileName, byte[] bytes) throws IOException {
        File out = new File(fileName);
        this.writeFileOutputStream(out, bytes);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileOutputStream writeFileOutputStream(File out, byte[] bytes) throws IOException {
        try (FileOutputStream outs = null;){
            outs = new FileOutputStream(out);
            outs.write(bytes);
        }
        return outs;
    }

    public DataOutputStream writeDataOutputStream(OutputStream output) throws IOException {
        DataOutputStream outs = new DataOutputStream(output);
        outs.writeLong(-8552249625308161526L);
        for (PngChunk chunk : this.chunks) {
            this.log.debug("export: %s", chunk.toString());
            outs.writeInt(chunk.getLength());
            outs.write(chunk.getType());
            outs.write(chunk.getData());
            int i = (int)chunk.getCRC();
            outs.writeInt(i);
        }
        outs.close();
        return outs;
    }

    public void addChunk(PngChunk chunk) {
        switch (chunk.getTypeString()) {
            case "IHDR": {
                this.width = chunk.getWidth();
                this.height = chunk.getHeight();
                this.bitDepth = chunk.getBitDepth();
                this.colorType = chunk.getColorType();
                this.interlace = chunk.getInterlace();
                break;
            }
            case "PLTE": {
                this.palette = chunk;
            }
        }
        this.chunks.add(chunk);
    }

    public byte[] getImageData() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (PngChunk chunk : this.chunks) {
                if (!chunk.getTypeString().equals("IDAT")) continue;
                out.write(chunk.getData());
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            System.out.println("Couldn't get image data: " + e);
            return null;
        }
    }

    public int getSampleBitCount() {
        this.imageType = this.imageType == null ? PngImageType.forColorType(this.colorType) : this.imageType;
        return this.imageType.channelCount() * this.bitDepth;
    }

    private int getChunkLength(DataInputStream ins) throws IOException {
        return ins.readInt();
    }

    private byte[] getChunkType(InputStream ins) throws PngException {
        return this.getChunkData(ins, 4);
    }

    private byte[] getChunkData(InputStream ins, int length) throws PngException {
        byte[] data = new byte[length];
        try {
            int actual = ins.read(data);
            if (actual < length) {
                throw new PngException(String.format("Expected %d bytes but got %d", length, actual));
            }
        }
        catch (IOException e) {
            throw new PngException("Error reading chunk data", e);
        }
        return data;
    }

    private long getChunkCrc(DataInputStream ins) throws IOException {
        int i = ins.readInt();
        long crc = (long)i & 0xFFFFFFFFL;
        return crc;
    }

    private static void readSignature(DataInputStream ins) throws PngException, IOException {
        long signature = ins.readLong();
        if (signature != -8552249625308161526L) {
            throw new PngException("Bad png signature");
        }
    }
}

