/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.pngtastic.core;

import com.googlecode.pngtastic.core.PngChunk;
import com.googlecode.pngtastic.core.PngFilterType;
import com.googlecode.pngtastic.core.PngImage;
import com.googlecode.pngtastic.core.PngImageType;
import com.googlecode.pngtastic.core.PngProcessor;
import com.googlecode.pngtastic.core.processing.PngByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PngLayerer
extends PngProcessor {
    public PngLayerer() {
        this("NONE");
    }

    public PngLayerer(String logLevel) {
        super(logLevel);
    }

    public PngImage layer(PngImage baseImage, PngImage layerImage, Integer compressionLevel, boolean concurrent) throws IOException {
        this.log.debug("=== LAYERING: " + baseImage.getFileName() + ", " + layerImage.getFileName() + " ===", new Object[0]);
        long start = System.currentTimeMillis();
        if (baseImage.getInterlace() == 1 && baseImage.getSampleBitCount() < 8) {
            return baseImage;
        }
        PngImage result = new PngImage(this.log);
        result.setInterlace((short)0);
        Iterator<PngChunk> itBaseChunks = baseImage.getChunks().iterator();
        PngChunk lastBaseChunk = this.processHeadChunks(new PngImage(), itBaseChunks);
        PngByteArrayOutputStream inflatedBaseImageData = this.getInflatedImageData(lastBaseChunk, itBaseChunks);
        List<byte[]> baseImageScanlines = this.getScanlines(baseImage, inflatedBaseImageData);
        Iterator<PngChunk> itLayerChunks = layerImage.getChunks().iterator();
        PngChunk lastLayerChunk = this.processHeadChunks(result, itLayerChunks);
        PngByteArrayOutputStream inflatedLayerImageData = this.getInflatedImageData(lastLayerChunk, itLayerChunks);
        List<byte[]> layerImageScanlines = this.getScanlines(layerImage, inflatedLayerImageData);
        List<byte[]> newImageScanlines = this.doLayering(baseImage, layerImage, baseImageScanlines, layerImageScanlines);
        this.pngFilterHandler.applyFiltering(PngFilterType.NONE, newImageScanlines, layerImage.getSampleBitCount());
        byte[] imageResult = this.pngCompressionHandler.deflate(this.serialize(newImageScanlines), compressionLevel, concurrent);
        PngChunk imageChunk = new PngChunk("IDAT".getBytes(), imageResult);
        result.addChunk(imageChunk);
        this.processTailChunks(result, itBaseChunks, lastBaseChunk);
        this.log.debug("Layered in %d milliseconds", System.currentTimeMillis() - start);
        return result;
    }

    private List<byte[]> getScanlines(PngImage image, PngByteArrayOutputStream inflatedImageData) {
        int scanlineLength = Double.valueOf(Math.ceil((float)Long.valueOf(image.getWidth() * (long)image.getSampleBitCount()).longValue() / 8.0f)).intValue() + 1;
        List<byte[]> originalScanlines = image.getInterlace() == 1 ? this.pngInterlaceHandler.deInterlace((int)image.getWidth(), (int)image.getHeight(), image.getSampleBitCount(), inflatedImageData) : this.getScanlines(inflatedImageData, image.getSampleBitCount(), scanlineLength, image.getHeight());
        return originalScanlines;
    }

    private PngChunk processHeadChunks(PngImage result, Iterator<PngChunk> itChunks) throws IOException {
        PngChunk chunk = null;
        while (itChunks.hasNext() && !"IDAT".equals((chunk = itChunks.next()).getTypeString())) {
            if (!chunk.isRequired()) continue;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(chunk.getLength());
            DataOutputStream data = new DataOutputStream(bytes);
            data.write(chunk.getData());
            data.close();
            PngChunk newChunk = new PngChunk(chunk.getType(), bytes.toByteArray());
            if ("IHDR".equals(chunk.getTypeString())) {
                newChunk.setInterlace((byte)0);
            }
            result.addChunk(newChunk);
        }
        return chunk;
    }

    private PngChunk processTailChunks(PngImage result, Iterator<PngChunk> itBaseChunks, PngChunk lastBaseChunk) throws IOException {
        while (lastBaseChunk != null) {
            if (lastBaseChunk.isCritical()) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(lastBaseChunk.getLength());
                DataOutputStream data = new DataOutputStream(bytes);
                data.write(lastBaseChunk.getData());
                data.close();
                PngChunk newChunk = new PngChunk(lastBaseChunk.getType(), bytes.toByteArray());
                result.addChunk(newChunk);
            }
            lastBaseChunk = itBaseChunks.hasNext() ? itBaseChunks.next() : null;
        }
        return lastBaseChunk;
    }

    private PngByteArrayOutputStream serialize(List<byte[]> scanlines) {
        int scanlineLength = scanlines.get(0).length;
        byte[] imageData = new byte[scanlineLength * scanlines.size()];
        for (int i = 0; i < scanlines.size(); ++i) {
            int offset = i * scanlineLength;
            byte[] scanline = scanlines.get(i);
            System.arraycopy(scanline, 0, imageData, offset, scanlineLength);
        }
        return new PngByteArrayOutputStream(imageData);
    }

    private List<byte[]> doLayering(PngImage baseImage, PngImage layerImage, List<byte[]> baseRows, List<byte[]> layerRows) throws IOException {
        ArrayList<byte[]> result = new ArrayList<byte[]>(baseRows.size());
        PngImageType baseImageType = PngImageType.forColorType(baseImage.getColorType());
        PngImageType layerImageType = PngImageType.forColorType(layerImage.getColorType());
        int sampleSize = baseImage.getSampleBitCount();
        for (int rowIndex = 0; rowIndex < baseRows.size(); ++rowIndex) {
            byte[] baseRow = baseRows.get(rowIndex);
            byte[] layerRow = layerRows.get(rowIndex);
            int sampleCount = (baseRow.length - 1) * 8 / sampleSize;
            ByteArrayInputStream baseIn = new ByteArrayInputStream(baseRow);
            DataInputStream baseDin = new DataInputStream(baseIn);
            int filterByte = baseDin.readUnsignedByte();
            ByteArrayInputStream layerIn = new ByteArrayInputStream(layerRow);
            DataInputStream layerDin = new DataInputStream(layerIn);
            layerDin.readUnsignedByte();
            ByteArrayOutputStream outs = new ByteArrayOutputStream(baseRow.length);
            DataOutputStream dos = new DataOutputStream(outs);
            dos.writeByte(filterByte);
            for (int i = 0; i < sampleCount; ++i) {
                int layerBlue;
                int layerGreen;
                int layerRed;
                int baseBlue;
                int baseGreen;
                int baseRed;
                int baseAlpha = 0;
                int layerAlpha = 0;
                if (baseImage.getBitDepth() == 8) {
                    baseRed = baseDin.readUnsignedByte();
                    baseGreen = baseDin.readUnsignedByte();
                    baseBlue = baseDin.readUnsignedByte();
                } else {
                    baseRed = baseDin.readUnsignedShort();
                    baseGreen = baseDin.readUnsignedShort();
                    baseBlue = baseDin.readUnsignedShort();
                }
                baseAlpha = baseImageType == PngImageType.TRUECOLOR_ALPHA ? (baseImage.getBitDepth() == 8 ? baseDin.readUnsignedByte() : baseDin.readUnsignedShort()) : 255;
                if (layerImage.getBitDepth() == 8) {
                    layerRed = layerDin.readUnsignedByte();
                    layerGreen = layerDin.readUnsignedByte();
                    layerBlue = layerDin.readUnsignedByte();
                } else {
                    layerRed = layerDin.readUnsignedShort();
                    layerGreen = layerDin.readUnsignedShort();
                    layerBlue = layerDin.readUnsignedShort();
                }
                if (layerImageType == PngImageType.TRUECOLOR_ALPHA) {
                    int n = layerAlpha = layerImage.getBitDepth() == 8 ? layerDin.readUnsignedByte() : layerDin.readUnsignedShort();
                }
                if (layerAlpha == 0) {
                    dos.writeByte(baseRed);
                    dos.writeByte(baseGreen);
                    dos.writeByte(baseBlue);
                    dos.writeByte(baseAlpha);
                    continue;
                }
                dos.writeByte((baseRed * (255 - layerAlpha) + layerRed * layerAlpha) / 255);
                dos.writeByte((baseGreen * (255 - layerAlpha) + layerGreen * layerAlpha) / 255);
                dos.writeByte((baseBlue * (255 - layerAlpha) + layerBlue * layerAlpha) / 255);
                dos.writeByte(255);
            }
            dos.flush();
            result.add(outs.toByteArray());
        }
        return result;
    }
}

