/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.JakartaToJavaxRequestWrapper;
import org.apache.sling.models.impl.AdapterImplementations;
import org.apache.sling.models.impl.FirstImplementationPicker;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.testing.mock.osgi.MockOsgi;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.framework.BundleContext;

@ExtendWith(value={MockitoExtension.class})
class AdapterImplementationsTest {
    private static final Class<?> SAMPLE_ADAPTER = Comparable.class;
    private static final Object SAMPLE_ADAPTABLE = new Object();
    private AdapterImplementations underTest;
    @Mock
    private Resource resource;
    @Mock
    private Resource childResource;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private ResourceResolver resourceResolver;

    AdapterImplementationsTest() {
    }

    @BeforeEach
    void setUp() {
        this.underTest = new AdapterImplementations();
    }

    @Test
    void testNoMapping() {
        Assertions.assertNull((Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())));
        this.underTest.remove(SAMPLE_ADAPTER.getName(), String.class.getName());
    }

    @Test
    void testSingleMapping() {
        this.underTest.addAll(String.class, new Class[]{SAMPLE_ADAPTER});
        Assertions.assertEquals(String.class, (Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())).getType());
        this.underTest.remove(SAMPLE_ADAPTER.getName(), String.class.getName());
        Assertions.assertNull((Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())));
    }

    @Test
    void testMultipleMappings() {
        this.underTest.addAll(String.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.addAll(Integer.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.addAll(Long.class, new Class[]{SAMPLE_ADAPTER});
        Assertions.assertEquals(Integer.class, (Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())).getType());
        this.underTest.remove(SAMPLE_ADAPTER.getName(), Integer.class.getName());
        Assertions.assertEquals(Long.class, (Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())).getType());
        this.underTest.remove(SAMPLE_ADAPTER.getName(), Long.class.getName());
        this.underTest.remove(SAMPLE_ADAPTER.getName(), String.class.getName());
        Assertions.assertNull((Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())));
    }

    @Test
    void testRemoveAll() {
        this.underTest.addAll(String.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.addAll(Integer.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.addAll(Long.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.removeAll();
        Assertions.assertNull((Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())));
    }

    @Test
    void testMultipleImplementationPickers() {
        this.underTest.addAll(String.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.addAll(Integer.class, new Class[]{SAMPLE_ADAPTER});
        this.underTest.addAll(Long.class, new Class[]{SAMPLE_ADAPTER});
        Assertions.assertEquals(String.class, (Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new NoneImplementationPicker(), new LastImplementationPicker(), new FirstImplementationPicker())).getType());
    }

    @Test
    void testSimpleModel() {
        this.underTest.addAll(SAMPLE_ADAPTER, new Class[]{SAMPLE_ADAPTER});
        Assertions.assertEquals(SAMPLE_ADAPTER, (Object)this.underTest.lookup(SAMPLE_ADAPTER, SAMPLE_ADAPTABLE, Arrays.asList(new FirstImplementationPicker())).getType());
    }

    @Test
    void testResourceTypeRegistrationForResource() {
        Mockito.when((Object)this.resource.getResourceType()).thenReturn((Object)"sling/rt/one");
        Mockito.when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.childResource.getResourceType()).thenReturn((Object)"sling/rt/child");
        Mockito.when((Object)this.childResource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.resource)).thenReturn(null);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.childResource)).thenReturn((Object)"sling/rt/one");
        Mockito.when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.childResource));
        BundleContext bundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "sling/rt/one", Resource.class, String.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.childResource));
        BundleContext secondBundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(secondBundleContext.getBundle(), "sling/rt/one", Resource.class, Integer.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.childResource));
        this.underTest.removeResourceTypeBindings(bundleContext.getBundle());
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.childResource));
    }

    @Test
    void testResourceTypeRegistrationForAbsolutePath() {
        Mockito.when((Object)this.resource.getResourceType()).thenReturn((Object)"sling/rt/one");
        Mockito.when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.childResource.getResourceType()).thenReturn((Object)"sling/rt/child");
        Mockito.when((Object)this.childResource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.resource)).thenReturn(null);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.childResource)).thenReturn((Object)"sling/rt/one");
        Mockito.when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.childResource));
        BundleContext bundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "/apps/sling/rt/one", Resource.class, String.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.childResource));
        this.underTest.removeResourceTypeBindings(bundleContext.getBundle());
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.childResource));
    }

    @Test
    void testResourceTypeRegistrationForResourceHavingAbsolutePath() {
        Mockito.when((Object)this.resource.getResourceType()).thenReturn((Object)"/apps/sling/rt/one");
        Mockito.when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.childResource.getResourceType()).thenReturn((Object)"/apps/sling/rt/child");
        Mockito.when((Object)this.childResource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.resource)).thenReturn(null);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.childResource)).thenReturn((Object)"/apps/sling/rt/one");
        Mockito.when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.childResource));
        BundleContext bundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "sling/rt/one", Resource.class, String.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForResource(this.childResource));
        this.underTest.removeResourceTypeBindings(bundleContext.getBundle());
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.childResource));
    }

    @Test
    void testResourceTypeRegistrationForJakartaRequest() {
        Mockito.when((Object)this.resource.getResourceType()).thenReturn((Object)"sling/rt/one");
        Mockito.when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.resource)).thenReturn(null);
        Mockito.when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        Mockito.when((Object)this.request.getResource()).thenReturn((Object)this.resource);
        Assertions.assertNull((Object)this.underTest.getModelClassForRequest(this.request));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        BundleContext bundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "sling/rt/one", SlingJakartaHttpServletRequest.class, String.class);
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "sling/rt/one", Resource.class, Integer.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForRequest(this.request));
        Assertions.assertEquals(Integer.class, (Object)this.underTest.getModelClassForResource(this.resource));
        BundleContext secondBundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(secondBundleContext.getBundle(), "sling/rt/one", SlingJakartaHttpServletRequest.class, Integer.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForRequest(this.request));
        this.underTest.removeResourceTypeBindings(bundleContext.getBundle());
        Assertions.assertNull((Object)this.underTest.getModelClassForRequest(this.request));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
    }

    @Deprecated
    @Test
    void testResourceTypeRegistrationForJavaxRequest() {
        SlingHttpServletRequest javaxRequest = JakartaToJavaxRequestWrapper.toJavaxRequest((SlingJakartaHttpServletRequest)this.request);
        Mockito.when((Object)this.resource.getResourceType()).thenReturn((Object)"sling/rt/one");
        Mockito.when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.when((Object)this.resourceResolver.getParentResourceType(this.resource)).thenReturn(null);
        Mockito.when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        Mockito.when((Object)javaxRequest.getResource()).thenReturn((Object)this.resource);
        Assertions.assertNull((Object)this.underTest.getModelClassForRequest(javaxRequest));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
        BundleContext bundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "sling/rt/one", SlingHttpServletRequest.class, String.class);
        this.underTest.registerModelToResourceType(bundleContext.getBundle(), "sling/rt/one", Resource.class, Integer.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForRequest(javaxRequest));
        Assertions.assertEquals(Integer.class, (Object)this.underTest.getModelClassForResource(this.resource));
        BundleContext secondBundleContext = MockOsgi.newBundleContext();
        this.underTest.registerModelToResourceType(secondBundleContext.getBundle(), "sling/rt/one", SlingHttpServletRequest.class, Integer.class);
        Assertions.assertEquals(String.class, (Object)this.underTest.getModelClassForRequest(javaxRequest));
        this.underTest.removeResourceTypeBindings(bundleContext.getBundle());
        Assertions.assertNull((Object)this.underTest.getModelClassForRequest(javaxRequest));
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
    }

    @Test
    void testResourceTypeRegistrationForResourceWithoutResourceType() {
        Mockito.lenient().when((Object)this.resource.getResourceType()).thenReturn(null);
        Mockito.lenient().when((Object)this.resource.getResourceResolver()).thenReturn((Object)this.resourceResolver);
        Mockito.lenient().when((Object)this.resourceResolver.getSearchPath()).thenReturn((Object)new String[]{"/apps/", "/libs/"});
        Assertions.assertNull((Object)this.underTest.getModelClassForResource(this.resource));
    }

    static final class NoneImplementationPicker
    implements ImplementationPicker {
        NoneImplementationPicker() {
        }

        public Class<?> pick(@NotNull Class<?> adapterType, Class<?> @NotNull [] implementationsTypes, @NotNull Object adaptable) {
            return null;
        }
    }

    static final class LastImplementationPicker
    implements ImplementationPicker {
        LastImplementationPicker() {
        }

        public Class<?> pick(@NotNull Class<?> adapterType, Class<?> @NotNull [] implementationsTypes, @NotNull Object adaptable) {
            return implementationsTypes[implementationsTypes.length - 1];
        }
    }
}

