/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.classes.CachedModelWithAdapterTypes12;
import org.apache.sling.models.testmodels.classes.CachedModelWithAdapterTypes23;
import org.apache.sling.models.testmodels.interfaces.AdapterType1;
import org.apache.sling.models.testmodels.interfaces.AdapterType2;
import org.apache.sling.models.testmodels.interfaces.AdapterType3;
import org.apache.sling.models.testmodels.interfaces.CachedModel;
import org.apache.sling.models.testmodels.interfaces.UncachedModel;
import org.apache.sling.servlethelpers.MockSlingJakartaHttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class CachingTest {
    @Spy
    private MockSlingJakartaHttpServletRequest request = new MockSlingJakartaHttpServletRequest(null);
    private SlingJakartaHttpServletRequestWrapper requestWrapper;
    @Mock
    private Resource resource;
    private ModelAdapterFactory factory;

    CachingTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new RequestAttributeInjector(), new ValueMapInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{org.apache.sling.models.testmodels.classes.CachedModel.class, org.apache.sling.models.testmodels.classes.UncachedModel.class, CachedModel.class, UncachedModel.class});
        this.factory.adapterImplementations.addAll(CachedModelWithAdapterTypes12.class, new Class[]{CachedModelWithAdapterTypes12.class, AdapterType1.class, AdapterType2.class});
        this.factory.adapterImplementations.addAll(CachedModelWithAdapterTypes23.class, new Class[]{CachedModelWithAdapterTypes23.class, AdapterType2.class, AdapterType3.class});
        Mockito.lenient().when(this.request.getAttribute("testValue")).thenReturn((Object)"test");
        this.requestWrapper = new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)this.request);
        ValueMapDecorator vm = new ValueMapDecorator(Collections.singletonMap("testValue", "test"));
        Mockito.lenient().when((Object)((ValueMap)this.resource.adaptTo(ValueMap.class))).thenReturn((Object)vm);
    }

    @Test
    void testCachedClass() {
        org.apache.sling.models.testmodels.classes.CachedModel cached1 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.CachedModel.class);
        org.apache.sling.models.testmodels.classes.CachedModel cached2 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.CachedModel.class);
        Assertions.assertSame((Object)cached1, (Object)cached2);
        Assertions.assertEquals((Object)"test", (Object)cached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)cached2.getTestValue());
        ((MockSlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getAttribute("testValue");
    }

    @Test
    void testCachedClassWithResource() {
        org.apache.sling.models.testmodels.classes.CachedModel cached1 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.resource, org.apache.sling.models.testmodels.classes.CachedModel.class);
        org.apache.sling.models.testmodels.classes.CachedModel cached2 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.resource, org.apache.sling.models.testmodels.classes.CachedModel.class);
        Assertions.assertSame((Object)cached1, (Object)cached2);
        Assertions.assertEquals((Object)"test", (Object)cached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)cached2.getTestValue());
        ((Resource)Mockito.verify((Object)this.resource, (VerificationMode)Mockito.times((int)1))).adaptTo(ValueMap.class);
    }

    @Test
    void testNoCachedClass() {
        org.apache.sling.models.testmodels.classes.UncachedModel uncached1 = (org.apache.sling.models.testmodels.classes.UncachedModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.UncachedModel.class);
        org.apache.sling.models.testmodels.classes.UncachedModel uncached2 = (org.apache.sling.models.testmodels.classes.UncachedModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.UncachedModel.class);
        Assertions.assertNotSame((Object)uncached1, (Object)uncached2);
        Assertions.assertEquals((Object)"test", (Object)uncached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)uncached2.getTestValue());
        ((MockSlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getAttribute("testValue");
    }

    @Test
    void testNoCachedClassWithResource() {
        org.apache.sling.models.testmodels.classes.UncachedModel uncached1 = (org.apache.sling.models.testmodels.classes.UncachedModel)this.factory.getAdapter((Object)this.resource, org.apache.sling.models.testmodels.classes.UncachedModel.class);
        org.apache.sling.models.testmodels.classes.UncachedModel uncached2 = (org.apache.sling.models.testmodels.classes.UncachedModel)this.factory.getAdapter((Object)this.resource, org.apache.sling.models.testmodels.classes.UncachedModel.class);
        Assertions.assertNotSame((Object)uncached1, (Object)uncached2);
        Assertions.assertEquals((Object)"test", (Object)uncached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)uncached2.getTestValue());
        ((Resource)Mockito.verify((Object)this.resource, (VerificationMode)Mockito.times((int)2))).adaptTo(ValueMap.class);
    }

    @Test
    void testCachedInterface() {
        CachedModel cached1 = (CachedModel)this.factory.getAdapter((Object)this.request, CachedModel.class);
        CachedModel cached2 = (CachedModel)this.factory.getAdapter((Object)this.request, CachedModel.class);
        Assertions.assertSame((Object)cached1, (Object)cached2);
        Assertions.assertEquals((Object)"test", (Object)cached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)cached2.getTestValue());
        ((MockSlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getAttribute("testValue");
    }

    @Test
    void testNoCachedInterface() {
        UncachedModel uncached1 = (UncachedModel)this.factory.getAdapter((Object)this.request, UncachedModel.class);
        UncachedModel uncached2 = (UncachedModel)this.factory.getAdapter((Object)this.request, UncachedModel.class);
        Assertions.assertNotSame((Object)uncached1, (Object)uncached2);
        Assertions.assertEquals((Object)"test", (Object)uncached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)uncached2.getTestValue());
        ((MockSlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)2))).getAttribute("testValue");
    }

    @Test
    void testCachedClassWithRequestWrapper() {
        org.apache.sling.models.testmodels.classes.CachedModel cached1 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.CachedModel.class);
        org.apache.sling.models.testmodels.classes.CachedModel cached2 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.requestWrapper, org.apache.sling.models.testmodels.classes.CachedModel.class);
        Assertions.assertSame((Object)cached1, (Object)cached2);
        Assertions.assertEquals((Object)"test", (Object)cached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)cached2.getTestValue());
        ((MockSlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getAttribute("testValue");
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            this.request.removeAttribute((String)attributeNames.nextElement());
        }
        org.apache.sling.models.testmodels.classes.CachedModel cached3 = (org.apache.sling.models.testmodels.classes.CachedModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.CachedModel.class);
        Assertions.assertNotSame((Object)cached1, (Object)cached3);
    }

    @Test
    void testCachedInterfaceWithRequestWrapper() {
        CachedModel cached1 = (CachedModel)this.factory.getAdapter((Object)this.request, CachedModel.class);
        CachedModel cached2 = (CachedModel)this.factory.getAdapter((Object)this.requestWrapper, CachedModel.class);
        Assertions.assertSame((Object)cached1, (Object)cached2);
        Assertions.assertEquals((Object)"test", (Object)cached1.getTestValue());
        Assertions.assertEquals((Object)"test", (Object)cached2.getTestValue());
        ((MockSlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getAttribute("testValue");
    }

    @Test
    void testCachedModelWithAdapterTypes() {
        this.factory.implementationPickers = Collections.singletonList((adapterType, impls, adaptable) -> {
            if (AdapterType1.class.equals((Object)adapterType)) {
                return CachedModelWithAdapterTypes12.class;
            }
            if (AdapterType2.class.equals((Object)adapterType) || AdapterType3.class.equals((Object)adapterType)) {
                return CachedModelWithAdapterTypes23.class;
            }
            return null;
        });
        CachedModelWithAdapterTypes12 byImpl12 = (CachedModelWithAdapterTypes12)this.factory.getAdapter((Object)this.request, CachedModelWithAdapterTypes12.class);
        CachedModelWithAdapterTypes23 byImpl23 = (CachedModelWithAdapterTypes23)this.factory.getAdapter((Object)this.request, CachedModelWithAdapterTypes23.class);
        AdapterType1 byAdapterType1 = (AdapterType1)this.factory.getAdapter((Object)this.request, AdapterType1.class);
        AdapterType2 byAdapterType2 = (AdapterType2)this.factory.getAdapter((Object)this.request, AdapterType2.class);
        AdapterType3 byAdapterType3 = (AdapterType3)this.factory.getAdapter((Object)this.request, AdapterType3.class);
        Assertions.assertSame((Object)byImpl12, (Object)byAdapterType1);
        Assertions.assertSame((Object)byImpl23, (Object)byAdapterType2);
        Assertions.assertSame((Object)byImpl23, (Object)byAdapterType3);
    }
}

