/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.OSGiServiceInjector;
import org.apache.sling.models.testmodels.classes.ArrayOSGiModel;
import org.apache.sling.models.testmodels.classes.CollectionOSGiModel;
import org.apache.sling.models.testmodels.classes.ListOSGiModel;
import org.apache.sling.models.testmodels.classes.OptionalArrayOSGiModel;
import org.apache.sling.models.testmodels.classes.OptionalListOSGiModel;
import org.apache.sling.models.testmodels.classes.RequestOSGiModel;
import org.apache.sling.models.testmodels.classes.SetOSGiModel;
import org.apache.sling.models.testmodels.classes.SimpleOSGiModel;
import org.apache.sling.models.testmodels.interfaces.ServiceInterface;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;

@ExtendWith(value={MockitoExtension.class})
class OSGiInjectionTest {
    private ModelAdapterFactory factory;
    @Mock
    private BundleContext bundleContext;
    @Mock
    private SlingScriptHelper helper;
    private SlingBindings bindings = new SlingBindings();

    OSGiInjectionTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory(this.bundleContext);
        OSGiServiceInjector injectorFactory = new OSGiServiceInjector();
        injectorFactory.activate(this.bundleContext);
        this.factory.injectors = Collections.singletonList(injectorFactory);
        this.bindings.setSling(this.helper);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{SimpleOSGiModel.class, ListOSGiModel.class, RequestOSGiModel.class, ArrayOSGiModel.class, SetOSGiModel.class, OptionalListOSGiModel.class, org.apache.sling.models.testmodels.classes.constructorinjection.ListOSGiModel.class, org.apache.sling.models.testmodels.classes.constructorinjection.SimpleOSGiModel.class, CollectionOSGiModel.class, OptionalArrayOSGiModel.class});
    }

    @Test
    void testSimpleOSGiModelField() throws Exception {
        ServiceReference ref = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        Mockito.when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref});
        ((BundleContext)Mockito.doReturn((Object)service).when((Object)this.bundleContext)).getService(ref);
        Resource res = (Resource)Mockito.mock(Resource.class);
        SimpleOSGiModel model = (SimpleOSGiModel)this.factory.getAdapter((Object)res, SimpleOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull((Object)model.getService());
        Assertions.assertEquals((Object)service, (Object)model.getService());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testListOSGiModelField() throws Exception {
        ServiceReference ref1 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service1 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service1).when((Object)this.bundleContext)).getService(ref1);
        ServiceReference ref2 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service2 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service2).when((Object)this.bundleContext)).getService(ref2);
        Mockito.when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref1, ref2});
        Resource res = (Resource)Mockito.mock(Resource.class);
        ListOSGiModel model = (ListOSGiModel)this.factory.getAdapter((Object)res, ListOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull(model.getServices());
        MatcherAssert.assertThat(model.getServices(), (Matcher)Matchers.containsInAnyOrder((Object[])new ServiceInterface[]{service1, service2}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testArrayOSGiModelField() throws Exception {
        ServiceReference ref1 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service1 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service1).when((Object)this.bundleContext)).getService(ref1);
        ServiceReference ref2 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service2 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service2).when((Object)this.bundleContext)).getService(ref2);
        Mockito.when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref1, ref2});
        Resource res = (Resource)Mockito.mock(Resource.class);
        ArrayOSGiModel model = (ArrayOSGiModel)this.factory.getAdapter((Object)res, ArrayOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull((Object)model.getServices());
        MatcherAssert.assertThat(Arrays.asList(model.getServices()), (Matcher)Matchers.containsInAnyOrder((Object[])new ServiceInterface[]{service1, service2}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testOptionalArrayOSGiModelField() {
        Resource res = (Resource)Mockito.mock(Resource.class);
        OptionalArrayOSGiModel model = (OptionalArrayOSGiModel)this.factory.getAdapter((Object)res, OptionalArrayOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNull((Object)model.getServices());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testOptionalListOSGiModelField() {
        Resource res = (Resource)Mockito.mock(Resource.class);
        OptionalListOSGiModel model = (OptionalListOSGiModel)this.factory.getAdapter((Object)res, OptionalListOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNull(model.getServices());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testCollectionOSGiModelField() throws Exception {
        ServiceReference ref1 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service1 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service1).when((Object)this.bundleContext)).getService(ref1);
        ServiceReference ref2 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service2 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service2).when((Object)this.bundleContext)).getService(ref2);
        Mockito.when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref1, ref2});
        Resource res = (Resource)Mockito.mock(Resource.class);
        CollectionOSGiModel model = (CollectionOSGiModel)this.factory.getAdapter((Object)res, CollectionOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull(model.getServices());
        MatcherAssert.assertThat(model.getServices(), (Matcher)Matchers.containsInAnyOrder((Object[])new ServiceInterface[]{service1, service2}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testSetOSGiModelField() throws Exception {
        ServiceReference ref1 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service1 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.lenient().doReturn((Object)service1).when((Object)this.bundleContext)).getService(ref1);
        ServiceReference ref2 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service2 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.lenient().doReturn((Object)service2).when((Object)this.bundleContext)).getService(ref2);
        Mockito.lenient().when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref1, ref2});
        Resource res = (Resource)Mockito.mock(Resource.class);
        SetOSGiModel model = (SetOSGiModel)this.factory.getAdapter((Object)res, SetOSGiModel.class);
        Assertions.assertNull((Object)model);
        ((BundleContext)Mockito.verify((Object)this.bundleContext)).registerService((Class)ArgumentMatchers.eq(Runnable.class), (Object)((Runnable)ArgumentMatchers.eq((Object)this.factory)), (Dictionary)ArgumentMatchers.any(Dictionary.class));
        ((BundleContext)Mockito.verify((Object)this.bundleContext)).addBundleListener((BundleListener)ArgumentMatchers.any(BundleListener.class));
        ((BundleContext)Mockito.verify((Object)this.bundleContext)).registerService((Class)ArgumentMatchers.eq(Object.class), ArgumentMatchers.any(Object.class), (Dictionary)ArgumentMatchers.any(Dictionary.class));
        ((BundleContext)Mockito.verify((Object)this.bundleContext)).getBundles();
        ((BundleContext)Mockito.verify((Object)this.bundleContext)).getBundle();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res, this.bundleContext});
    }

    @Test
    void testSimpleOSGiModelConstructor() throws Exception {
        ServiceReference ref = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        Mockito.when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref});
        ((BundleContext)Mockito.doReturn((Object)service).when((Object)this.bundleContext)).getService(ref);
        Resource res = (Resource)Mockito.mock(Resource.class);
        org.apache.sling.models.testmodels.classes.constructorinjection.SimpleOSGiModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.SimpleOSGiModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.constructorinjection.SimpleOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull((Object)model.getService());
        Assertions.assertEquals((Object)service, (Object)model.getService());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }

    @Test
    void testListOSGiModelConstructor() throws Exception {
        ServiceReference ref1 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service1 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service1).when((Object)this.bundleContext)).getService(ref1);
        ServiceReference ref2 = (ServiceReference)Mockito.mock(ServiceReference.class);
        ServiceInterface service2 = (ServiceInterface)Mockito.mock(ServiceInterface.class);
        ((BundleContext)Mockito.doReturn((Object)service2).when((Object)this.bundleContext)).getService(ref2);
        Mockito.when((Object)this.bundleContext.getServiceReferences(ServiceInterface.class.getName(), null)).thenReturn((Object)new ServiceReference[]{ref1, ref2});
        Resource res = (Resource)Mockito.mock(Resource.class);
        org.apache.sling.models.testmodels.classes.constructorinjection.ListOSGiModel model = (org.apache.sling.models.testmodels.classes.constructorinjection.ListOSGiModel)this.factory.getAdapter((Object)res, org.apache.sling.models.testmodels.classes.constructorinjection.ListOSGiModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertNotNull(model.getServices());
        MatcherAssert.assertThat(model.getServices(), (Matcher)Matchers.containsInAnyOrder((Object[])new ServiceInterface[]{service1, service2}));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{res});
    }
}

