/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.classes.ChildModel;
import org.apache.sling.models.testmodels.classes.constructorinjection.ParentModel;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;

@ExtendWith(value={MockitoExtension.class})
class ResourceModelConstructorTest {
    private ModelAdapterFactory factory;

    ResourceModelConstructorTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new ChildResourceInjector(), new ValueMapInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ParentModel.class, ChildModel.class});
    }

    @Test
    void testChildModel() {
        String firstValue = RandomStringUtils.secureStrong().nextAlphabetic(10);
        ValueMapDecorator firstMap = new ValueMapDecorator(Collections.singletonMap("property", firstValue));
        Resource firstChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)firstChild.adaptTo(ValueMap.class))).thenReturn((Object)firstMap);
        Mockito.lenient().when((Object)((ChildModel)firstChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        String firstGrandChildValue = RandomStringUtils.secureStrong().nextAlphabetic(10);
        ValueMapDecorator firstGrandChildMap = new ValueMapDecorator(Collections.singletonMap("property", firstGrandChildValue));
        String secondGrandChildValue = RandomStringUtils.secureStrong().nextAlphabetic(10);
        ValueMapDecorator secondGrandChildMap = new ValueMapDecorator(Collections.singletonMap("property", secondGrandChildValue));
        Resource firstGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)firstGrandChild.adaptTo(ValueMap.class))).thenReturn((Object)firstGrandChildMap);
        Mockito.lenient().when((Object)((ChildModel)firstGrandChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        Resource secondGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)secondGrandChild.adaptTo(ValueMap.class))).thenReturn((Object)secondGrandChildMap);
        Mockito.lenient().when((Object)((ChildModel)secondGrandChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        Resource secondChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)secondChild.listChildren()).thenReturn(Arrays.asList(firstGrandChild, secondGrandChild).iterator());
        Resource emptyChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)emptyChild.listChildren()).thenReturn(Collections.emptySet().iterator());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)res.getChild("firstChild")).thenReturn((Object)firstChild);
        Mockito.lenient().when((Object)res.getChild("secondChild")).thenReturn((Object)secondChild);
        Mockito.lenient().when((Object)res.getChild("emptyChild")).thenReturn((Object)emptyChild);
        ParentModel model = (ParentModel)this.factory.getAdapter((Object)res, ParentModel.class);
        Assert.assertNotNull((Object)model);
        ChildModel childModel = model.getFirstChild();
        Assert.assertNotNull((Object)childModel);
        Assert.assertEquals((Object)firstValue, (Object)childModel.getProperty());
        Assert.assertEquals((long)2L, (long)model.getGrandChildren().size());
        Assert.assertEquals((Object)firstGrandChildValue, (Object)model.getGrandChildren().get(0).getProperty());
        Assert.assertEquals((Object)secondGrandChildValue, (Object)model.getGrandChildren().get(1).getProperty());
        Assert.assertEquals((long)0L, (long)model.getEmptyGrandChildren().size());
    }

    private class AdaptToChildModel
    implements Answer<ChildModel> {
        private AdaptToChildModel() {
        }

        public ChildModel answer(InvocationOnMock invocation) throws Throwable {
            return (ChildModel)ResourceModelConstructorTest.this.factory.getAdapter(invocation.getMock(), ChildModel.class);
        }
    }
}

