/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing.rtbound;

import java.util.HashMap;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.factory.ModelFactory;
import org.apache.sling.models.it.testbundle.rtbound.BaseComponent;
import org.apache.sling.models.it.testbundle.rtbound.ExtendedComponent;
import org.apache.sling.models.it.testbundle.rtbound.FromRequestComponent;
import org.apache.sling.models.it.testing.rtbound.FakeRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ResourceTypeBindingIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ResourceResolverFactory rrFactory;
    private ModelFactory modelFactory;
    private final String baseComponentPath = "/content/rt/baseComponent";
    private final String childComponentPath = "/content/rt/childComponent";
    private final String child2ComponentPath = "/content/rt/child2Component";
    private final String extendedComponentPath = "/content/rt/extendedComponent";
    private final String fromRequestComponentPath = "/content/rt/fromRequest";

    @Before
    public void setup() throws LoginException, PersistenceException {
        this.rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        this.modelFactory = (ModelFactory)this.teleporter.getService(ModelFactory.class);
        try (ResourceResolver adminResolver = this.rrFactory.getServiceResourceResolver(null);){
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("sampleValue", "baseTESTValue");
            properties.put("sling:resourceType", "sling/rt/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rt/baseComponent", properties, null, (boolean)false);
            properties.clear();
            properties.put("sampleValue", "childTESTValue");
            properties.put("sling:resourceType", "sling/rt/child");
            properties.put("sling:resourceSuperType", "sling/rt/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rt/childComponent", properties, null, (boolean)false);
            properties.clear();
            properties.put("sampleValue", "childTESTValue2");
            properties.put("sling:resourceType", "sling/rt/child");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rt/child2Component", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceSuperType", "sling/rt/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/apps/sling/rt/child", properties, null, (boolean)false);
            properties.clear();
            properties.put("sampleValue", "extendedTESTValue");
            properties.put("sling:resourceType", "sling/rt/extended");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rt/extendedComponent", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceType", "sling/rt/fromRequest");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rt/fromRequest", properties, null, (boolean)false);
            adminResolver.commit();
        }
    }

    @Test
    public void testClientModelCreateFromResource() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource baseComponentResource = resolver.getResource("/content/rt/baseComponent");
            Assert.assertNotNull((Object)baseComponentResource);
            Object baseModel = this.modelFactory.getModelFromResource(baseComponentResource);
            Assert.assertNotNull((String)"Model should not be null", (Object)baseModel);
            Assert.assertTrue((String)"Model should be a BaseComponent", (boolean)(baseModel instanceof BaseComponent));
            Resource childComponentResource = resolver.getResource("/content/rt/childComponent");
            Assert.assertNotNull((Object)childComponentResource);
            Object childModel = this.modelFactory.getModelFromResource(childComponentResource);
            Assert.assertNotNull((String)"Model should not be null", (Object)childModel);
            Assert.assertTrue((String)"Model should be a BaseComponent", (boolean)(childModel instanceof BaseComponent));
            Resource child2ComponentResource = resolver.getResource("/content/rt/child2Component");
            Assert.assertNotNull((Object)child2ComponentResource);
            Object child2Model = this.modelFactory.getModelFromResource(child2ComponentResource);
            Assert.assertNotNull((String)"Model should not be null", (Object)child2Model);
            Assert.assertTrue((String)"Model should be a BaseComponent", (boolean)(child2Model instanceof BaseComponent));
            Resource extendedComponentResource = resolver.getResource("/content/rt/extendedComponent");
            Assert.assertNotNull((Object)extendedComponentResource);
            Object extendedModel = this.modelFactory.getModelFromResource(extendedComponentResource);
            Assert.assertNotNull((String)"Model should not be null", (Object)extendedModel);
            Assert.assertTrue((String)"Model should be a BaseComponent", (boolean)(extendedModel instanceof BaseComponent));
            Assert.assertTrue((String)"Model should be an ExtendedComponent", (boolean)(extendedModel instanceof ExtendedComponent));
        }
    }

    @Test
    public void testClientModelCreateFromRequest() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource baseComponentResource = resolver.getResource("/content/rt/fromRequest");
            Assert.assertNotNull((Object)baseComponentResource);
            Object baseModel = this.modelFactory.getModelFromRequest((SlingHttpServletRequest)new FakeRequest(baseComponentResource));
            Assert.assertNotNull((String)"Model should not be null", (Object)baseModel);
            Assert.assertTrue((String)"Model should be a FromRequestComponent", (boolean)(baseModel instanceof FromRequestComponent));
        }
    }
}

