/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;

class BundledScriptContext
extends SimpleScriptContext {
    private static final Integer[] SCOPES = new Integer[]{-314, 200, 100};
    private Bindings globalScope = new SimpleBindings();
    private Bindings engineScope = new SimpleBindings();
    private Bindings slingScope = new SimpleBindings();

    BundledScriptContext() {
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        if (bindings == null) {
            throw new NullPointerException("None of the ScriptContext scopes accepts null bindings.");
        }
        switch (scope) {
            case -314: {
                this.slingScope = bindings;
                break;
            }
            case 100: {
                this.engineScope = bindings;
                break;
            }
            case 200: {
                this.globalScope = bindings;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid scope.");
            }
        }
    }

    @Override
    public Bindings getBindings(int scope) {
        switch (scope) {
            case -314: {
                return this.slingScope;
            }
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return this.globalScope;
            }
        }
        throw new IllegalArgumentException("Invalid scope.");
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null.");
        }
        Bindings bindings = this.getBindings(scope);
        if (bindings != null) {
            bindings.put(name, value);
        }
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        Integer[] integerArray = SCOPES;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            Object o;
            int scope = integerArray[i];
            Bindings bindings = this.getBindings(scope);
            if (bindings == null || (o = bindings.get(name)) == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null.");
        }
        Bindings bindings = this.getBindings(scope);
        if (bindings != null) {
            return bindings.get(name);
        }
        return null;
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null.");
        }
        Bindings bindings = this.getBindings(scope);
        if (bindings != null) {
            return bindings.remove(name);
        }
        return null;
    }

    @Override
    public int getAttributesScope(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null.");
        }
        Integer[] integerArray = SCOPES;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int scope = integerArray[i];
            if (this.getBindings(scope) == null || !this.getBindings(scope).containsKey(name)) continue;
            return scope;
        }
        return -1;
    }

    @Override
    public List<Integer> getScopes() {
        return Arrays.asList(SCOPES);
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }

    @Override
    public Reader getReader() {
        return this.reader;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

