/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.js.impl;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.scripting.core.ScriptNameAwareReader;
import org.apache.sling.scripting.sightly.SightlyException;
import org.apache.sling.scripting.sightly.js.impl.Console;
import org.apache.sling.scripting.sightly.js.impl.async.AsyncContainer;
import org.apache.sling.scripting.sightly.js.impl.async.TimingBindingsValuesProvider;
import org.apache.sling.scripting.sightly.js.impl.async.UnaryCallback;
import org.apache.sling.scripting.sightly.js.impl.cjs.CommonJsModule;
import org.apache.sling.scripting.sightly.js.impl.loop.EventLoop;
import org.apache.sling.scripting.sightly.js.impl.loop.EventLoopInterop;
import org.apache.sling.scripting.sightly.js.impl.loop.Task;
import org.apache.sling.scripting.sightly.js.impl.use.DependencyResolver;
import org.apache.sling.scripting.sightly.js.impl.use.UseFunction;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.Context;
import org.slf4j.LoggerFactory;

public class JsEnvironment {
    private final ScriptEngine jsEngine;
    private final Bindings engineBindings;
    private final DependencyResolver dependencyResolver;
    private EventLoop eventLoop;

    public JsEnvironment(@NotNull ScriptEngine jsEngine, @NotNull DependencyResolver dependencyResolver) {
        this.jsEngine = jsEngine;
        this.dependencyResolver = dependencyResolver;
        this.engineBindings = new LazyBindings();
        TimingBindingsValuesProvider.INSTANCE.addBindings(this.engineBindings);
    }

    public void initialize() {
        Context context = Context.enter();
        this.eventLoop = EventLoopInterop.obtainEventLoop(context);
    }

    public void cleanup() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            throw new IllegalStateException("No current context");
        }
        EventLoopInterop.cleanupEventLoop(context);
        Context.exit();
    }

    public void runScript(ScriptNameAwareReader reader, Bindings globalBindings, Bindings arguments, UnaryCallback callback) {
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        CommonJsModule module = new CommonJsModule();
        Bindings scriptBindings = this.buildBindings(reader, globalBindings, arguments, module);
        scriptContext.setBindings(scriptBindings, 100);
        this.runScript(reader, scriptContext, callback);
    }

    public AsyncContainer runScript(ScriptNameAwareReader reader, Bindings globalBindings, Bindings arguments) {
        AsyncContainer asyncContainer = new AsyncContainer();
        this.runScript(reader, globalBindings, arguments, asyncContainer.createCompletionCallback());
        return asyncContainer;
    }

    private Bindings buildBindings(ScriptNameAwareReader reader, Bindings globalBindings, Bindings arguments, CommonJsModule commonJsModule) {
        LazyBindings bindings = new LazyBindings();
        bindings.putAll(globalBindings);
        bindings.putAll(this.engineBindings);
        bindings.put("javax.script.filename", (Object)reader.getScriptName());
        bindings.put("module", (Object)commonJsModule);
        bindings.put("exports", commonJsModule.getExports());
        bindings.put("console", (Object)new Console(LoggerFactory.getLogger((String)reader.getScriptName())));
        UseFunction useFunction = new UseFunction(this, this.dependencyResolver, (Bindings)bindings, arguments);
        bindings.put("use", (Object)useFunction);
        return bindings;
    }

    private void runScript(ScriptNameAwareReader reader, ScriptContext scriptContext, UnaryCallback callback) {
        this.eventLoop.schedule(this.scriptTask(reader, scriptContext, callback));
    }

    private Task scriptTask(ScriptNameAwareReader reader, ScriptContext scriptContext, UnaryCallback callback) {
        return new Task(() -> {
            try {
                CommonJsModule commonJsModule;
                Object result = this.jsEngine instanceof Compilable ? ((Compilable)((Object)this.jsEngine)).compile((Reader)reader).eval(scriptContext) : this.jsEngine.eval((Reader)reader, scriptContext);
                if (result == null && (commonJsModule = (CommonJsModule)((Object)((Object)scriptContext.getBindings(100).get("module")))) != null && commonJsModule.isModified()) {
                    result = commonJsModule.getExports();
                }
                if (result instanceof AsyncContainer) {
                    ((AsyncContainer)result).addListener(callback);
                } else {
                    callback.invoke(result);
                }
            }
            catch (ScriptException e) {
                throw new SightlyException((Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        });
    }
}

