/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMLeveldbStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMNullStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.security.NMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.nodemanager.webapp.WebServer;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;

public class NodeManager
extends CompositeService
implements EventHandler<NodeManagerEvent> {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(NodeManager.class);
    protected final NodeManagerMetrics metrics = NodeManagerMetrics.create();
    private ApplicationACLsManager aclsManager;
    private NodeHealthCheckerService nodeHealthChecker;
    private LocalDirsHandlerService dirsHandler;
    private Context context;
    private AsyncDispatcher dispatcher;
    private ContainerManagerImpl containerManager;
    private NodeStatusUpdater nodeStatusUpdater;
    private static CompositeService.CompositeServiceShutdownHook nodeManagerShutdownHook;
    private NMStateStoreService nmStore = null;
    private AtomicBoolean isStopping = new AtomicBoolean(false);
    private boolean rmWorkPreservingRestartEnabled;

    public NodeManager() {
        super(NodeManager.class.getName());
    }

    protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
        return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics);
    }

    protected NodeResourceMonitor createNodeResourceMonitor() {
        return new NodeResourceMonitorImpl();
    }

    protected ContainerManagerImpl createContainerManager(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new ContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, aclsManager, dirsHandler);
    }

    protected WebServer createWebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new WebServer(nmContext, resourceView, aclsManager, dirsHandler);
    }

    protected DeletionService createDeletionService(ContainerExecutor exec) {
        return new DeletionService(exec, this.nmStore);
    }

    protected NMContext createNMContext(NMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInNM nmTokenSecretManager, NMStateStoreService stateStore) {
        return new NMContext(containerTokenSecretManager, nmTokenSecretManager, this.dirsHandler, this.aclsManager, stateStore);
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.getConfig(), (String)"yarn.nodemanager.keytab", (String)"yarn.nodemanager.principal");
    }

    private void initAndStartRecoveryStore(Configuration conf) throws IOException {
        boolean recoveryEnabled = conf.getBoolean("yarn.nodemanager.recovery.enabled", false);
        if (recoveryEnabled) {
            LocalFileSystem recoveryFs = FileSystem.getLocal((Configuration)conf);
            String recoveryDirName = conf.get("yarn.nodemanager.recovery.dir");
            if (recoveryDirName == null) {
                throw new IllegalArgumentException("Recovery is enabled but yarn.nodemanager.recovery.dir is not set.");
            }
            Path recoveryRoot = new Path(recoveryDirName);
            recoveryFs.mkdirs(recoveryRoot, new FsPermission(448));
            this.nmStore = new NMLeveldbStateStoreService();
        } else {
            this.nmStore = new NMNullStateStoreService();
        }
        this.nmStore.init(conf);
        this.nmStore.start();
    }

    private void stopRecoveryStore() throws IOException {
        this.nmStore.stop();
        if (this.context.getDecommissioned() && this.nmStore.canRecover()) {
            LOG.info((Object)"Removing state store due to decommission");
            Configuration conf = this.getConfig();
            Path recoveryRoot = new Path(conf.get("yarn.nodemanager.recovery.dir"));
            LOG.info((Object)("Removing state store at " + recoveryRoot + " due to decommission"));
            LocalFileSystem recoveryFs = FileSystem.getLocal((Configuration)conf);
            if (!recoveryFs.delete(recoveryRoot, true)) {
                LOG.warn((Object)("Unable to delete " + recoveryRoot));
            }
        }
    }

    private void recoverTokens(NMTokenSecretManagerInNM nmTokenSecretManager, NMContainerTokenSecretManager containerTokenSecretManager) throws IOException {
        if (this.nmStore.canRecover()) {
            nmTokenSecretManager.recover();
            containerTokenSecretManager.recover();
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        conf.setBoolean("yarn.dispatcher.exit-on-error", true);
        this.rmWorkPreservingRestartEnabled = conf.getBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        this.initAndStartRecoveryStore(conf);
        NMContainerTokenSecretManager containerTokenSecretManager = new NMContainerTokenSecretManager(conf, this.nmStore);
        NMTokenSecretManagerInNM nmTokenSecretManager = new NMTokenSecretManagerInNM(this.nmStore);
        this.recoverTokens(nmTokenSecretManager, containerTokenSecretManager);
        this.aclsManager = new ApplicationACLsManager(conf);
        ContainerExecutor exec = (ContainerExecutor)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class), (Configuration)conf);
        try {
            exec.init();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to initialize container executor", (Throwable)e);
        }
        DeletionService del = this.createDeletionService(exec);
        this.addService((Service)del);
        this.dispatcher = new AsyncDispatcher();
        this.nodeHealthChecker = new NodeHealthCheckerService();
        this.addService((Service)this.nodeHealthChecker);
        this.dirsHandler = this.nodeHealthChecker.getDiskHandler();
        this.context = this.createNMContext(containerTokenSecretManager, nmTokenSecretManager, this.nmStore);
        this.nodeStatusUpdater = this.createNodeStatusUpdater(this.context, (Dispatcher)this.dispatcher, this.nodeHealthChecker);
        NodeResourceMonitor nodeResourceMonitor = this.createNodeResourceMonitor();
        this.addService(nodeResourceMonitor);
        this.containerManager = this.createContainerManager(this.context, exec, del, this.nodeStatusUpdater, this.aclsManager, this.dirsHandler);
        this.addService((Service)this.containerManager);
        ((NMContext)this.context).setContainerManager(this.containerManager);
        WebServer webServer = this.createWebServer(this.context, this.containerManager.getContainersMonitor(), this.aclsManager, this.dirsHandler);
        this.addService((Service)webServer);
        ((NMContext)this.context).setWebServer(webServer);
        this.dispatcher.register(ContainerManagerEventType.class, (EventHandler)this.containerManager);
        this.dispatcher.register(NodeManagerEventType.class, (EventHandler)this);
        this.addService((Service)this.dispatcher);
        DefaultMetricsSystem.initialize((String)"NodeManager");
        this.addService(this.nodeStatusUpdater);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed NodeManager login", (Throwable)e);
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        super.serviceStop();
        this.stopRecoveryStore();
        DefaultMetricsSystem.shutdown();
    }

    public String getName() {
        return "NodeManager";
    }

    protected void shutDown() {
        new Thread(){

            @Override
            public void run() {
                NodeManager.this.stop();
            }
        }.start();
    }

    protected void resyncWithRM() {
        new Thread(){

            @Override
            public void run() {
                try {
                    LOG.info((Object)"Notifying ContainerManager to block new container-requests");
                    NodeManager.this.containerManager.setBlockNewContainerRequests(true);
                    if (!NodeManager.this.rmWorkPreservingRestartEnabled) {
                        LOG.info((Object)"Cleaning up running containers on resync");
                        NodeManager.this.containerManager.cleanupContainersOnNMResync();
                    } else {
                        LOG.info((Object)"Preserving containers on resync");
                    }
                    ((NodeStatusUpdaterImpl)NodeManager.this.nodeStatusUpdater).rebootNodeStatusUpdaterAndRegisterWithRM();
                }
                catch (YarnRuntimeException e) {
                    LOG.fatal((Object)"Error while rebooting NodeStatusUpdater.", (Throwable)e);
                    NodeManager.this.shutDown();
                }
            }
        }.start();
    }

    public NodeHealthCheckerService getNodeHealthChecker() {
        return this.nodeHealthChecker;
    }

    private void initAndStartNodeManager(Configuration conf, boolean hasToReboot) {
        try {
            if (hasToReboot && null != nodeManagerShutdownHook) {
                ShutdownHookManager.get().removeShutdownHook((Runnable)nodeManagerShutdownHook);
            }
            nodeManagerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)this);
            ShutdownHookManager.get().addShutdownHook((Runnable)nodeManagerShutdownHook, 30);
            this.init(conf);
            this.start();
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting NodeManager", t);
            System.exit(-1);
        }
    }

    public void handle(NodeManagerEvent event) {
        switch ((NodeManagerEventType)event.getType()) {
            case SHUTDOWN: {
                this.shutDown();
                break;
            }
            case RESYNC: {
                this.resyncWithRM();
                break;
            }
            default: {
                LOG.warn((Object)("Invalid shutdown event " + event.getType() + ". Ignoring."));
            }
        }
    }

    NodeManager createNewNodeManager() {
        return new NodeManager();
    }

    ContainerManagerImpl getContainerManager() {
        return this.containerManager;
    }

    Dispatcher getNMDispatcher() {
        return this.dispatcher;
    }

    @VisibleForTesting
    public Context getNMContext() {
        return this.context;
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(NodeManager.class, (String[])args, (Log)LOG);
        NodeManager nodeManager = new NodeManager();
        YarnConfiguration conf = new YarnConfiguration();
        nodeManager.initAndStartNodeManager((Configuration)conf, false);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public NodeStatusUpdater getNodeStatusUpdater() {
        return this.nodeStatusUpdater;
    }

    public static class NMContext
    implements Context {
        private NodeId nodeId = null;
        protected final ConcurrentMap<ApplicationId, Application> applications = new ConcurrentHashMap<ApplicationId, Application>();
        private volatile Map<ApplicationId, Credentials> systemCredentials = new HashMap<ApplicationId, Credentials>();
        protected final ConcurrentMap<ContainerId, Container> containers = new ConcurrentSkipListMap<ContainerId, Container>();
        private final NMContainerTokenSecretManager containerTokenSecretManager;
        private final NMTokenSecretManagerInNM nmTokenSecretManager;
        private ContainerManagementProtocol containerManager;
        private final LocalDirsHandlerService dirsHandler;
        private final ApplicationACLsManager aclsManager;
        private WebServer webServer;
        private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeHealthStatus.class);
        private final NMStateStoreService stateStore;
        private boolean isDecommissioned = false;

        public NMContext(NMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInNM nmTokenSecretManager, LocalDirsHandlerService dirsHandler, ApplicationACLsManager aclsManager, NMStateStoreService stateStore) {
            this.containerTokenSecretManager = containerTokenSecretManager;
            this.nmTokenSecretManager = nmTokenSecretManager;
            this.dirsHandler = dirsHandler;
            this.aclsManager = aclsManager;
            this.nodeHealthStatus.setIsNodeHealthy(true);
            this.nodeHealthStatus.setHealthReport("Healthy");
            this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
            this.stateStore = stateStore;
        }

        @Override
        public NodeId getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getHttpPort() {
            return this.webServer.getPort();
        }

        @Override
        public ConcurrentMap<ApplicationId, Application> getApplications() {
            return this.applications;
        }

        @Override
        public ConcurrentMap<ContainerId, Container> getContainers() {
            return this.containers;
        }

        @Override
        public NMContainerTokenSecretManager getContainerTokenSecretManager() {
            return this.containerTokenSecretManager;
        }

        @Override
        public NMTokenSecretManagerInNM getNMTokenSecretManager() {
            return this.nmTokenSecretManager;
        }

        @Override
        public NodeHealthStatus getNodeHealthStatus() {
            return this.nodeHealthStatus;
        }

        @Override
        public ContainerManagementProtocol getContainerManager() {
            return this.containerManager;
        }

        public void setContainerManager(ContainerManagementProtocol containerManager) {
            this.containerManager = containerManager;
        }

        public void setWebServer(WebServer webServer) {
            this.webServer = webServer;
        }

        public void setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public LocalDirsHandlerService getLocalDirsHandler() {
            return this.dirsHandler;
        }

        @Override
        public ApplicationACLsManager getApplicationACLsManager() {
            return this.aclsManager;
        }

        @Override
        public NMStateStoreService getNMStateStore() {
            return this.stateStore;
        }

        @Override
        public boolean getDecommissioned() {
            return this.isDecommissioned;
        }

        @Override
        public void setDecommissioned(boolean isDecommissioned) {
            this.isDecommissioned = isDecommissioned;
        }

        @Override
        public Map<ApplicationId, Credentials> getSystemCredentialsForApps() {
            return this.systemCredentials;
        }

        public void setSystemCrendentialsForApps(Map<ApplicationId, Credentials> systemCredentials) {
            this.systemCredentials = systemCredentials;
        }
    }
}

